/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.glib.Boxed;

/**
 * Key bindings for individual widgets
 */
public class BindingSet extends Boxed {
	
	/**
	 * Construct a new BindingSet object.
	 * @param setName
	 */
	public BindingSet(String setName) {
		handle = gtk_binding_set_new(setName);
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_binding_set_new(String setName);
	native static final protected int gtk_binding_set_find(String setName);
	native static final protected boolean gtk_bindings_activate(int object, int keyval, int modifier);
	native static final protected boolean gtk_binding_set_activate(int bindingSet, int keyval, int modifier, int object);
	native static final protected void gtk_binding_entry_clear(int bindingSet, int keyval, int modifier);
	native static final protected void gtk_binding_set_add_path(int bindingSet, int pathType, String pathPattern, int priority);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
