/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
/**
 * This class takes care of handling application and library
 * initialization and command line parsing.
 */
public class Program extends Boxed {

	protected Program(Handle handle) {
		super(handle);
	}

	/**
	 * Initialize the gnome application specifying the directories
	 * used by the app.
	 */
	public static Program initGnomeUI(String appId, String appVersion, String[] argv, String prefix, String sysconfdir, String datadir, String libdir) {
		Handle handle = initLibgnome(appId, appVersion, argv.length + 1, makeArgv(argv), prefix, sysconfdir, datadir, libdir, 0);
		return new Program(handle);
	}

	/**
	 * Initialize the gnome application using the default directories
	 * for the app.
	 */
	public static Program initGnomeUI(String appId, String appVersion, String[] argv) {
		Handle handle = initLibgnome(appId, appVersion, argv.length + 1, makeArgv(argv), "","","","", 0);
		return new Program(handle);
	}

	/**
	 * Initialize the gnome application specifying the directories
	 * use by the app.
	 */
	public static Program initGnome(String appId, String appVersion, String[] argv, String prefix, String sysconfdir, String datadir, String libdir) {
		Handle handle = initLibgnome(appId, appVersion, argv.length + 1, makeArgv(argv), prefix, sysconfdir, datadir, libdir, 1);
		return new Program(handle);
	}

	/**
	 * Initialize the gnome application using the default directories
	 * for the app.
	 */
	public static Program initGnome(String appId, String appVersion, String[] argv) {
		Handle handle = initLibgnome(appId, appVersion, argv.length + 1, makeArgv(argv), "","","","", 1);
		return new Program(handle);
	}

	public String getAppID() {
		return gnome_program_get_app_id(getHandle());
	}

	public String getName() {
		return gnome_program_get_human_readable_name(getHandle());
	}

	public String getVersion() {
		return gnome_program_get_app_version(getHandle());
	}

	// Load the library
	static {
		System.loadLibrary ("gtkjni-2.6");
        System.loadLibrary ("gnomejni-2.10");
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_program_get_type());
	}
	
	private static String[] makeArgv(String[] orig) {
		String appName = System.getProperty("gnome.appName", "java-gnome");

		if (orig == null) {
			orig = new String[] { appName };
		} else {
			String[] newArr = new String[orig.length + 1];
			System.arraycopy(orig, 0, newArr, 1, orig.length);
			newArr[0] = appName;
			orig = newArr;
		}
		return orig;
	}


	native static private Handle initLibgnome(String appId, String appVersion, int argc, String[] argv, String prefix, String sysconfdir, String datadir, String libdir, int type);
	native static final protected int gnome_program_get_type();
	native static final protected Handle gnome_program_get();
	native static final protected String gnome_program_get_human_readable_name(Handle program);
	native static final protected String gnome_program_get_app_id(Handle program);
	native static final protected String gnome_program_get_app_version(Handle program);
	native static final protected void gnome_program_module_register(Handle moduleInfo);
	native static final protected boolean gnome_program_module_registered(Handle moduleInfo);
	native static final protected Handle gnome_program_module_load(String modName);

}
