/* iagno.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	GtkHeaderBar* headerbar;
	GameView* view;
	GtkLabel* dark_label;
	GtkLabel* dark_score_label;
	GtkLabel* light_label;
	GtkLabel* light_score_label;
	GtkDialog* propbox;
	ComputerPlayer* computer;
	Player player_one;
	guint computer_timer;
	Game* game;
};

struct _Block2Data {
	int _ref_count_;
	Iagno* self;
	GtkComboBox* combo;
	GtkComboBox* level_combo;
	GtkCheckButton* enable_sounds_button;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gint iagno_computer_level;
static gint iagno_computer_level = 0;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_quit_cb (Iagno* self);
static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event);
static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_start_game (Iagno* self);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static void iagno_real_shutdown (GApplication* base);
static void iagno_cancel_pending_computer_moves (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
gboolean game_can_undo (Game* self, gint count);
Player game_get_current_color (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_can_move (Game* self, Player color);
static void iagno_create_preferences_dialog (Iagno* self);
static void iagno_play_sound (Iagno* self, const gchar* name);
void game_pass (Game* self);
gint game_get_n_tiles (Game* self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_computer_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_mode_changed_cb (Iagno* self, GtkComboBox* combo, GtkComboBox* level_combo);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda6_ (Block2Data* _data2_);
static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _iagno_computer_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda7_ (Block2Data* _data2_);
static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda8_ (Block2Data* _data2_);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[9] = {{"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_INT, &iagno_computer_level, "Set the level of the computer's AI", NULL}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[6] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _iagno_quit_cb_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_new_game_cb ((Iagno*) self);
#line 229 "iagno.c"
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_undo_move_cb ((Iagno*) self);
#line 236 "iagno.c"
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_preferences_cb ((Iagno*) self);
#line 243 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 250 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 257 "iagno.c"
}


static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_quit_cb ((Iagno*) self);
#line 264 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
#line 68 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 70 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 71 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>z", "app.undo-move", NULL);
#line 278 "iagno.c"
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 79 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 75 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return self;
#line 290 "iagno.c"
}


Iagno* iagno_new (void) {
#line 75 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 297 "iagno.c"
}


static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = iagno_window_configure_event_cb ((Iagno*) self, event);
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 306 "iagno.c"
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb ((Iagno*) self, event);
#line 106 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 315 "iagno.c"
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 322 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkApplicationWindow* _tmp9_ = NULL;
	GtkWindow* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkWindow* _tmp13_ = NULL;
	GtkWindow* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GSettings* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GSettings* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GtkImage* image = NULL;
	GtkImage* _tmp24_ = NULL;
	GtkImage* _tmp25_ = NULL;
	GtkTextDirection _tmp26_ = 0;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	GtkImage* _tmp31_ = NULL;
	GtkButton* _tmp32_ = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	GtkHeaderBar* _tmp37_ = NULL;
	GtkHeaderBar* _tmp38_ = NULL;
	GtkHeaderBar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkHeaderBar* _tmp41_ = NULL;
	GtkButton* _tmp42_ = NULL;
	GtkHeaderBar* _tmp43_ = NULL;
	GtkWindow* _tmp44_ = NULL;
	GtkHeaderBar* _tmp45_ = NULL;
	GtkAspectFrame* frame = NULL;
	GtkAspectFrame* _tmp46_ = NULL;
	GtkAspectFrame* _tmp47_ = NULL;
	GtkAspectFrame* _tmp48_ = NULL;
	GtkWindow* _tmp49_ = NULL;
	GtkAspectFrame* _tmp50_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp51_ = NULL;
	GtkBox* _tmp52_ = NULL;
	GtkBox* _tmp53_ = NULL;
	GtkAspectFrame* _tmp54_ = NULL;
	GtkBox* _tmp55_ = NULL;
	GameView* _tmp56_ = NULL;
	GameView* _tmp57_ = NULL;
	Game* _tmp58_ = NULL;
	GameView* _tmp59_ = NULL;
	gchar* tile_set = NULL;
	GSettings* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	GameView* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	GameView* _tmp66_ = NULL;
	GameView* _tmp67_ = NULL;
	GtkBox* _tmp68_ = NULL;
	GameView* _tmp69_ = NULL;
	GtkBox* side_box = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkBox* _tmp71_ = NULL;
	GtkBox* _tmp72_ = NULL;
	GtkBox* _tmp73_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp74_ = NULL;
	GtkGrid* _tmp75_ = NULL;
	GtkGrid* _tmp76_ = NULL;
	GtkGrid* _tmp77_ = NULL;
	GtkGrid* _tmp78_ = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkBox* _tmp80_ = NULL;
	GtkGrid* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	GtkLabel* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkGrid* _tmp85_ = NULL;
	GtkLabel* _tmp86_ = NULL;
	GtkLabel* _tmp87_ = NULL;
	GtkLabel* _tmp88_ = NULL;
	GtkGrid* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	const gchar* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	GtkLabel* _tmp93_ = NULL;
	GtkGrid* _tmp94_ = NULL;
	GtkLabel* _tmp95_ = NULL;
	GtkLabel* _tmp96_ = NULL;
	GtkLabel* _tmp97_ = NULL;
	GtkGrid* _tmp98_ = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkButton* new_game_button = NULL;
	GtkButton* _tmp100_ = NULL;
	GtkButton* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkButton* _tmp103_ = NULL;
	GtkButton* _tmp104_ = NULL;
	GtkButton* _tmp105_ = NULL;
	GtkButton* _tmp106_ = NULL;
	GtkButton* _tmp107_ = NULL;
	GtkButton* _tmp108_ = NULL;
	GtkButton* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkButton* _tmp111_ = NULL;
	GtkBox* _tmp112_ = NULL;
	GtkButton* _tmp113_ = NULL;
	GtkWindow* _tmp114_ = NULL;
	GError * _inner_error_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 84 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 451 "iagno.c"
		GtkWindow* _tmp1_ = NULL;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->window;
#line 86 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_widget_show ((GtkWidget*) _tmp1_);
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 459 "iagno.c"
	}
#line 90 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = gtk_builder_new ();
#line 90 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	builder = _tmp2_;
#line 465 "iagno.c"
	{
		GtkBuilder* _tmp3_ = NULL;
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = builder;
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_builder_add_from_file (_tmp3_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 474 "iagno.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		e = _inner_error_;
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = e;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = _tmp5_->message;
#line 97 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		fprintf (_tmp4_, "Could not load UI: %s\n", _tmp6_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (builder);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 503 "iagno.c"
	}
	__finally2:
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (builder);
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 516 "iagno.c"
	}
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = builder;
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = gtk_builder_get_object (_tmp7_, "iagno-menu");
#line 100 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp8_) : NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp9_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->window = (GtkWindow*) _tmp9_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = self->priv->window;
#line 102 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 25);
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = self->priv->window;
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = _ ("Iagno");
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_title (_tmp11_, _tmp12_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = self->priv->window;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_icon_name (_tmp13_, "iagno");
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = self->priv->window;
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp14_, "configure-event", (GCallback) _iagno_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 106 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = self->priv->window;
#line 106 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp15_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = self->priv->window;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = self->priv->settings;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "window-width");
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = self->priv->settings;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = g_settings_get_int (_tmp19_, "window-height");
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_default_size (_tmp16_, _tmp18_, _tmp20_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp21_ = self->priv->settings;
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22_ = g_settings_get_boolean (_tmp21_, "window-is-maximized");
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp22_) {
#line 572 "iagno.c"
		GtkWindow* _tmp23_ = NULL;
#line 109 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp23_ = self->priv->window;
#line 109 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_window_maximize (_tmp23_);
#line 578 "iagno.c"
	}
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp24_ = (GtkImage*) gtk_image_new ();
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp24_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	image = _tmp24_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp25_ = image;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_set (_tmp25_, "icon-size", (gint) GTK_ICON_SIZE_BUTTON, NULL);
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp26_ = gtk_widget_get_default_direction ();
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp26_ == GTK_TEXT_DIR_RTL) {
#line 594 "iagno.c"
		GtkImage* _tmp27_ = NULL;
#line 114 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp27_ = image;
#line 114 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_object_set (_tmp27_, "icon-name", "edit-undo-rtl-symbolic", NULL);
#line 600 "iagno.c"
	} else {
		GtkImage* _tmp28_ = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp28_ = image;
#line 116 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_object_set (_tmp28_, "icon-name", "edit-undo-symbolic", NULL);
#line 607 "iagno.c"
	}
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp29_ = (GtkButton*) gtk_button_new ();
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp29_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	undo_button = _tmp29_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp30_ = undo_button;
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp31_ = image;
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_button_set_image (_tmp30_, (GtkWidget*) _tmp31_);
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp32_ = undo_button;
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp33_ = undo_button;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp33_, "app.undo-move");
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp34_ = undo_button;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp35_ = _ ("Undo your most recent move");
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp34_, _tmp35_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp36_ = undo_button;
#line 123 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp36_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp37_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp37_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->headerbar = _tmp37_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp38_ = self->priv->headerbar;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_header_bar_set_show_close_button (_tmp38_, TRUE);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp39_ = self->priv->headerbar;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp40_ = _ ("Iagno");
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_header_bar_set_title (_tmp39_, _tmp40_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp41_ = self->priv->headerbar;
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp42_ = undo_button;
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_header_bar_pack_start (_tmp41_, (GtkWidget*) _tmp42_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp43_ = self->priv->headerbar;
#line 129 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp43_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp44_ = self->priv->window;
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp45_ = self->priv->headerbar;
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_titlebar (_tmp44_, (GtkWidget*) _tmp45_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp46_ = (GtkAspectFrame*) gtk_aspect_frame_new (NULL, (gfloat) 0.5, (gfloat) 0.5, (gfloat) 1.4, FALSE);
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp46_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	frame = _tmp46_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp47_ = frame;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) _tmp47_, GTK_SHADOW_NONE);
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp48_ = frame;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp48_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp49_ = self->priv->window;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp50_ = frame;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp51_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 25);
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp51_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	hbox = _tmp51_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp52_ = hbox;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_FILL);
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp53_ = hbox;
#line 139 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp53_);
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp54_ = frame;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp55_ = hbox;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp56_ = game_view_new ();
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp56_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->view = _tmp56_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp57_ = self->priv->view;
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp58_ = self->priv->game;
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_game (_tmp57_, _tmp58_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp59_ = self->priv->view;
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp59_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp60_ = self->priv->settings;
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp61_ = g_settings_get_string (_tmp60_, "tileset");
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	tile_set = _tmp61_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp62_ = self->priv->view;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp63_ = tile_set;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp64_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp63_, NULL);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp65_ = _tmp64_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_theme (_tmp62_, _tmp65_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp65_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp66_ = self->priv->view;
#line 147 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_END);
#line 148 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp67_ = self->priv->view;
#line 148 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp68_ = hbox;
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp69_ = self->priv->view;
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp68_, (GtkWidget*) _tmp69_, TRUE, TRUE, (guint) 0);
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp70_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	side_box = _tmp70_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp71_ = side_box;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp71_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp72_ = hbox;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp73_ = side_box;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_pack_end (_tmp72_, (GtkWidget*) _tmp73_, FALSE, TRUE, (guint) 0);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp74_ = (GtkGrid*) gtk_grid_new ();
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp74_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	grid = _tmp74_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp75_ = grid;
#line 156 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp75_, GTK_ALIGN_CENTER);
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp76_ = grid;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp76_, TRUE);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp77_ = grid;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp77_, TRUE);
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp78_ = grid;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_set_column_spacing (_tmp78_, (guint) 8);
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp79_ = grid;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp79_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp80_ = side_box;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp81_ = grid;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp80_, (GtkWidget*) _tmp81_, FALSE, TRUE, (guint) 0);
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp82_ = _ ("Dark:");
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp83_ = (GtkLabel*) gtk_label_new (_tmp82_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp83_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_label);
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->dark_label = _tmp83_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp84_ = self->priv->dark_label;
#line 164 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp84_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp85_ = grid;
#line 165 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp86_ = self->priv->dark_label;
#line 165 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 1, 0, 1, 1);
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp87_ = (GtkLabel*) gtk_label_new ("00");
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp87_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp87_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp88_ = self->priv->dark_score_label;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp88_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp89_ = grid;
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp90_ = self->priv->dark_score_label;
#line 169 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 2, 0, 1, 1);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp91_ = _ ("Light:");
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp92_ = (GtkLabel*) gtk_label_new (_tmp91_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp92_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_label);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->light_label = _tmp92_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp93_ = self->priv->light_label;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp93_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp94_ = grid;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp95_ = self->priv->light_label;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 1, 1, 1, 1);
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp96_ = (GtkLabel*) gtk_label_new ("00");
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp96_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp96_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp97_ = self->priv->light_score_label;
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp97_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp98_ = grid;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp99_ = self->priv->light_score_label;
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 2, 1, 1, 1);
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp100_ = (GtkButton*) gtk_button_new ();
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp100_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	new_game_button = _tmp100_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp101_ = new_game_button;
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp102_ = _ ("_Start Over");
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_button_set_label (_tmp101_, _tmp102_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp103_ = new_game_button;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_button_set_use_underline (_tmp103_, TRUE);
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp104_ = new_game_button;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp104_, "width-request", 120, NULL);
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp105_ = new_game_button;
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp105_, "height-request", 60, NULL);
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp106_ = new_game_button;
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp106_, GTK_ALIGN_END);
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp107_ = new_game_button;
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp107_, GTK_ALIGN_END);
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp108_ = new_game_button;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp108_, "app.new-game");
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp109_ = new_game_button;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp110_ = _ ("Start a new game");
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp109_, _tmp110_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp111_ = new_game_button;
#line 188 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp111_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp112_ = side_box;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp113_ = new_game_button;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_pack_end (_tmp112_, (GtkWidget*) _tmp113_, FALSE, FALSE, (guint) 0);
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_start_game (self);
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp114_ = self->priv->window;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp114_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (new_game_button);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (grid);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (side_box);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (tile_set);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (hbox);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (frame);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (undo_button);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (image);
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 963 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp3_ = NULL;
	GVariantDict* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GVariantDict* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gint _tmp10_ = 0;
	GVariantDict* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GVariantDict* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GVariantDict* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 196 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 994 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = stderr;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return result;
#line 1004 "iagno.c"
	}
#line 207 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = g_settings_new ("org.gnome.iagno");
#line 207 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 207 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->settings = _tmp3_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = options;
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = g_variant_dict_contains (_tmp4_, "unmute");
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp5_) {
#line 1018 "iagno.c"
		GSettings* _tmp6_ = NULL;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->settings;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp6_, "sound", TRUE);
#line 1024 "iagno.c"
	}
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = options;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = g_variant_dict_contains (_tmp7_, "mute");
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp8_) {
#line 1032 "iagno.c"
		GSettings* _tmp9_ = NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = self->priv->settings;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp9_, "sound", FALSE);
#line 1038 "iagno.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = iagno_computer_level;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp10_ > 0) {
#line 1044 "iagno.c"
		gint _tmp11_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = iagno_computer_level;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp11_ <= 3) {
#line 1050 "iagno.c"
			GSettings* _tmp12_ = NULL;
			gint _tmp13_ = 0;
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp12_ = self->priv->settings;
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp13_ = iagno_computer_level;
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			g_settings_set_int (_tmp12_, "computer-level", _tmp13_);
#line 1059 "iagno.c"
		} else {
			FILE* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp14_ = stderr;
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp15_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			fprintf (_tmp14_, "%1$s\n", _tmp15_);
#line 1069 "iagno.c"
		}
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = options;
#line 225 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = g_variant_dict_contains (_tmp16_, "second");
#line 225 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp17_) {
#line 1078 "iagno.c"
		GSettings* _tmp18_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp18_ = self->priv->settings;
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_string (_tmp18_, "play-as", "second");
#line 1084 "iagno.c"
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = options;
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = g_variant_dict_contains (_tmp19_, "first");
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp20_) {
#line 1092 "iagno.c"
		GSettings* _tmp21_ = NULL;
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp21_ = self->priv->settings;
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_string (_tmp21_, "play-as", "first");
#line 1098 "iagno.c"
	}
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22_ = options;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp23_ = g_variant_dict_contains (_tmp22_, "two-players");
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp23_) {
#line 1106 "iagno.c"
		GSettings* _tmp24_ = NULL;
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp24_ = self->priv->settings;
#line 230 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_string (_tmp24_, "play-as", "two-players");
#line 1112 "iagno.c"
	}
#line 233 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = -1;
#line 233 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 1118 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->window_width;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->settings;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->window_height;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->settings;
#line 243 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = self->priv->is_maximized;
#line 243 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 1152 "iagno.c"
}


static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 248 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->is_maximized;
#line 248 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 1168 "iagno.c"
		gboolean _tmp2_ = FALSE;
#line 248 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = self->priv->is_fullscreen;
#line 248 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = !_tmp2_;
#line 1174 "iagno.c"
	} else {
#line 248 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 1178 "iagno.c"
	}
#line 248 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 1182 "iagno.c"
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = event;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->width;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->window_width = _tmp4_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = event;
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = _tmp5_->height;
#line 251 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->window_height = _tmp6_;
#line 1199 "iagno.c"
	}
#line 254 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = FALSE;
#line 254 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 1205 "iagno.c"
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = event;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1225 "iagno.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = event;
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1234 "iagno.c"
	}
#line 261 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = event;
#line 261 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 261 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
#line 1242 "iagno.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = event;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
#line 1251 "iagno.c"
	}
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = FALSE;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 1257 "iagno.c"
}


static void iagno_quit_cb (Iagno* self) {
	GtkWindow* _tmp0_ = NULL;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 268 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1269 "iagno.c"
}


static void iagno_new_game_cb (Iagno* self) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_start_game (self);
#line 1278 "iagno.c"
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_game_move_cb ((Iagno*) self);
#line 1285 "iagno.c"
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 285 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_game_complete_cb ((Iagno*) self);
#line 1292 "iagno.c"
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb ((Iagno*) self);
#line 303 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 1301 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gchar* mode = NULL;
	GSettings* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	Player _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	Player _tmp17_ = 0;
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 278 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_cancel_pending_computer_moves (self);
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1328 "iagno.c"
		Game* _tmp1_ = NULL;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1334 "iagno.c"
	}
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = game_new (8, 8);
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->game = _tmp2_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp3_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
#line 285 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->game;
#line 285 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = self->priv->view;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = self->priv->game;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_game (_tmp5_, _tmp6_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = self->priv->settings;
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = g_settings_get_string (_tmp7_, "play-as");
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	mode = _tmp8_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = mode;
#line 289 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp9_, "two-players") == 0) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 290 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1370 "iagno.c"
	} else {
		Game* _tmp10_ = NULL;
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		ComputerPlayer* _tmp13_ = NULL;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = self->priv->game;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = self->priv->settings;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = g_settings_get_int (_tmp11_, "computer-level");
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = computer_player_new (_tmp10_, _tmp12_);
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->computer = _tmp13_;
#line 1388 "iagno.c"
	}
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = mode;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp15_, "first") == 0) {
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = PLAYER_DARK;
#line 1396 "iagno.c"
	} else {
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = PLAYER_LIGHT;
#line 1400 "iagno.c"
	}
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->player_one = _tmp14_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = self->priv->player_one;
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp17_ != PLAYER_DARK) {
#line 1410 "iagno.c"
		ComputerPlayer* _tmp18_ = NULL;
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp18_ = self->priv->computer;
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp16_ = _tmp18_ != NULL;
#line 1416 "iagno.c"
	} else {
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp16_ = FALSE;
#line 1420 "iagno.c"
	}
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp16_) {
#line 1424 "iagno.c"
		guint _tmp19_ = 0U;
#line 303 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp19_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 303 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->computer_timer = _tmp19_;
#line 1430 "iagno.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 1434 "iagno.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 310 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 1441 "iagno.c"
}


static void iagno_update_ui (Iagno* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Player _tmp4_ = 0;
	GSimpleAction* new_game_action = NULL;
	GAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	Game* _tmp17_ = NULL;
	Player _tmp18_ = 0;
	Player _tmp19_ = 0;
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->headerbar;
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 310 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
#line 310 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
#line 310 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	undo_action = _tmp2_;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = TRUE;
#line 1479 "iagno.c"
	} else {
		ComputerPlayer* _tmp5_ = NULL;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = _tmp5_ == NULL;
#line 1486 "iagno.c"
	}
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp3_) {
#line 1490 "iagno.c"
		GSimpleAction* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 312 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = undo_action;
#line 312 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 312 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = game_can_undo (_tmp7_, 1);
#line 312 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp6_, _tmp8_);
#line 1502 "iagno.c"
	} else {
		GSimpleAction* _tmp9_ = NULL;
		Game* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = undo_action;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = self->priv->game;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = game_can_undo (_tmp10_, 2);
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp9_, _tmp11_);
#line 1515 "iagno.c"
	}
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction));
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	new_game_action = _tmp13_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = new_game_action;
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = self->priv->game;
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = game_can_undo (_tmp15_, 1);
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_simple_action_set_enabled (_tmp14_, _tmp16_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = self->priv->game;
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = game_get_current_color (_tmp17_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = _tmp18_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp19_ == PLAYER_DARK) {
#line 1539 "iagno.c"
		GtkLabel* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		GtkLabel* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GtkLabel* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		Game* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		GtkLabel* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		Game* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp20_ = self->priv->dark_label;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp21_ = _ ("Dark:");
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp22_ = g_strconcat ("<span font_weight='bold'>", _tmp21_, NULL);
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp23_ = _tmp22_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp24_ = g_strconcat (_tmp23_, "</span>", NULL);
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp25_ = _tmp24_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp20_, _tmp25_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp25_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp23_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp26_ = self->priv->light_label;
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp27_ = _ ("Light:");
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp28_ = g_strconcat ("<span font_weight='normal'>", _tmp27_, NULL);
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp29_ = _tmp28_;
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp30_ = g_strconcat (_tmp29_, "</span>", NULL);
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp31_ = _tmp30_;
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp26_, _tmp31_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp31_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp29_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp32_ = self->priv->dark_score_label;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp33_ = _ ("%.2d");
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp34_ = self->priv->game;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp35_ = game_get_n_dark_tiles (_tmp34_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp36_ = _tmp35_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp37_ = g_strdup_printf (_tmp33_, _tmp36_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp38_ = _tmp37_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp39_ = g_strconcat ("<span font_weight='bold'>", _tmp38_, NULL);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp40_ = _tmp39_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp41_ = g_strconcat (_tmp40_, "</span>", NULL);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp42_ = _tmp41_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp32_, _tmp42_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp42_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp40_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp38_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp43_ = self->priv->light_score_label;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp44_ = _ ("%.2d");
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp45_ = self->priv->game;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp46_ = game_get_n_light_tiles (_tmp45_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp47_ = _tmp46_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp48_ = g_strdup_printf (_tmp44_, _tmp47_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp49_ = _tmp48_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp50_ = g_strconcat ("<span font_weight='normal'>", _tmp49_, NULL);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp51_ = _tmp50_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp52_ = g_strconcat (_tmp51_, "</span>", NULL);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp53_ = _tmp52_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_label_set_markup (_tmp43_, _tmp53_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp53_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp51_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp49_);
#line 1670 "iagno.c"
	} else {
		Game* _tmp54_ = NULL;
		Player _tmp55_ = 0;
		Player _tmp56_ = 0;
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp54_ = self->priv->game;
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp55_ = game_get_current_color (_tmp54_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp56_ = _tmp55_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp56_ == PLAYER_LIGHT) {
#line 1683 "iagno.c"
			GtkLabel* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			GtkLabel* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			GtkLabel* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			Game* _tmp71_ = NULL;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			GtkLabel* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			Game* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp57_ = self->priv->dark_label;
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp58_ = _ ("Dark:");
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp59_ = g_strconcat ("<span font_weight='normal'>", _tmp58_, NULL);
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp60_ = _tmp59_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp61_ = g_strconcat (_tmp60_, "</span>", NULL);
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp62_ = _tmp61_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp57_, _tmp62_);
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp62_);
#line 329 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp60_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp63_ = self->priv->light_label;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp64_ = _ ("Light:");
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp65_ = g_strconcat ("<span font_weight='bold'>", _tmp64_, NULL);
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp66_ = _tmp65_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp67_ = g_strconcat (_tmp66_, "</span>", NULL);
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp68_ = _tmp67_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp63_, _tmp68_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp68_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp66_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp69_ = self->priv->dark_score_label;
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp70_ = _ ("%.2d");
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp71_ = self->priv->game;
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp72_ = game_get_n_dark_tiles (_tmp71_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp73_ = _tmp72_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp74_ = g_strdup_printf (_tmp70_, _tmp73_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp75_ = _tmp74_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp76_ = g_strconcat ("<span font_weight='normal'>", _tmp75_, NULL);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp77_ = _tmp76_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp78_ = g_strconcat (_tmp77_, "</span>", NULL);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp79_ = _tmp78_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp69_, _tmp79_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp79_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp77_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp75_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp80_ = self->priv->light_score_label;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp81_ = _ ("%.2d");
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp82_ = self->priv->game;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp83_ = game_get_n_light_tiles (_tmp82_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp84_ = _tmp83_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp85_ = g_strdup_printf (_tmp81_, _tmp84_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp86_ = _tmp85_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp87_ = g_strconcat ("<span font_weight='bold'>", _tmp86_, NULL);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp88_ = _tmp87_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp89_ = g_strconcat (_tmp88_, "</span>", NULL);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp90_ = _tmp89_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_label_set_markup (_tmp80_, _tmp90_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp90_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp88_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (_tmp86_);
#line 1814 "iagno.c"
		}
	}
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (new_game_action);
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (undo_action);
#line 1821 "iagno.c"
}


static void iagno_undo_move_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_cancel_pending_computer_moves (self);
#line 341 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 341 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1835 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		Game* _tmp3_ = NULL;
		Player _tmp4_ = 0;
		Player _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = game_get_current_color (_tmp3_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = game_can_move (_tmp2_, _tmp5_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (!_tmp6_) {
#line 1858 "iagno.c"
			Game* _tmp7_ = NULL;
#line 345 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp7_ = self->priv->game;
#line 345 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp7_, 1);
#line 1864 "iagno.c"
		}
	} else {
		Game* _tmp8_ = NULL;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		Player _tmp11_ = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = game_get_current_color (_tmp8_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = self->priv->player_one;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp10_ != _tmp11_) {
#line 1881 "iagno.c"
			Game* _tmp12_ = NULL;
#line 351 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 351 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp12_, 1);
#line 1887 "iagno.c"
		} else {
			Game* _tmp13_ = NULL;
#line 353 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 353 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp13_, 2);
#line 1894 "iagno.c"
		}
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		while (TRUE) {
#line 1898 "iagno.c"
			Game* _tmp14_ = NULL;
			Game* _tmp15_ = NULL;
			Player _tmp16_ = 0;
			Player _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
			Game* _tmp19_ = NULL;
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp14_ = self->priv->game;
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp15_ = self->priv->game;
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp16_ = game_get_current_color (_tmp15_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp17_ = _tmp16_;
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp18_ = game_can_move (_tmp14_, _tmp17_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (!(!_tmp18_)) {
#line 356 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				break;
#line 1919 "iagno.c"
			}
#line 357 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp19_ = self->priv->game;
#line 357 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp19_, 2);
#line 1925 "iagno.c"
		}
	}
#line 360 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_game_move_cb (self);
#line 1930 "iagno.c"
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 363 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 365 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 366 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi\n" \
"\n" \
"Iagno is a part of GNOME Games.");
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 368 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" \
"Copyright © 2013–2014 Michael Catanzaro", "license-type", GTK_LICENSE_GPL_2_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 363 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 363 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1998 "iagno.c"
}


static void iagno_preferences_cb (Iagno* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
#line 383 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 385 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->propbox;
#line 385 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 386 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_create_preferences_dialog (self);
#line 2013 "iagno.c"
	}
#line 387 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->propbox;
#line 387 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
#line 2019 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 390 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 2027 "iagno.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 394 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 394 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 394 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 394 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 394 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2042 "iagno.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		e = _inner_error_;
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 398 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 398 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 398 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_warning ("iagno.vala:398: Failed to show help: %s", _tmp4_);
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 2064 "iagno.c"
	}
	__finally3:
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2075 "iagno.c"
	}
}


static void iagno_game_move_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Game* _tmp14_ = NULL;
	Player _tmp15_ = 0;
	Player _tmp16_ = 0;
	Player _tmp17_ = 0;
#line 402 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 404 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_play_sound (self, "flip-piece");
#line 406 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 406 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 406 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp4_) {
#line 2107 "iagno.c"
		Game* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		Player _tmp7_ = 0;
		Player _tmp8_ = 0;
#line 408 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = self->priv->game;
#line 408 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		game_pass (_tmp5_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->game;
#line 409 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = game_get_current_color (_tmp6_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = _tmp7_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp8_ == PLAYER_DARK) {
#line 2124 "iagno.c"
			GtkHeaderBar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 412 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp9_ = self->priv->headerbar;
#line 412 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp10_ = _ ("Light must pass, Dark’s move");
#line 412 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp9_, _tmp10_);
#line 2133 "iagno.c"
		} else {
			GtkHeaderBar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 417 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp11_ = self->priv->headerbar;
#line 417 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp12_ = _ ("Dark must pass, Light’s move");
#line 417 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp11_, _tmp12_);
#line 2143 "iagno.c"
		}
#line 419 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2147 "iagno.c"
	}
#line 422 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = self->priv->game;
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = game_get_current_color (_tmp14_);
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = _tmp15_;
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = self->priv->player_one;
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp16_ != _tmp17_) {
#line 2161 "iagno.c"
		ComputerPlayer* _tmp18_ = NULL;
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp18_ = self->priv->computer;
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = _tmp18_ != NULL;
#line 2167 "iagno.c"
	} else {
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = FALSE;
#line 2171 "iagno.c"
	}
#line 429 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp13_) {
#line 2175 "iagno.c"
		gboolean _tmp19_ = FALSE;
		Game* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp20_ = self->priv->game;
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp21_ = game_get_n_tiles (_tmp20_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp22_ = _tmp21_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp22_ == 63) {
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp19_ = TRUE;
#line 2190 "iagno.c"
		} else {
			gboolean _tmp23_ = FALSE;
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp23_ = iagno_fast_mode;
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp19_ = _tmp23_;
#line 2197 "iagno.c"
		}
#line 431 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp19_) {
#line 2201 "iagno.c"
			guint _tmp24_ = 0U;
#line 432 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp24_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 400, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 432 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			self->priv->computer_timer = _tmp24_;
#line 2207 "iagno.c"
		} else {
			guint _tmp25_ = 0U;
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp25_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			self->priv->computer_timer = _tmp25_;
#line 2214 "iagno.c"
		}
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Player _tmp1_ = 0;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
#line 438 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 440 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_cancel_pending_computer_moves (self);
#line 441 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 441 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_color (_tmp0_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 441 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->player_one;
#line 441 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_ != _tmp3_) {
#line 2240 "iagno.c"
		ComputerPlayer* _tmp4_ = NULL;
#line 442 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = self->priv->computer;
#line 442 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		computer_player_move (_tmp4_);
#line 2246 "iagno.c"
	}
#line 443 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = FALSE;
#line 443 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 2252 "iagno.c"
}


static void iagno_cancel_pending_computer_moves (Iagno* self) {
	guint _tmp0_ = 0U;
#line 446 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 448 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer_timer;
#line 448 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2264 "iagno.c"
		guint _tmp1_ = 0U;
#line 450 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer_timer;
#line 450 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_source_remove (_tmp1_);
#line 451 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->computer_timer = (guint) 0;
#line 2272 "iagno.c"
	}
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 455 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 457 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_ > _tmp5_) {
#line 2302 "iagno.c"
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 462 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->headerbar;
#line 462 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = _ ("Light wins!");
#line 462 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
#line 2311 "iagno.c"
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = game_get_n_dark_tiles (_tmp8_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = game_get_n_light_tiles (_tmp11_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp10_ > _tmp13_) {
#line 2333 "iagno.c"
			GtkHeaderBar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp14_ = self->priv->headerbar;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp15_ = _ ("Dark wins!");
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
#line 2342 "iagno.c"
		} else {
			Game* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			Game* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp17_ = game_get_n_light_tiles (_tmp16_);
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp18_ = _tmp17_;
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp19_ = self->priv->game;
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp20_ = game_get_n_dark_tiles (_tmp19_);
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp21_ = _tmp20_;
#line 469 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (_tmp18_ == _tmp21_) {
#line 2364 "iagno.c"
				GtkHeaderBar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 472 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp22_ = self->priv->headerbar;
#line 472 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp23_ = _ ("The game is draw.");
#line 472 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				gtk_header_bar_set_subtitle (_tmp22_, _tmp23_);
#line 2373 "iagno.c"
			} else {
#line 474 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				g_assert_not_reached ();
#line 2377 "iagno.c"
			}
		}
	}
#line 476 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_play_sound (self, "gameover");
#line 2383 "iagno.c"
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 479 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 479 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (name != NULL);
#line 481 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 481 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 481 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 482 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2409 "iagno.c"
	}
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->view;
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = name;
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = name;
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = _tmp7_;
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp8_);
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp6_);
#line 2431 "iagno.c"
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Game* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 489 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp3_ != _tmp4_) {
#line 2457 "iagno.c"
		ComputerPlayer* _tmp5_ = NULL;
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = _tmp5_ != NULL;
#line 2463 "iagno.c"
	} else {
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 2467 "iagno.c"
	}
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 493 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2473 "iagno.c"
	}
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = self->priv->game;
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = x;
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = y;
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = game_place_tile (_tmp6_, _tmp7_, _tmp8_);
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp9_ == 0) {
#line 2485 "iagno.c"
		GtkHeaderBar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 498 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = self->priv->headerbar;
#line 498 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = _ ("You can’t move there!");
#line 498 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp10_, _tmp11_);
#line 2494 "iagno.c"
	}
}


static void iagno_computer_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
#line 502 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 502 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (combo != NULL);
#line 505 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = combo;
#line 505 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp1_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = combo;
#line 507 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = iter;
#line 507 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
#line 508 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = self->priv->settings;
#line 508 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_int (_tmp6_, "computer-level", level);
#line 2533 "iagno.c"
}


static void iagno_mode_changed_cb (Iagno* self, GtkComboBox* combo, GtkComboBox* level_combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gchar* mode = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	GtkComboBox* _tmp10_ = NULL;
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (combo != NULL);
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (level_combo != NULL);
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = combo;
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp1_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = combo;
#line 516 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
#line 516 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = iter;
#line 516 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &mode, -1);
#line 517 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = self->priv->settings;
#line 517 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = mode;
#line 517 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_string (_tmp6_, "play-as", _tmp7_);
#line 518 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = mode;
#line 518 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp9_, "two-players") == 0) {
#line 518 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = FALSE;
#line 2585 "iagno.c"
	} else {
#line 518 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = TRUE;
#line 2589 "iagno.c"
	}
#line 518 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = level_combo;
#line 518 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp8_);
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 2597 "iagno.c"
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	gboolean play_sounds = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
#line 521 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 523 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 523 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
#line 523 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	play_sounds = _tmp1_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->settings;
#line 524 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
#line 2620 "iagno.c"
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_ = NULL;
#line 527 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 527 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 529 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 529 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_hide (_tmp0_);
#line 2634 "iagno.c"
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 532 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 532 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 532 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 534 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 534 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_hide (_tmp0_);
#line 535 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = TRUE;
#line 535 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 2655 "iagno.c"
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* tile_set = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GameView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GameView* _tmp14_ = NULL;
#line 538 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 538 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 540 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 540 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 540 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 540 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	model = _tmp2_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = widget;
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp4_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp5_) {
#line 543 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (model);
#line 543 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2702 "iagno.c"
	}
#line 545 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = model;
#line 545 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = iter;
#line 545 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &tile_set, -1);
#line 546 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = self->priv->settings;
#line 546 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = tile_set;
#line 546 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_string (_tmp8_, "tileset", _tmp9_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = self->priv->view;
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = tile_set;
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp11_, NULL);
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = _tmp12_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_theme (_tmp10_, _tmp13_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp13_);
#line 548 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = self->priv->view;
#line 548 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_redraw (_tmp14_);
#line 538 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (tile_set);
#line 538 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 2736 "iagno.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return _data2_;
#line 2745 "iagno.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2754 "iagno.c"
		Iagno* self;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self = _data2_->self;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (_data2_->enable_sounds_button);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (_data2_->level_combo);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (_data2_->combo);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_slice_free (Block2Data, _data2_);
#line 2768 "iagno.c"
	}
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 562 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_propbox_response_cb ((Iagno*) self, _sender, response_id);
#line 2776 "iagno.c"
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb ((Iagno*) self, _sender, event);
#line 563 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 2785 "iagno.c"
}


static void __lambda5_ (Block2Data* _data2_) {
	Iagno* self;
	GtkComboBox* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = _data2_->self;
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = _data2_->combo;
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = _data2_->level_combo;
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_mode_changed_cb (self, _tmp0_, _tmp1_);
#line 2801 "iagno.c"
}


static void ___lambda5__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__lambda5_ (self);
#line 2808 "iagno.c"
}


static void __lambda6_ (Block2Data* _data2_) {
	Iagno* self;
	gchar* mode = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GtkComboBox* _tmp6_ = NULL;
#line 592 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = _data2_->self;
#line 593 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 593 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "play-as");
#line 593 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	mode = _tmp1_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _data2_->combo;
#line 594 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = mode;
#line 594 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_active_id (_tmp2_, _tmp3_);
#line 595 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = mode;
#line 595 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp5_, "two-players") == 0) {
#line 595 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = FALSE;
#line 2842 "iagno.c"
	} else {
#line 595 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = TRUE;
#line 2846 "iagno.c"
	}
#line 595 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _data2_->level_combo;
#line 595 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp4_);
#line 592 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 2854 "iagno.c"
}


static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 592 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__lambda6_ (self);
#line 2861 "iagno.c"
}


static void _iagno_computer_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 606 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_computer_level_changed_cb ((Iagno*) self, _sender);
#line 2868 "iagno.c"
}


static void __lambda7_ (Block2Data* _data2_) {
	Iagno* self;
	GtkComboBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 618 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = _data2_->self;
#line 619 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = _data2_->level_combo;
#line 619 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 619 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "computer-level");
#line 619 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_active (_tmp0_, _tmp2_ - 1);
#line 2887 "iagno.c"
}


static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 618 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__lambda7_ (self);
#line 2894 "iagno.c"
}


static void _g_free0_ (gpointer var) {
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	var = (g_free (var), NULL);
#line 2901 "iagno.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_list_free (self);
#line 2910 "iagno.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2923 "iagno.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2954 "iagno.c"
				goto __catch5_g_regex_error;
			}
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 2963 "iagno.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2979 "iagno.c"
				goto __catch5_g_regex_error;
			}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 2990 "iagno.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 3004 "iagno.c"
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 3018 "iagno.c"
	}
	__finally5:
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 3029 "iagno.c"
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 3055 "iagno.c"
		gchar* _tmp4_ = NULL;
#line 934 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 3063 "iagno.c"
	} else {
#line 936 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 3069 "iagno.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 3093 "iagno.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 3101 "iagno.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 3113 "iagno.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 3137 "iagno.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 3143 "iagno.c"
	} else {
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3147 "iagno.c"
	}
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 3151 "iagno.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 3163 "iagno.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 3173 "iagno.c"
	}
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 3179 "iagno.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 3193 "iagno.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 3203 "iagno.c"
	}
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 3209 "iagno.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 3218 "iagno.c"
	}
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 3238 "iagno.c"
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 673 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_theme_changed_cb ((Iagno*) self, _sender);
#line 3245 "iagno.c"
}


static void __lambda8_ (Block2Data* _data2_) {
	Iagno* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 677 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = _data2_->self;
#line 678 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 678 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 678 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data2_->enable_sounds_button, _tmp1_);
#line 3261 "iagno.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 677 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__lambda8_ (self);
#line 3268 "iagno.c"
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 681 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_sound_select ((Iagno*) self, _sender);
#line 3275 "iagno.c"
}


static void iagno_create_preferences_dialog (Iagno* self) {
	Block2Data* _data2_;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GtkComboBox* _tmp18_ = NULL;
	GtkComboBox* _tmp19_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkGrid* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp31_ = NULL;
	GtkComboBox* _tmp32_ = NULL;
	GtkListStore* _tmp33_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp34_ = NULL;
	GtkTreeIter _tmp35_ = {0};
	GtkListStore* _tmp36_ = NULL;
	GtkTreeIter _tmp37_ = {0};
	const gchar* _tmp38_ = NULL;
	GtkListStore* _tmp39_ = NULL;
	GtkTreeIter _tmp40_ = {0};
	GtkListStore* _tmp41_ = NULL;
	GtkTreeIter _tmp42_ = {0};
	const gchar* _tmp43_ = NULL;
	GtkListStore* _tmp44_ = NULL;
	GtkTreeIter _tmp45_ = {0};
	GtkListStore* _tmp46_ = NULL;
	GtkTreeIter _tmp47_ = {0};
	const gchar* _tmp48_ = NULL;
	GtkComboBox* _tmp49_ = NULL;
	GSettings* _tmp50_ = NULL;
	gchar* mode = NULL;
	GSettings* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GtkComboBox* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	const gchar* _tmp56_ = NULL;
	GtkComboBox* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GtkComboBox* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkLabel* _tmp61_ = NULL;
	GtkLabel* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	GtkComboBox* _tmp66_ = NULL;
	GtkCellRendererText* _tmp67_ = NULL;
	GtkComboBox* _tmp68_ = NULL;
	GtkCellRendererText* _tmp69_ = NULL;
	GtkComboBox* _tmp70_ = NULL;
	GtkCellRendererText* _tmp71_ = NULL;
	GtkListStore* _tmp72_ = NULL;
	GtkComboBox* _tmp73_ = NULL;
	GtkListStore* _tmp74_ = NULL;
	GtkListStore* _tmp75_ = NULL;
	GtkTreeIter _tmp76_ = {0};
	GtkListStore* _tmp77_ = NULL;
	GtkTreeIter _tmp78_ = {0};
	const gchar* _tmp79_ = NULL;
	GtkListStore* _tmp80_ = NULL;
	GtkTreeIter _tmp81_ = {0};
	GtkListStore* _tmp82_ = NULL;
	GtkTreeIter _tmp83_ = {0};
	const gchar* _tmp84_ = NULL;
	GtkListStore* _tmp85_ = NULL;
	GtkTreeIter _tmp86_ = {0};
	GtkListStore* _tmp87_ = NULL;
	GtkTreeIter _tmp88_ = {0};
	const gchar* _tmp89_ = NULL;
	GSettings* _tmp90_ = NULL;
	GtkComboBox* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	GtkGrid* _tmp94_ = NULL;
	GtkComboBox* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GtkLabel* _tmp97_ = NULL;
	GtkLabel* _tmp98_ = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkGrid* _tmp100_ = NULL;
	GtkLabel* _tmp101_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp102_ = NULL;
	GtkCellRendererText* _tmp103_ = NULL;
	GtkComboBox* _tmp104_ = NULL;
	GtkCellRendererText* _tmp105_ = NULL;
	GtkComboBox* _tmp106_ = NULL;
	GtkCellRendererText* _tmp107_ = NULL;
	GtkListStore* _tmp108_ = NULL;
	GtkComboBox* _tmp109_ = NULL;
	GtkListStore* _tmp110_ = NULL;
	GDir* dir = NULL;
	GList* dirlist = NULL;
	GList* _tmp126_ = NULL;
	GtkLabel* _tmp151_ = NULL;
	GtkComboBox* _tmp152_ = NULL;
	GtkComboBox* _tmp153_ = NULL;
	GtkGrid* _tmp154_ = NULL;
	GtkComboBox* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	GtkCheckButton* _tmp157_ = NULL;
	GSettings* _tmp158_ = NULL;
	GSettings* _tmp159_ = NULL;
	gboolean _tmp160_ = FALSE;
	GtkGrid* _tmp161_ = NULL;
	GError * _inner_error_ = NULL;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_->_ref_count_ = 1;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_->self = g_object_ref (self);
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = _ ("Preferences");
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->window;
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, GTK_DIALOG_USE_HEADER_BAR, NULL, NULL);
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp2_);
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->propbox);
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->propbox = _tmp2_;
#line 558 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->propbox;
#line 558 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp3_, (guint) 5);
#line 559 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->propbox;
#line 559 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = (GtkBox*) gtk_dialog_get_content_area (_tmp4_);
#line 559 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_box_get_type (), GtkBox));
#line 559 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	box = _tmp6_;
#line 560 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = box;
#line 560 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_set_spacing (_tmp7_, 2);
#line 561 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = self->priv->propbox;
#line 561 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_resizable ((GtkWindow*) _tmp8_, FALSE);
#line 562 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = self->priv->propbox;
#line 562 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp9_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
#line 563 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = self->priv->propbox;
#line 563 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
#line 565 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 565 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp11_);
#line 565 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	grid = _tmp11_;
#line 566 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = grid;
#line 566 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp12_, (guint) 6);
#line 567 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = grid;
#line 567 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_set_row_spacing (_tmp13_, (guint) 6);
#line 568 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = grid;
#line 568 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_set_column_spacing (_tmp14_, (guint) 18);
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = box;
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = grid;
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = (GtkComboBox*) gtk_combo_box_new ();
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp17_);
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_->combo = _tmp17_;
#line 572 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = (GtkComboBox*) gtk_combo_box_new ();
#line 572 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp18_);
#line 572 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_->level_combo = _tmp18_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = _data2_->combo;
#line 573 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp19_, "changed", (GCallback) ___lambda5__gtk_combo_box_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = _ ("Game mode:");
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp21_);
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	label = _tmp21_;
#line 576 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22_ = label;
#line 576 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp22_, 0.0f, 0.5f);
#line 577 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp23_ = label;
#line 577 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp23_, "expand", TRUE, NULL);
#line 578 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp24_ = grid;
#line 578 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp25_ = label;
#line 578 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 0, 1, 1);
#line 579 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 579 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp26_);
#line 579 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	renderer = _tmp26_;
#line 580 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp27_ = _data2_->combo;
#line 580 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp28_ = renderer;
#line 580 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp29_ = _data2_->combo;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp30_ = renderer;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, "text", 0);
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp31_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	model = _tmp31_;
#line 583 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp32_ = _data2_->combo;
#line 583 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp33_ = model;
#line 583 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_model (_tmp32_, (GtkTreeModel*) _tmp33_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp34_ = model;
#line 585 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp34_, &_tmp35_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp35_;
#line 586 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp36_ = model;
#line 586 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp37_ = iter;
#line 586 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp38_ = _ ("Play first (Dark)");
#line 586 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp36_, &_tmp37_, 0, _tmp38_, 1, "first", -1);
#line 587 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp39_ = model;
#line 587 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp39_, &_tmp40_);
#line 587 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp40_;
#line 588 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp41_ = model;
#line 588 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp42_ = iter;
#line 588 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp43_ = _ ("Play second (Light)");
#line 588 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp41_, &_tmp42_, 0, _tmp43_, 1, "second", -1);
#line 589 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp44_ = model;
#line 589 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp44_, &_tmp45_);
#line 589 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp45_;
#line 590 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp46_ = model;
#line 590 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp47_ = iter;
#line 590 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp48_ = _ ("Two players");
#line 590 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp46_, &_tmp47_, 0, _tmp48_, 1, "two-players", -1);
#line 591 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp49_ = _data2_->combo;
#line 591 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_id_column (_tmp49_, 1);
#line 592 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp50_ = self->priv->settings;
#line 592 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp50_, "changed::play-as", (GCallback) ___lambda6__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 597 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp51_ = self->priv->settings;
#line 597 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp52_ = g_settings_get_string (_tmp51_, "play-as");
#line 597 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	mode = _tmp52_;
#line 598 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp53_ = _data2_->combo;
#line 598 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp54_ = mode;
#line 598 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_active_id (_tmp53_, _tmp54_);
#line 599 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp56_ = mode;
#line 599 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp56_, "two-players") == 0) {
#line 599 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp55_ = FALSE;
#line 3621 "iagno.c"
	} else {
#line 599 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp55_ = TRUE;
#line 3625 "iagno.c"
	}
#line 599 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp57_ = _data2_->level_combo;
#line 599 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp57_, _tmp55_);
#line 600 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp58_ = grid;
#line 600 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp59_ = _data2_->combo;
#line 600 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 1, 0, 1, 1);
#line 602 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp60_ = _ ("Computer:");
#line 602 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp61_ = (GtkLabel*) gtk_label_new (_tmp60_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp61_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (label);
#line 602 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	label = _tmp61_;
#line 603 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp62_ = label;
#line 603 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp62_, 0.0f, 0.5f);
#line 604 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp63_ = label;
#line 604 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp63_, "expand", TRUE, NULL);
#line 605 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp64_ = grid;
#line 605 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp65_ = label;
#line 605 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp64_, (GtkWidget*) _tmp65_, 0, 1, 1, 1);
#line 606 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp66_ = _data2_->level_combo;
#line 606 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp66_, "changed", (GCallback) _iagno_computer_level_changed_cb_gtk_combo_box_changed, self, 0);
#line 607 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp67_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 607 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp67_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (renderer);
#line 607 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	renderer = _tmp67_;
#line 608 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp68_ = _data2_->level_combo;
#line 608 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp69_ = renderer;
#line 608 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp68_, (GtkCellRenderer*) _tmp69_, TRUE);
#line 609 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp70_ = _data2_->level_combo;
#line 609 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp71_ = renderer;
#line 609 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp70_, (GtkCellRenderer*) _tmp71_, "text", 0);
#line 610 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp72_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT, -1);
#line 610 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 610 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	model = _tmp72_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp73_ = _data2_->level_combo;
#line 611 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp74_ = model;
#line 611 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_model (_tmp73_, (GtkTreeModel*) _tmp74_);
#line 612 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp75_ = model;
#line 612 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp75_, &_tmp76_);
#line 612 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp76_;
#line 613 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp77_ = model;
#line 613 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp78_ = iter;
#line 613 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp79_ = _ ("Level one");
#line 613 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp77_, &_tmp78_, 0, _tmp79_, 1, 1, -1);
#line 614 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp80_ = model;
#line 614 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp80_, &_tmp81_);
#line 614 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp81_;
#line 615 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp82_ = model;
#line 615 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp83_ = iter;
#line 615 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp84_ = _ ("Level two");
#line 615 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp82_, &_tmp83_, 0, _tmp84_, 1, 2, -1);
#line 616 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp85_ = model;
#line 616 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_append (_tmp85_, &_tmp86_);
#line 616 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp86_;
#line 617 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp87_ = model;
#line 617 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp88_ = iter;
#line 617 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp89_ = _ ("Level three");
#line 617 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_list_store_set (_tmp87_, &_tmp88_, 0, _tmp89_, 1, 3, -1);
#line 618 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp90_ = self->priv->settings;
#line 618 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp90_, "changed::computer-level", (GCallback) ___lambda7__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 621 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp91_ = _data2_->level_combo;
#line 621 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp92_ = self->priv->settings;
#line 621 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp93_ = g_settings_get_int (_tmp92_, "computer-level");
#line 621 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_active (_tmp91_, _tmp93_ - 1);
#line 622 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp94_ = grid;
#line 622 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp95_ = _data2_->level_combo;
#line 622 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 1, 1, 1, 1);
#line 624 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp96_ = _ ("_Tile set:");
#line 624 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp97_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp96_);
#line 624 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp97_);
#line 624 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (label);
#line 624 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	label = _tmp97_;
#line 625 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp98_ = label;
#line 625 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp98_, 0.0f, 0.5f);
#line 626 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp99_ = label;
#line 626 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_set ((GtkWidget*) _tmp99_, "expand", TRUE, NULL);
#line 627 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp100_ = grid;
#line 627 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp101_ = label;
#line 627 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp100_, (GtkWidget*) _tmp101_, 0, 2, 1, 1);
#line 629 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp102_ = (GtkComboBox*) gtk_combo_box_new ();
#line 629 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp102_);
#line 629 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	theme_combo = _tmp102_;
#line 630 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp103_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 630 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp103_);
#line 630 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (renderer);
#line 630 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	renderer = _tmp103_;
#line 631 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp104_ = theme_combo;
#line 631 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp105_ = renderer;
#line 631 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp104_, (GtkCellRenderer*) _tmp105_, TRUE);
#line 632 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp106_ = theme_combo;
#line 632 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp107_ = renderer;
#line 632 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp106_, (GtkCellRenderer*) _tmp107_, "text", 0);
#line 633 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp108_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 633 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 633 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	model = _tmp108_;
#line 634 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp109_ = theme_combo;
#line 634 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp110_ = model;
#line 634 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_combo_box_set_model (_tmp109_, (GtkTreeModel*) _tmp110_);
#line 636 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	dirlist = NULL;
#line 3821 "iagno.c"
	{
		GDir* _tmp111_ = NULL;
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_ = NULL;
		GDir* _tmp114_ = NULL;
		GDir* _tmp115_ = NULL;
		GDir* _tmp116_ = NULL;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp112_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp113_ = _tmp112_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp114_ = g_dir_open (_tmp113_, (guint) 0, &_inner_error_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp115_ = _tmp114_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp113_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp111_ = _tmp115_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 3845 "iagno.c"
				goto __catch4_g_file_error;
			}
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			__g_list_free__g_free0_0 (dirlist);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_dir_close0 (dir);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (theme_combo);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (mode);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (model);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (renderer);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (label);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (grid);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (box);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			block2_data_unref (_data2_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_data2_ = NULL;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			g_clear_error (&_inner_error_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			return;
#line 3876 "iagno.c"
		}
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp116_ = _tmp111_;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp111_ = NULL;
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_dir_close0 (dir);
#line 641 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		dir = _tmp116_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		while (TRUE) {
#line 3888 "iagno.c"
			gchar* filename = NULL;
			GDir* _tmp117_ = NULL;
			const gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			const gchar* _tmp121_ = NULL;
			gchar* _tmp122_ = NULL;
			GCompareFunc _tmp123_ = NULL;
#line 644 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp117_ = dir;
#line 644 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp118_ = g_dir_read_name (_tmp117_);
#line 644 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp119_ = g_strdup (_tmp118_);
#line 644 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			filename = _tmp119_;
#line 645 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp120_ = filename;
#line 645 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (_tmp120_ == NULL) {
#line 646 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (filename);
#line 646 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				break;
#line 3913 "iagno.c"
			}
#line 647 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp121_ = filename;
#line 647 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp122_ = g_strdup (_tmp121_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp123_ = g_strcmp0;
#line 647 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			dirlist = g_list_insert_sorted (dirlist, _tmp122_, _tmp123_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (filename);
#line 3925 "iagno.c"
		}
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_dir_close0 (_tmp111_);
#line 3929 "iagno.c"
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp124_ = NULL;
		const gchar* _tmp125_ = NULL;
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		e = _inner_error_;
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 652 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp124_ = e;
#line 652 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp125_ = _tmp124_->message;
#line 652 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_warning ("iagno.vala:652: Failed to load themes: %s", _tmp125_);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 3949 "iagno.c"
	}
	__finally4:
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		__g_list_free__g_free0_0 (dirlist);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_dir_close0 (dir);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (theme_combo);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (mode);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (model);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (renderer);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (label);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (grid);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (box);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		block2_data_unref (_data2_);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_data2_ = NULL;
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 639 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 3982 "iagno.c"
	}
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp126_ = dirlist;
#line 3986 "iagno.c"
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		filename_collection = _tmp126_;
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
#line 3994 "iagno.c"
			gchar* _tmp127_ = NULL;
			gchar* filename = NULL;
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp127_ = g_strdup ((const gchar*) filename_it->data);
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			filename = _tmp127_;
#line 4001 "iagno.c"
			{
				GtkListStore* _tmp128_ = NULL;
				GtkTreeIter _tmp129_ = {0};
				gchar* label_text = NULL;
				const gchar* _tmp130_ = NULL;
				gchar* _tmp131_ = NULL;
				const gchar* _tmp132_ = NULL;
				gchar* _tmp133_ = NULL;
				gint extension_index = 0;
				const gchar* _tmp134_ = NULL;
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				GtkListStore* _tmp140_ = NULL;
				GtkTreeIter _tmp141_ = {0};
				const gchar* _tmp142_ = NULL;
				const gchar* _tmp143_ = NULL;
				const gchar* _tmp144_ = NULL;
				GSettings* _tmp145_ = NULL;
				gchar* _tmp146_ = NULL;
				gchar* _tmp147_ = NULL;
				gboolean _tmp148_ = FALSE;
#line 657 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp128_ = model;
#line 657 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				gtk_list_store_append (_tmp128_, &_tmp129_);
#line 657 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				iter = _tmp129_;
#line 660 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp130_ = filename;
#line 660 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp131_ = g_strdup (_tmp130_);
#line 660 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				label_text = _tmp131_;
#line 662 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp132_ = label_text;
#line 662 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp133_ = string_replace (_tmp132_, "_", " ");
#line 662 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (label_text);
#line 662 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				label_text = _tmp133_;
#line 663 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp134_ = label_text;
#line 663 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp135_ = string_last_index_of_char (_tmp134_, (gunichar) '.', 0);
#line 663 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				extension_index = _tmp135_;
#line 664 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp136_ = extension_index;
#line 664 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				if (_tmp136_ > 0) {
#line 4053 "iagno.c"
					const gchar* _tmp137_ = NULL;
					gint _tmp138_ = 0;
					gchar* _tmp139_ = NULL;
#line 665 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp137_ = label_text;
#line 665 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp138_ = extension_index;
#line 665 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp139_ = string_substring (_tmp137_, (glong) 0, (glong) _tmp138_);
#line 665 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_g_free0 (label_text);
#line 665 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					label_text = _tmp139_;
#line 4067 "iagno.c"
				}
#line 667 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp140_ = model;
#line 667 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp141_ = iter;
#line 667 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp142_ = label_text;
#line 667 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp143_ = filename;
#line 667 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				gtk_list_store_set (_tmp140_, &_tmp141_, 0, _tmp142_, 1, _tmp143_, -1);
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp144_ = filename;
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp145_ = self->priv->settings;
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp146_ = g_settings_get_string (_tmp145_, "tileset");
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp147_ = _tmp146_;
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp148_ = g_strcmp0 (_tmp144_, _tmp147_) == 0;
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (_tmp147_);
#line 668 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				if (_tmp148_) {
#line 4093 "iagno.c"
					GtkComboBox* _tmp149_ = NULL;
					GtkTreeIter _tmp150_ = {0};
#line 669 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp149_ = theme_combo;
#line 669 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp150_ = iter;
#line 669 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					gtk_combo_box_set_active_iter (_tmp149_, &_tmp150_);
#line 4102 "iagno.c"
				}
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (label_text);
#line 655 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (filename);
#line 4108 "iagno.c"
			}
		}
	}
#line 672 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp151_ = label;
#line 672 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp152_ = theme_combo;
#line 672 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_label_set_mnemonic_widget (_tmp151_, (GtkWidget*) _tmp152_);
#line 673 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp153_ = theme_combo;
#line 673 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp153_, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
#line 674 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp154_ = grid;
#line 674 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp155_ = theme_combo;
#line 674 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp154_, (GtkWidget*) _tmp155_, 1, 2, 1, 1);
#line 676 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp156_ = _ ("E_nable sounds");
#line 676 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp157_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp156_);
#line 676 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp157_);
#line 676 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_->enable_sounds_button = _tmp157_;
#line 677 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp158_ = self->priv->settings;
#line 677 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp158_, "changed::sound", (GCallback) ___lambda8__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 680 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp159_ = self->priv->settings;
#line 680 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp160_ = g_settings_get_boolean (_tmp159_, "sound");
#line 680 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data2_->enable_sounds_button, _tmp160_);
#line 681 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkToggleButton*) _data2_->enable_sounds_button, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
#line 682 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp161_ = grid;
#line 682 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_grid_attach (_tmp161_, (GtkWidget*) _data2_->enable_sounds_button, 0, 3, 2, 1);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__g_list_free__g_free0_0 (dirlist);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_dir_close0 (dir);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (theme_combo);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (renderer);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (label);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (grid);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (box);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	block2_data_unref (_data2_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data2_ = NULL;
#line 4174 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* app = NULL;
	Iagno* _tmp1_ = NULL;
	gint _result_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
#line 687 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 688 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 689 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 690 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 692 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 692 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 694 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 696 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 696 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	app = _tmp1_;
#line 698 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = args;
#line 698 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2__length1 = args_length1;
#line 698 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = g_application_run ((GApplication*) app, _tmp2__length1, _tmp2_);
#line 698 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_result_ = _tmp3_;
#line 700 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = _result_;
#line 700 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (app);
#line 700 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 4219 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 685 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 4229 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->startup = iagno_real_startup;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->activate = iagno_real_activate;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 4248 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 34 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 40 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->computer_timer = (guint) 0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 4261 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 15 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 25 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 26 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 27 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_label);
#line 28 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 29 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_label);
#line 30 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 31 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->propbox);
#line 34 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 43 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 4293 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



