#include <config.h>

#include <gnome.h>
#include <bonobo/bonobo.h>

#include <liboaf/liboaf.h>

#include "bonobo-moniker-file.h"
#include "bonobo-moniker-item.h"
#include "bonobo-moniker-oaf.h"
#include "bonobo-moniker-query.h"
#include "bonobo-moniker-new.h"

static int running_objects = 0;
static BonoboGenericFactory *std_factory = NULL;

static void
std_destroy_cb (BonoboMoniker *moniker, gpointer dummy)
{
	running_objects--;

	if (running_objects > 0)
		return;

	bonobo_object_unref (BONOBO_OBJECT (std_factory));
	gtk_main_quit ();
}

static BonoboObject *
bonobo_moniker_factory (BonoboGenericFactory *this,
			const char           *object_id,
			void                 *data)
{
	BonoboMoniker *moniker = NULL;
	BonoboObject  *object  = NULL;
	
	g_return_val_if_fail (object_id != NULL, NULL);

	if (!strcmp (
		object_id,
		"OAFIID:FileMoniker:50425b-8309-45c5-8e08-7a14c2602438"))

		moniker = gtk_type_new (bonobo_moniker_file_get_type ());

	else if (!strcmp (
		object_id,
		"OAFIID:ItemMoniker:42d4d657-3be0-4e1a-9c1b-16e8da332e05"))

		moniker = gtk_type_new (bonobo_moniker_item_get_type ());
	
	else if (!strcmp (
		object_id,
		"OAFIID:OafMoniker:f7fd21cb-4aa9-4802-83e0-d82eabc983a8"))

		moniker = gtk_type_new (bonobo_moniker_oaf_get_type ());

	else if (!strcmp (
		object_id,
		"OAFIID:NewMoniker:4ebfc80c-95f9-4f66-acfb-1a26b2d04cd4"))

		moniker = gtk_type_new (bonobo_moniker_new_get_type ());

/*
 * Deprecated until Miguel likes it.
 *
 *	else if (!strcmp (
 *		object_id,
 *		"OAFIID:QueryMoniker:fb7f1678-9341-4749-9c5c-c3bb7b93abc1"))
 *		
 *		moniker = gtk_type_new (bonobo_moniker_query_get_type ());
 */
	else
		g_warning ("Failing to manufacture a '%s'", object_id);

	if (moniker) {
		Bonobo_Moniker corba_moniker;

		corba_moniker = bonobo_moniker_corba_object_create (
			BONOBO_OBJECT (moniker));

		if (corba_moniker == CORBA_OBJECT_NIL) {
			bonobo_object_unref (BONOBO_OBJECT (moniker));
			return NULL;
		}

		object = bonobo_object_construct (
			BONOBO_OBJECT (moniker), corba_moniker);
	}

	if (object) {
		running_objects++;
		
		gtk_signal_connect (GTK_OBJECT (moniker), "destroy",
				    GTK_SIGNAL_FUNC (std_destroy_cb), NULL);
	}

	return object;
}

int
main (int argc, char *argv [])
{
	CORBA_Environment ev;
	CORBA_ORB orb = CORBA_OBJECT_NIL;
	char *dummy;

	dummy = malloc (8); if (dummy) free (dummy);

	CORBA_exception_init (&ev);

        gnome_init_with_popt_table ("std-moniker", "0.0", argc, argv,
				    oaf_popt_options, 0, NULL); 
	orb = oaf_init (argc, argv);

	if (bonobo_init (orb, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL) == FALSE)
		g_error (_("I could not initialize Bonobo"));

	std_factory = bonobo_generic_factory_new_multi (
		"OAFIID:MonikerFactory:2a80cf53-0daf-4e94-aac5-b01fbb8e0977",
		bonobo_moniker_factory, NULL);	

	bonobo_main ();
	
	CORBA_exception_free (&ev);

	return 0;
}
