/*
 * bonobo-moniker-config.c: Configuration moniker implementation
 *
 * Author:
 *   Miguel de Icaza (miguel@helixcode.com)
 */
#include <config.h>
#include <gnome.h>
#include <bonobo/bonobo.h>
#include <liboaf/liboaf.h>
#include <liboaf/liboaf.h>
#include "bonobo-moniker-config.h"

static BonoboMonikerClass *bonobo_moniker_config_parent_class;

/* The number of running objects */
static int running_objects;
static BonoboGenericFactory *config_factory = NULL;

static Bonobo_Moniker
config_parse_display_name (BonoboMoniker     *moniker,
			   Bonobo_Moniker     parent,
			   const CORBA_char  *name,
			   CORBA_Environment *ev)
{
	BonoboMonikerConfig *m_config = BONOBO_MONIKER_CONFIG (moniker);
	int i;
	
	g_return_val_if_fail (m_config != NULL, CORBA_OBJECT_NIL);

	bonobo_moniker_set_parent (moniker, parent, ev);

	i = bonobo_moniker_util_seek_std_separator (name, 1);
	bonobo_moniker_set_name (moniker, name, i);

	if (name [i])
		return bonobo_moniker_util_new_from_name_full (
			bonobo_object_corba_objref (BONOBO_OBJECT (m_config)),
			&name [i], ev);
	else
		return bonobo_object_dup_ref (
			bonobo_object_corba_objref (BONOBO_OBJECT (m_config)), ev);
}

static Bonobo_Unknown
config_resolve (BonoboMoniker               *moniker,
		const Bonobo_ResolveOptions *options,
		const CORBA_char            *requested_interface,
		CORBA_Environment           *ev)
{
	Bonobo_Moniker     parent;
	Bonobo_Unknown     retval = CORBA_OBJECT_NIL;
	BonoboPropertyBag *bag;
	
	if (strcmp (requested_interface, "IDL:Bonobo/PropertyBag:1.0"))
		return CORBA_OBJECT_NIL;

	
	return CORBA_OBJECT_NIL;
}

static void
bonobo_moniker_config_class_init (BonoboMonikerConfigClass *klass)
{
	BonoboMonikerClass *mclass = (BonoboMonikerClass *) klass;

	bonobo_moniker_config_parent_class = gtk_type_class (
		bonobo_moniker_get_type ());

	mclass->parse_display_name = config_parse_display_name;
	mclass->resolve            = config_resolve;
}

/**
 * bonobo_moniker_config_get_type:
 *
 * Returns the GtkType for the BonoboMonikerConfig class.
 */
GtkType
bonobo_moniker_config_get_type (void)
{
	static GtkType type = 0;

	if (!type) {
		GtkTypeInfo info = {
			"BonoboMonikerConfig",
			sizeof (BonoboMonikerConfig),
			sizeof (BonoboMonikerConfigClass),
			(GtkClassInitFunc) bonobo_moniker_config_class_init,
			(GtkObjectInitFunc) NULL,
			NULL, /* reserved 1 */
			NULL, /* reserved 2 */
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_moniker_get_type (), &info);
	}

	return type;
}

static void
moniker_config_destroy_cb (BonoboMonikerConfig *m_config, void *data)
{
	running_objects--;

	if (running_objects > 0)
		return;

	bonobo_object_unref (BONOBO_OBJECT (config_factory));
	gtk_main_quit ();
}

static BonoboMonikerConfig *
bonobo_moniker_config_new (void)
{
	BonoboMoniker *moniker;
	Bonobo_Moniker corba_moniker;
		
	moniker = gtk_type_new (bonobo_moniker_config_get_type ());
	corba_moniker = bonobo_moniker_corba_object_create (
		BONOBO_OBJECT (moniker));

	if (corba_moniker == CORBA_OBJECT_NIL){
		bonobo_object_unref (BONOBO_OBJECT (moniker));
		return NULL;
	}

	if (!bonobo_object_construct (BONOBO_OBJECT (moniker), corba_moniker)){
		bonobo_object_unref (BONOBO_OBJECT (moniker));
		return NULL;
	}

	return BONOBO_MONIKER_CONFIG (moniker);
}

static BonoboObject *
bonobo_moniker_config_factory (BonoboGenericFactory *this, void *closure)
{
	BonoboMonikerConfig *m_config = bonobo_moniker_config_new ();

	gtk_signal_connect (GTK_OBJECT (m_config), "destroy",
			    GTK_SIGNAL_FUNC (moniker_config_destroy_cb), NULL);
	
	running_objects++;

	return BONOBO_OBJECT (m_config);
}

int
main (int argc, char *argv [])
{
	CORBA_Environment ev;
	CORBA_ORB orb = CORBA_OBJECT_NIL;

	CORBA_exception_init (&ev);

        gnome_init_with_popt_table ("config-moniker", "0.0", argc, argv,
				    oaf_popt_options, 0, NULL); 
	orb = oaf_init (argc, argv);

	if (bonobo_init (orb, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL) == FALSE)
		g_error (_("I could not initialize Bonobo"));

	config_factory = bonobo_generic_factory_new (
		"OAFIID:ConfigMonikerFactory:3b343b7a-fefd-47a5-b22e-b591c530d86c",
		bonobo_moniker_config_factory, NULL);	

	bonobo_main ();
	
	CORBA_exception_free (&ev);

	return 0;
}
