/*
  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment
  Based on ideas and code segments from "programming windows" C. Petzold

*/
#define NOGDI
#include "nodefs.h"
#include <windows.h>
#include <stdio.h>
#include <string.h>

#define IDD_FNAME    0x10
#define IDD_FPATH    0x11
#define IDD_FLIST    0x12
#define IDD_DLIST    0x13

BOOL FAR PASCAL FileOpenDlgProc (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);
BOOL FAR PASCAL FileSaveDlgProc (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam);

static char szDefExt[5];
static char szFileName[96];
static char szFileSpec[16];
static WORD wFileAttr, wStatus;
static POFSTRUCT pof;

int FAR DoFileOpenDlg (HANDLE hInst, HWND   hWnd, char   *szFileSpecIn,
                       char   *szDefExtIn, WORD   wFileAttrIn,
                       char   *szFileNameOut, POFSTRUCT pofIn)
{
   FARPROC lpfnFileOpenProc;
   int iReturn;

   strcpy ( szFileSpec, szFileSpecIn);
   strcpy ( szDefExt,	szDefExtIn);
   wFileAttr = wFileAttrIn;
   pof = pofIn;

   lpfnFileOpenProc = MakeProcInstance ( FileOpenDlgProc, hInst);
   iReturn = DialogBox ( hInst, "FILEOPEN", hWnd, lpfnFileOpenProc);
   FreeProcInstance ( lpfnFileOpenProc);

   strcpy ( szFileNameOut, szFileName);
   return iReturn;
}

int FAR DoFileSaveDlg (HANDLE hInst, HWND hWnd, char *szFileSpecIn,
                       char *szDefExtIn, WORD *pwStatusOut,
                       char *szFileNameOut, POFSTRUCT pofIn)
{
   FARPROC lpfnFileSaveProc;
   int iReturn;

   strcpy ( szFileSpec, szFileSpecIn);
   strcpy ( szDefExt,	szDefExtIn);
   pof = pofIn;

   lpfnFileSaveProc = MakeProcInstance ( FileSaveDlgProc, hInst);
   iReturn = DialogBox ( hInst, "FILESAVE", hWnd, lpfnFileSaveProc);
   FreeProcInstance ( lpfnFileSaveProc);

   strcpy ( szFileNameOut, szFileName);
   *pwStatusOut = wStatus;
   return iReturn;
}

BOOL FAR PASCAL FileOpenDlgProc (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam)
{
   char cLastChar;
   short nEditLen;

   switch ( iMessage ){
      case WM_INITDIALOG:
         SendDlgItemMessage ( hDlg, IDD_FNAME, EM_LIMITTEXT, 80, 0L);
         DlgDirList ( hDlg, szFileSpec, IDD_FLIST, IDD_FPATH, wFileAttr);
         DlgDirList ( hDlg, szFileSpec, IDD_DLIST, NULL, 0x4010|0x8000);
         SetDlgItemText ( hDlg, IDD_FNAME, szFileSpec);
         return TRUE;

      case WM_COMMAND:
         switch (wParam) {
            case IDD_FLIST:
               switch ( HIWORD(lParam) ) {
                  case LBN_SELCHANGE:
                     if (DlgDirSelect (hDlg, szFileName, IDD_FLIST))
			strcat ( szFileName, szFileSpec) ;
                     SetDlgItemText ( hDlg, IDD_FNAME, szFileName);
                     break;

                  case LBN_DBLCLK:
                     if ( DlgDirSelect (hDlg, szFileName, IDD_FLIST)) {
			strcat ( szFileName, szFileSpec);
                        DlgDirList ( hDlg, szFileName, IDD_FLIST, IDD_FPATH,
                                                       wFileAttr);
                        SetDlgItemText ( hDlg, IDD_FNAME, szFileName);
                     } else {
                        SetDlgItemText ( hDlg, IDD_FNAME, szFileName);
                        SendMessage ( hDlg, WM_COMMAND, IDOK, 0L);
                     }
                     break;
               }
               break;

            case IDD_DLIST:
               switch ( HIWORD(lParam) ) {
                  case LBN_DBLCLK:
                     if ( DlgDirSelect (hDlg, szFileName, IDD_DLIST)) {
			strcat ( szFileName, szFileSpec);
                        DlgDirList ( hDlg, szFileName, IDD_FLIST, IDD_FPATH,
                                                       wFileAttr);
                        DlgDirList ( hDlg, szFileName, IDD_DLIST, NULL, 0x4010|0x8000);
                        SetDlgItemText ( hDlg, IDD_FNAME, szFileName);
                     }
                     break;
               }
               break;


            case IDD_FNAME:
               if (HIWORD (lParam) == EN_CHANGE )
                  EnableWindow ( GetDlgItem(hDlg,IDOK),
                     (BOOL) SendMessage(LOWORD(lParam), WM_GETTEXTLENGTH,
                                         0,0L));
               break;

            case IDOK:
               GetDlgItemText (hDlg, IDD_FNAME, szFileName, 80);
	       nEditLen = strlen ( szFileName);
               cLastChar = *AnsiPrev (szFileName, szFileName+nEditLen);

               if ( cLastChar == '\\' || cLastChar == ':')
		  strcat ( szFileName, szFileSpec);

               if ( strchr (szFileName, '*') || strchr(szFileName, '?') ){
                  if ( DlgDirList (hDlg, szFileName, IDD_FLIST, IDD_FPATH,
                                   wFileAttr)) {
		     strcpy (szFileSpec, szFileName);
                     SetDlgItemText (hDlg, IDD_FNAME, szFileSpec);
                  } else
                     MessageBeep (0);
                  break;
               }
	       strcat ( strcat(szFileName,"\\"), szFileSpec);

               if (DlgDirList ( hDlg, szFileName, IDD_FLIST,
                                                  IDD_FPATH,wFileAttr)) {
		  strcpy ( szFileSpec, szFileName);
                  SetDlgItemText (hDlg, IDD_FNAME, szFileSpec);
                  break;
               }

               szFileName[nEditLen] = '\0';

               if (OpenFile(szFileName, pof, OF_READ|OF_EXIST) == -1) {
		  strcat ( szFileName, szDefExt);
                  if (OpenFile(szFileName, pof, OF_READ|OF_EXIST) == -1) {
                     MessageBeep (0);
                     break;
                  }
               }
	       strcpy ( szFileName, (char *)AnsiNext(strrchr(pof->szPathName,'\\')));
	       OemToAnsi( szFileName, szFileName);
               EndDialog (hDlg, TRUE);
               break;

            case IDCANCEL:
               EndDialog (hDlg, FALSE);
               break;

            default:
               return FALSE;
         }
      default:
         return FALSE;
   }
   return TRUE;
}

BOOL FAR PASCAL FileSaveDlgProc (HWND hDlg, unsigned iMessage, WORD wParam, LONG lParam)
{

   switch ( iMessage ){
      case WM_INITDIALOG:
         SendDlgItemMessage ( hDlg, IDD_FNAME, EM_LIMITTEXT, 80, 0L);
         DlgDirList ( hDlg, szFileSpec, 0, IDD_FPATH, 0);
         SetDlgItemText ( hDlg, IDD_FNAME, szFileSpec);
         return TRUE;

      case WM_COMMAND:
         switch (wParam) {
            case IDD_FNAME:
               if (HIWORD(lParam) == EN_CHANGE)
                  EnableWindow ( GetDlgItem(hDlg, IDOK),
                     (BOOL) SendMessage (LOWORD(lParam), WM_GETTEXTLENGTH,0,0L));
               break;

            case IDOK:
               GetDlgItemText (hDlg, IDD_FNAME, szFileName, 80);
               if ( OpenFile (szFileName, pof,OF_PARSE) == -1) {
                  MessageBeep (0);
                  break;
               }

               if ( !strchr ((PSTR)AnsiNext (strrchr (pof->szPathName,'\\')),'.'))
		  strcat (szFileName, szDefExt);

               if ( OpenFile (szFileName, pof, OF_WRITE|OF_EXIST) != -1) {
                  wStatus = 1;
               } else if ( OpenFile (szFileName, pof, OF_CREATE|OF_EXIST) != -1) {
                  wStatus = 0;
               } else {
                  MessageBeep(0);
                  break;
               }

	       /*
	       strcpy ( szFileName, (char *)AnsiNext(strrchr(pof->szPathName,'\\')));
	       */
	       OemToAnsi(szFileName, szFileName);
               EndDialog (hDlg, TRUE);
               break;
            
            case IDCANCEL:
               EndDialog (hDlg, FALSE);
               break;

            default:
               return FALSE;
      }

      default:
         return FALSE;
   }

   return TRUE;
}
