/*
 * This is a sample REXX file to run metafont, convert the GF file to
 * the PK format and store the PK font in the appropriate directory. It
 * is meant to be called by dviwin and that's the reason for the absence
 * of any parameter checking. It also assumes that metafont and gftopk
 * are operating properly. This is a sample file and attempts to cover
 * as many devices as possible; you will probably get better and faster
 * results if you write a smaller and more specialized file.
 *
 * The plain base is a prerequisite: make sure that you generate it by
 * running inimf on plain.mf, then input the file modes.mf (version 2.1
 * or later; you can get it from the directory /tex-archive/fonts/modes
 * at the CTAN hosts: ftp.shsu.edu, ftp.dante.de and ftp.tex.ac.uk; some
 * modes will not work properly with earlier versions of the modes.mf
 * file) and finally dump the format file. If you don't know what I am
 * talking about, please read the documentation that comes with the
 * metafont program, as well as the Metafont book.
 *
 * You WILL need to modify the routine to place the PK files in the
 * proper directory; the current method uses the environment variable
 * DVIFONTS which is assumed to contain the base directory for the PK
 * fonts. Any square-pixel fonts are assumed to be stored in the
 * directories  $(DVIFONTS)\X  where X is the resolution of the font.
 * Non-square-pixel fonts are assumed to stored in the directories
 * $(DVIFONTS)\XxY where X is the horizontal resolution and Y is the
 * vertical resolution.
 *
 * It is trivial to modify the name of metafont and the base directory;
 * just select the proper values for the first two statements after
 * these comments. If however you use another directory structure, you
 * will also need to modify the definition of the variable pkdir_.
 *
 * You may also need to do more modifications if you have other devices;
 * this file generates fonts for the screen, 300dpi laser and inkjet
 * printers, printers, 600dpi laserjets, as well as 9-pin and 24-pin dot
 * matrix printers. If you want to use another device, you will have to
 * understand the code below and modify it accordingly (maybe you will
 * want to rewrite the code in a compiled language to improve the speed,
 * and the error handling). If you want to use a 9-pin dot matrix printer
 * at 120x144dpi or 240x144dpi, or an HP Deskjet 520 at 600x300dpi, append
 * the following lines to the file modes.mf and regenerate the plain base.
 *
 * mode_def epsmed =		% Epson-FX at 240x144dpi
 * 	mode_param (pixels_per_inch, 240);
 * 	mode_param (aspect_ratio, 144 / pixels_per_inch);
 * 	EpsonMXFX_;
 * enddef;
 *
 * mode_def epsmedl =		% Lanscape version of epsmed
 *	epsmed_;
 *	landscape;
 * enddef;
 *
 * mode_def epswlo =		% Epson-FX at 120x144dpi
 * 	mode_param (pixels_per_inch, 120);
 * 	mode_param (aspect_ratio, 144 / pixels_per_inch);
 * 	EpsonMXFX_;
 * enddef;
 *
 * mode_def epswlol =		% Lanscape version of epswlo
 *	epswlo_;
 *	landscape;
 * enddef;
 *
 * mode_def DJFiveTwenty =	% HP Deskjet at 600x300dpi
 *	mode_param (pixels_per_inch,600);
 *	mode_param (aspect_ratio, 300 / pixels_per_inch);
 *	deskjet_;
 * enddef;
 *
 * mode_def DJFiveTwentyl =	% Landscape version of DJFiveTwenty
 *	DJFiveTwenty_;
 *	landscape;
 * enddef;
 *
 * If Metafont does not recognize any other modes, it will generate
 * its standard proofing fonts which are HUGE and inappropriate for
 * your device. In that case, get the file modes.mf from CTAN and
 * generate the plain base again using the command:
 * 		inimf plain;input modes;dump
 * Then you need to copy plain.bas to the appropriate directory. You
 * may need to replace "inimf" by "mf -i" for some versions of Metafont
 *
 * Here are the parameters passed by dviwin:
 */
	fname_	= WORD(ARG(1),1)
	magst_	= WORD(ARG(1),2)
	xres_	= WORD(ARG(1),3)
	yres_	= WORD(ARG(1),4)
	xbase_	= WORD(ARG(1),5)
	ybase_	= WORD(ARG(1),6)
	gfext_	= WORD(ARG(1),9)
/*
 * In most cases, you will only need to modify the next four lines:
 */
	mfcmd_	= 'mf'
	pkbase_ = value('DVIFONTS',,'OS2ENVIRONMENT')
	IF xbase_ = ybase_ THEN	pkdir_ = pkbase_'\'xres_
	ELSE			pkdir_ = pkbase_'\'xres_'x'yres_
/*
 * Switch to the $TEMP or $TMP directory
 */
	temp_ = value('TEMP',,'OS2ENVIRONMENT')
	if temp_ = '' THEN temp_ = value('TMP',,'OS2ENVIRONMENT')
	CALL directory(temp_)
/*
 * If you want to switch to the directory of the current dvi file, uncomment
 * the next statement. This is useful if you prefer to keep some mf sources
 * in the dvi file directory instead of the $MFINPUTS directory.
 *
 * CALL directory(WORD(ARG(1),7)':'WORD(ARG(1),8))
 */
IF xbase_ = ybase_ THEN		/* Square pixels */
    DO
	IF	xbase_ = 180	THEN pkdev_ = 'lqlores'
	ELSE IF	xbase_ = 360	THEN pkdev_ = 'lqhires'
	ELSE IF	xbase_ = 300	THEN pkdev_ = 'hplaser'
	ELSE IF	xbase_ = 400	THEN pkdev_ = 'nexthi'
	ELSE IF	xbase_ = 600	THEN pkdev_ = 'ljiv'
	ELSE
	    DO
		pkdev_ = 'hplaser'
		IF	xres_ =  58	THEN magst_ = -9
		ELSE IF	xres_ =  64	THEN magst_ = -8.5
		ELSE IF	xres_ =  70	THEN magst_ = -8
		ELSE IF	xres_ =  76	THEN magst_ = -7.5
		ELSE IF	xres_ =  84	THEN magst_ = -7
		ELSE IF	xres_ =  92	THEN magst_ = -6.5
		ELSE IF	xres_ = 100	THEN magst_ = -6
		ELSE IF	xres_ = 110	THEN magst_ = -5.5
		ELSE IF	xres_ = 121	THEN magst_ = -5
		ELSE IF	xres_ = 132	THEN magst_ = -4.5
		ELSE IF	xres_ = 145	THEN magst_ = -4
		ELSE IF	xres_ = 158	THEN magst_ = -3.5
		ELSE IF	xres_ = 174	THEN magst_ = -3
		ELSE IF	xres_ = 190	THEN magst_ = -2.5
		ELSE IF	xres_ = 208	THEN magst_ = -2
		ELSE IF	xres_ = 228	THEN magst_ = -1.5
		ELSE IF	xres_ = 250	THEN magst_ = -1
		ELSE IF	xres_ = 274	THEN magst_ = -0.5
		ELSE IF	xres_ = 300	THEN magst_ =  0
		ELSE IF	xres_ = 329	THEN magst_ =  0.5
		ELSE IF	xres_ = 360	THEN magst_ =  1
		ELSE IF	xres_ = 394	THEN magst_ =  1.5
		ELSE IF	xres_ = 432	THEN magst_ =  2
		ELSE IF	xres_ = 473	THEN magst_ =  2.5
		ELSE IF	xres_ = 518	THEN magst_ =  3
		ELSE IF	xres_ = 568	THEN magst_ =  3.5
		ELSE IF	xres_ = 622	THEN magst_ =  4
		ELSE IF	xres_ = 681	THEN magst_ =  4.5
		ELSE IF	xres_ = 746	THEN magst_ =  5
		ELSE IF	xres_ = 818	THEN magst_ =  5.5
		ELSE IF	xres_ = 896	THEN magst_ =  6
		ELSE IF	xres_ = 981	THEN magst_ =  6.5
		ELSE IF	xres_ = 1075	THEN magst_ =  7
		ELSE IF	xres_ = 1178	THEN magst_ =  7.5
		ELSE IF	xres_ = 1290	THEN magst_ =  8
		ELSE SIGNAL UNKNOWN
	    END
    END
ELSE				/* Non-square pixels */
    DO
	IF	xbase_ = 120 & ybase_ =  72	THEN pkdev_ = 'epsdrft'
	ELSE IF	xbase_ = 120 & ybase_ = 144	THEN pkdev_ = 'epswlo'
	ELSE IF	xbase_ = 240 & ybase_ = 144	THEN pkdev_ = 'epsmed'
	ELSE IF	xbase_ = 240 & ybase_ = 216	THEN pkdev_ = 'epson'
	ELSE IF	xbase_ = 360 & ybase_ = 180	THEN pkdev_ = 'lqmed'
	ELSE IF xbase_ = 600 & ybase_ = 300	THEN pkdev_ = 'DJFiveTwenty'
	ELSE IF xbase_ =  72 & ybase_ = 120	THEN pkdev_ = 'epsdrftl'
	ELSE IF xbase_ = 144 & ybase_ = 120	THEN pkdev_ = 'epswlol'
	ELSE IF xbase_ = 144 & ybase_ = 240	THEN pkdev_ = 'epsmedl'
	ELSE IF xbase_ = 216 & ybase_ = 240	THEN pkdev_ = 'epsonl'
	ELSE IF xbase_ = 180 & ybase_ = 360	THEN pkdev_ = 'lqmedl'
	ELSE IF xbase_ = 300 & ybase_ = 600	THEN pkdev_ = 'DJFiveTwentyl'
	ELSE SIGNAL UNKNOWN
    END
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs
RESULT = STREAM(pkdir_'\'fname_'.pk','c','query exists')
IF RESULT <> '' THEN EXIT
mfcmd_' \scrollmode;mode:='pkdev_';mag:=magstep('magst_');input 'fname_
IF RC > 0 THEN SIGNAL ERROR_EXIT
CALL SysMkDir(pkbase_)
CALL SysMkDir(pkdir_)
RESULT = stream(fname_'.'gfext_,'c','query exists')
IF RESULT = '' THEN gfext_ = xres_
gftopk fname_'.'gfext_ pkdir_'\'fname_'.pk'
CALL SysFileDelete(fname_'.'gfext_)
CALL SysFileDelete(fname_'.log')
/*
 * If you want to copy the TFM file to the appropriate directory, here
 * is the place to do it.
 */
CALL SysFileDelete(fname_'.tfm')
EXIT

/*
 * This is where we come if we don't know about the requested resolution
 */
UNKNOWN:	SAY "I don't know the Metafont mode for this device. Please"
		SAY "add this information to the file genpk.cmd"
ERROR_EXIT:	SAY "Press Enter to continue..."
		PULL junk_
		EXIT
