#!/bin/bash
#
#  This file belongs to MTYPE13 package by Wlodek Bzyl <matwb@univ.gda.pl>
#
#  read-texmf.sh
#
#  $Date: 2003/11/22 00:04:01 $
#  $Revision: 1.1.1.1 $

script_name=$(basename $0)
version=1.0
usage="$script_name"
if test "quiet" = "$1"; then
    verbose=0
else
    verbose=1
fi

exitwith() {
    exec 1>&2  # write stdout on stderr
    case "$1" in
	ErrBinary)
	    echo "Program '$2' not found. Please install it."
	    exit 1;;
	*)
	    echo "Error: exitwith() was called with illegal error code '$1'."
	    exit 10;;
    esac
}

kpsewhich_prog=kpsewhich # from the `tetex' package
sed_prog=sed # standard unix utilities
tr_prog=tr 
sort_prog=sort
install_prog=install # used in Makefile
install_data=cp

# Check for programs

for i in $kpsewhich_prog $sed_prog $tr_prog $sort_prog $install_prog $install_data; do
  if ! type -p $i > /dev/null ; then exitwith ErrBinary $i ; fi
done

# Remove temporary files when exiting the program via SIGHUP, SIGINT, SIGTERM

trap 'rm -f $texmf_makefile $texmf_cnf mtype13.{tex,log} ; exit' 1 2 15

# Names of generated files

texmf_makefile=texmf.mk
texmf_cnf=texmf-local.cnf

LANG=C
export LANG 
 
echo "#" > $texmf_makefile
echo "# This makefile was generated by the \`$script_name' script on:" $(date) >> $texmf_makefile
echo "#" >> $texmf_makefile

echo "%" > $texmf_cnf
echo "% This CNF file was generated by the \`$script_name' script on:" $(date) >> $texmf_cnf
echo "%" >> $texmf_cnf

function mk_append() 
{
    echo $1 >> $texmf_makefile
}

function texmf_append() 
{
    echo $1 >> $texmf_cnf
}

function message() 
{
    if test $verbose -eq 1; then
	echo -e "$1"
    fi
}

# 1. Find the web2c/kpathsea configuration file which is read first.

# Even if several `texmf.cnf' files are read kpsewhich reports only 
# the first one.

kpsewhich_texmf_cnf=$(kpsewhich texmf.cnf)

# To get the complete list of texmf.cnf files actually read by any
# web2c programs, we create an empty tex source, set path searching
# debugging flag to 4 (which means show names of opened files) and
# run tex thru this file.

echo "\\end" > mtype13.tex

list_texmf_cnf=$(tex --kpathsea-debug=4 mtype13.tex 2>&1 | egrep "^kdebug:fopen\(.+/texmf.cnf, r\) =>" | sort -u | sed -e 's|^kdebug:fopen(\(.*\), r) => 0x.*|\1 |')
rm -f mtype13.{tex,log,dvi}

number_of_read_texmf_cnf=$(echo $list_texmf_cnf | wc -l | tr -d ' ')
message "The list of web2c/kpathsea configuration files:"
used_texmf_cnf=$(echo $list_texmf_cnf) # replace newlines to spaces
for file in $used_texmf_cnf; do
    message "\t$file";
done

selfautoparent=$(kpsewhich --expand-var=\$SELFAUTOPARENT)
message "The value of the SELFAUTOPARENT variable:"
message "\t$selfautoparent"
texmf_main=$(kpsewhich --expand-var=\$TEXMFMAIN)
message "The TEXMFMAIN tree on this system is rooted at:"
message "\t$texmf_main"

# Allow TeX, MF, and MP to parse the first line of an input file for
# the %&format construct.

parse_first_line=""
texmfmain=""
texmflocal=""
vartexmf=""
hometexmf=""
texmf=""
texpsheaders=""
texconfig=""

# Earlier values, in the same or another configuration file,
# override later ones, and a value of environment
# variable overrides any definition found in configuration file.

for file in $used_texmf_cnf; do
    parse_first_line=$(cat $file | egrep '^ *parse_first_line *= *')
    if test -n "$parse_first_line"; then break; fi
done

for file in $used_texmf_cnf; do
    texmfmain=$(cat $file | egrep '^ *TEXMFMAIN *= *')
    if test -n "$texmfmain"; then break; fi
done
if test -n "$TEXMFMAIN" ; then
    texmfmain="$TEXMFMAIN"
fi

for file in $used_texmf_cnf; do
    texmflocal=$(cat $file | egrep '^ *TEXMFLOCAL *= *')
    if test -n "$texmflocal"; then break; fi
done
if test -n "$TEXMFLOCAL" ; then
    texmflocal="$TEXMFLOCAL"
fi

for file in $used_texmf_cnf; do
    vartexmf=$(cat $file | egrep '^ *VARTEXMF *= *')
    if test -n "$vartexmf"; then break; fi
done
if test -n "$VARTEXMF" ; then
    vartexmf="$VARTEXMF"
fi

for file in $used_texmf_cnf; do
    hometexmf=$(cat $file | egrep '^ *HOMETEXMF *= *')
    if test -n "$hometexmf"; then break; fi
done
if test -n "$HOMETEXMF" ; then
    hometexmf="$HOMETEXMF"
fi

for file in $used_texmf_cnf; do
    texmf=$(cat $file | egrep '^ *TEXMF *= *')
    if test -n "$texmf"; then break; fi
done
if test -n "$TEXMF" ; then
    texmf="$TEXMF"
fi

for file in $used_texmf_cnf; do
    texpsheaders=$(cat $file | egrep '^ *TEXPSHEADERS *= *')
    if test -n "$texpsheaders"; then break; fi
done
if test -n "$TEXPSHEADERS" ; then
    texpsheaders="$TEXPSHEADERS"
fi

for file in $used_texmf_cnf; do
    texconfig=$(cat $file | egrep '^ *TEXCONFIG *= *')
    if test -n "$texconfig"; then break; fi
done
if test -n "$TEXCONFIG" ; then
    texconfig="$TEXCONFIG"
fi

texmf_local="$selfautoparent/texmf-local"
var_texmf="$selfautoparent/texmf-var"

m_texmfmain="TEXMFMAIN = $selfautoparent/texmf"
m_texmflocal="TEXMFLOCAL = $selfautoparent/texmf-local"
m_vartexmf="VARTEXMF = $selfautoparent/texmf-var"
m_hometexmf='HOMETEXMF = texmf,../texmf,$HOME/texmf'
m_texmf='TEXMF = {$HOMETEXMF,!!$TEXMFLOCAL,!!$VARTEXMF,!!$TEXMFMAIN}'
m_texmfdbs='TEXMFDBS = $TEXMFLOCAL,$VARTEXMF,$TEXMFMAIN'
m_systexmf='SYSTEXMF = $TEXMFLOCAL,$VARTEXMF,$TEXMFMAIN,$VARTEXFONTS'
m_texpsheaders='TEXPSHEADERS = .;$TEXMF/{dvips,pdftex,tex,fonts/{type1,type3}}//'
m_texconfig='TEXCONFIG = .,$TEXMF/dvips//'
m_parse_first_line='parse_first_line = t'

message "COMPARISON OF VARIABLES' VALUES RELEVANT TO FONT CREATION"
message "   suggested: $m_hometexmf"
message "       found: $hometexmf"
message "   suggested: $m_texpsheaders"
message "       found: $texpsheaders"
message "   suggested: $m_texmf"
message "       found: $texmf"
message "   suggested: $m_texconfig"
message "       found: $texconfig"
message "   suggested: $m_texmfdbs"
message "       found: $texmfdbs"
message "   suggested: $m_systexmf"
message "       found: $systexmf"
message "   suggested: $m_parse_first_line"
message "       found: $parse_first_line"

# Write $(texmf_makefile)

mk_append "texmflocal=$texmf_local"
mk_append "vartexmf=$var_texmf"

# Write $(texmf_cnf)

texmf_append "$m_texmflocal"
texmf_append "$m_vartexmf"
texmf_append "$m_hometexmf"
texmf_append "$m_texmf"
texmf_append "$m_texmfdbs"
texmf_append "$m_systexmf"
texmf_append "$m_texpsheaders"
texmf_append "$m_texconfig"
texmf_append "$m_parse_first_line"
