---
myst:
  html_meta:
    keywords: LaTeX, composition, langues, césure
---

# Comment empêcher la césure d'un mot particulier ?

Il est tout à fait possible que la césure d'un mot particulier (quel qu'il soit) 
semble "complètement erronée", de sorte que l'on veuille éviter qu'il soit césuré.

Si le mot n'apparaît vraiment qu'à un seul endroit, placez-le dans une boîte :

```{noedit}
\mbox{bizarrerie}
```

Ici, les utilisateurs de Plain TeX devraient utiliser `\hbox` et se méfier 
des débuts des paragraphes. 

Si le mot apparaît souvent, le meilleur choix est de définir une exception de césure 
pour lui :

```{noedit}
\hyphenation{bizarrerie}
```

Cette exception de césure (sans point de rupture) sera utilisée prioritairement 
à ce que l'algorithme de césure de TeX pourrait proposer.

Dans un document multilingue, il convient de répéter cette exception 
pour chaque langue dans laquelle le mot peut apparaître. Ainsi :

```{noedit}
\usepackage[french,english]{babel}
\selectlanguage{english}
\hyphenation{bizarrerie}
\selectlanguage{french}
\hyphenation{bizarrerie}
```

Notez que l'extension <ctanpkg:babel> sélectionnera la langue par défaut du document 
--- l'anglais dans notre exemple --- au moment du  `\begin{document}`.

Un exemple particulier associé à ce besoin est celui d'éviter la césure d'acronymes. 
Une règle générale pour ceux qui concoctent des acronymes semble être de faire en sorte que
la séquence de lettres majuscules soit aussi proche que possible d'un "vrai mot", 
mais la césure d'un acronyme n'est pas très heureuse. 
La commande TeX `\uchyph` est conçue pour supprimer ce comportement 
en empêchant la césure des mots en majuscules :

```{noedit}
\uchyph=0
```

Il faut noter qu'il n'existe pas d'alternative LaTeX pour définir cette valeur.


:::{sources}
[Preventing hyphenation of a particular word](faquk:FAQ-wdnohyph)
:::