#########################################################################################
# Package        HiPi::Graphics::BitmapFont::MonoExtended21
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::MonoExtended21;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 21;
my $line_spacing = 0;
my $name = 'Mono 21';
my $space_width = 10;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 5, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x09, 0x80, ##      0  00 
            0x09, 0x80, ##      0  00 
            0x09, 0x00, ##      0  0  
            0x09, 0x00, ##      0  0  
            0x7F, 0xC0, ##   000000000
            0x13, 0x00, ##     0  00  
            0x12, 0x00, ##     0  0   
            0x12, 0x00, ##     0  0   
            0xFF, 0x80, ##  000000000 
            0x26, 0x00, ##    0  00   
            0x24, 0x00, ##    0  0    
            0x24, 0x00, ##    0  0    
            0x64, 0x00, ##   00  0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x10, ##     0    
            0x10, ##     0    
            0x10, ##     0    
            0x7E, ##   000000 
            0xD2, ##  00 0  0 
            0xD0, ##  00 0    
            0xD0, ##  00 0    
            0xF0, ##  0000    
            0x7C, ##   00000  
            0x17, ##     0 000
            0x13, ##     0  00
            0x13, ##     0  00
            0x97, ##  0  0 000
            0xFC, ##  000000  
            0x10, ##     0    
            0x10, ##     0    
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x00, ##   000      
            0x88, 0x00, ##  0   0     
            0x88, 0x00, ##  0   0     
            0x88, 0x00, ##  0   0     
            0x71, 0x80, ##   000   00 
            0x06, 0x00, ##       00   
            0x18, 0x00, ##     00     
            0x67, 0x80, ##   00  0000 
            0x0C, 0xC0, ##      00  00
            0x08, 0x40, ##      0    0
            0x0C, 0xC0, ##      00  00
            0x07, 0x80, ##       0000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x22, 0x00, ##    0   0   
            0x20, 0x00, ##    0       
            0x20, 0x00, ##    0       
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x68, 0x00, ##   00 0     
            0xCC, 0xC0, ##  00  00  00
            0xC4, 0xC0, ##  00   0  00
            0xC6, 0xC0, ##  00   00 00
            0xC3, 0x80, ##  00    000 
            0x63, 0x80, ##   00   000 
            0x3D, 0xC0, ##    0000 000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x10, ##     0
            0x20, ##    0 
            0x60, ##   00 
            0x60, ##   00 
            0x40, ##   0  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0x40, ##   0  
            0x60, ##   00 
            0x60, ##   00 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 4, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x40, ##   0  
            0x60, ##   00 
            0x60, ##   00 
            0x20, ##    0 
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x20, ##    0 
            0x60, ##   00 
            0x60, ##   00 
            0x40, ##   0  
            0x80, ##  0   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x10, ##     0   
            0x10, ##     0   
            0xD6, ##  00 0 00
            0x38, ##    000  
            0x38, ##    000  
            0xD6, ##  00 0 00
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0xFF, 0x80, ##  000000000
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 4, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x03, ##        00
            0x02, ##        0 
            0x06, ##       00 
            0x04, ##       0  
            0x0C, ##      00  
            0x0C, ##      00  
            0x18, ##     00   
            0x18, ##     00   
            0x10, ##     0    
            0x30, ##    00    
            0x20, ##    0     
            0x60, ##   00     
            0x40, ##   0      
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x78, ##   0000  
            0xF8, ##  00000  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0x86, ##  0    00 
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x07, ##       000
            0x06, ##       00 
            0x0C, ##      00  
            0x18, ##     00   
            0x30, ##    00    
            0x60, ##   00     
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0x86, ##  0    00 
            0x03, ##        00
            0x03, ##        00
            0x07, ##       000
            0x3E, ##    00000 
            0x06, ##       00 
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x86, ##  0    00 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0E, 0x00, ##      000  
            0x0E, 0x00, ##      000  
            0x1E, 0x00, ##     0000  
            0x16, 0x00, ##     0 00  
            0x36, 0x00, ##    00 00  
            0x26, 0x00, ##    0  00  
            0x66, 0x00, ##   00  00  
            0x46, 0x00, ##   0   00  
            0xC6, 0x00, ##  00   00  
            0xFF, 0x80, ##  000000000
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000 
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xF8, ##  00000  
            0x0C, ##      00 
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x0C, ##      00 
            0xF8, ##  00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000 
            0x60, ##   00     
            0x60, ##   00     
            0xC0, ##  00      
            0xDC, ##  00 000  
            0xE6, ##  000  00 
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x63, ##   00   00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0x03, ##        00
            0x02, ##        0 
            0x06, ##       00 
            0x06, ##       00 
            0x0C, ##      00  
            0x0C, ##      00  
            0x08, ##      0   
            0x18, ##     00   
            0x18, ##     00   
            0x10, ##     0    
            0x30, ##    00    
            0x30, ##    00    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0xE7, ##  000  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE6, ##  000  00 
            0x78, ##   0000   
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC2, ##  00    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x67, ##   00  000
            0x3B, ##    000 00
            0x03, ##        00
            0x03, ##        00
            0x02, ##        0 
            0x46, ##   0   00 
            0x7C, ##   00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x80, ##          0
            0x07, 0x80, ##       0000
            0x1E, 0x00, ##     0000  
            0xF0, 0x00, ##  0000     
            0xC0, 0x00, ##  00       
            0x78, 0x00, ##   0000    
            0x1E, 0x00, ##     0000  
            0x03, 0x80, ##        000
            0x00, 0x80, ##          0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x80, 0x00, ##  0        
            0xF0, 0x00, ##  0000     
            0x3C, 0x00, ##    0000   
            0x07, 0x80, ##       0000
            0x01, 0x80, ##         00
            0x0F, 0x00, ##      0000 
            0x3C, 0x00, ##    0000   
            0xE0, 0x00, ##  000      
            0x80, 0x00, ##  0        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000 
            0x8E, ##  0   000
            0x06, ##       00
            0x06, ##       00
            0x0E, ##      000
            0x1C, ##     000 
            0x38, ##    000  
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##         
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000  
            0x21, 0x00, ##    0    0 
            0x40, 0x80, ##   0      0
            0x40, 0x80, ##   0      0
            0x8F, 0x80, ##  0   00000
            0x9D, 0x80, ##  0  000 00
            0x98, 0x80, ##  0  00   0
            0x98, 0x80, ##  0  00   0
            0x98, 0x80, ##  0  00   0
            0x9D, 0x80, ##  0  000 00
            0x8F, 0x80, ##  0   00000
            0x40, 0x00, ##   0       
            0x60, 0x00, ##   00      
            0x30, 0x00, ##    00     
            0x0F, 0x00, ##      0000 
            0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00    
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1A, 0x00, ##     00 0   
            0x12, 0x00, ##     0  0   
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x21, 0x00, ##    0    0  
            0x3F, 0x80, ##    0000000 
            0x61, 0x80, ##   00    00 
            0x60, 0x80, ##   00     0 
            0x40, 0x80, ##   0      0 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0xC6, ##  00   00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC6, ##  00   00 
            0xFC, ##  000000  
            0xC6, ##  00   00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1F, ##     00000
            0x31, ##    00   0
            0x60, ##   00     
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x60, ##   00     
            0x31, ##    00   0
            0x1F, ##     00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000   
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xF8, ##  00000   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000 
            0x31, 0x00, ##    00   0 
            0x60, 0x00, ##   00      
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC7, 0x80, ##  00   0000
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x61, 0x80, ##   00    00
            0x31, 0x80, ##    00   00
            0x1F, 0x00, ##     00000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xFF, ##  00000000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x8C, ##  0   00 
            0xF8, ##  00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00
            0xC3, 0x00, ##  00    00 
            0xC6, 0x00, ##  00   00  
            0xCC, 0x00, ##  00  00   
            0xD8, 0x00, ##  00 00    
            0xF8, 0x00, ##  00000    
            0xF8, 0x00, ##  00000    
            0xCC, 0x00, ##  00  00   
            0xC4, 0x00, ##  00   0   
            0xC6, 0x00, ##  00   00  
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xD5, 0x80, ##  00 0 0 00
            0xD5, 0x80, ##  00 0 0 00
            0xD5, 0x80, ##  00 0 0 00
            0xD5, 0x80, ##  00 0 0 00
            0xC9, 0x80, ##  00  0  00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE3, ##  000   00
            0xE3, ##  000   00
            0xE3, ##  000   00
            0xF3, ##  0000  00
            0xD3, ##  00 0  00
            0xD3, ##  00 0  00
            0xDB, ##  00 00 00
            0xCB, ##  00  0 00
            0xCB, ##  00  0 00
            0xCF, ##  00  0000
            0xC7, ##  00   000
            0xC7, ##  00   000
            0xC7, ##  00   000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000  
            0xC6, ##  00   00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC6, ##  00   00 
            0xFC, ##  000000  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x04, ##       0  
            0x06, ##       00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000   
            0xC6, 0x00, ##  00   00  
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xC7, 0x00, ##  00   000 
            0xFE, 0x00, ##  0000000  
            0xC6, 0x00, ##  00   00  
            0xC2, 0x00, ##  00    0  
            0xC3, 0x00, ##  00    00 
            0xC3, 0x00, ##  00    00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000 
            0x62, ##   00   0 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xF8, ##  00000   
            0x7E, ##   000000 
            0x0F, ##      0000
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x86, ##  0    00 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x40, 0xC0, ##   0      00
            0x60, 0x80, ##   00     0 
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x21, 0x80, ##    0    00 
            0x31, 0x00, ##    00   0  
            0x33, 0x00, ##    00  00  
            0x13, 0x00, ##     0  00  
            0x12, 0x00, ##     0  0   
            0x1A, 0x00, ##     00 0   
            0x1E, 0x00, ##     0000   
            0x0E, 0x00, ##      000   
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x40, ##  00       0
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xCC, 0xC0, ##  00  00  00
            0x4C, 0xC0, ##   0  00  00
            0x4C, 0x80, ##   0  00  0 
            0x4E, 0x80, ##   0  000 0 
            0x7A, 0x80, ##   0000 0 0 
            0x72, 0x80, ##   000  0 0 
            0x72, 0x80, ##   000  0 0 
            0x73, 0x80, ##   000  000 
            0x33, 0x80, ##    00  000 
            0x31, 0x00, ##    00   0  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x60, 0xC0, ##   00     00
            0x21, 0x80, ##    0    00 
            0x31, 0x00, ##    00   0  
            0x13, 0x00, ##     0  00  
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x1A, 0x00, ##     00 0   
            0x33, 0x00, ##    00  00  
            0x21, 0x80, ##    0    00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x12, 0x00, ##     0  0   
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0x03, ##        00
            0x06, ##       00 
            0x06, ##       00 
            0x0C, ##      00  
            0x08, ##      0   
            0x18, ##     00   
            0x10, ##     0    
            0x30, ##    00    
            0x60, ##   00     
            0x60, ##   00     
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0x40, ##   0      
            0x60, ##   00     
            0x60, ##   00     
            0x20, ##    0     
            0x30, ##    00    
            0x10, ##     0    
            0x18, ##     00   
            0x08, ##      0   
            0x0C, ##      00  
            0x04, ##       0  
            0x06, ##       00 
            0x06, ##       00 
            0x02, ##        0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 4, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00    
            0x3C, 0x00, ##    0000   
            0x66, 0x00, ##   00  00  
            0x43, 0x00, ##   0    00 
            0xC1, 0x00, ##  00     0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00  
            0x60, ##   00 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xDC, ##  00 000  
            0xE6, ##  000  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE6, ##  000  00 
            0xDC, ##  00 000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000
            0x62, ##   00   0
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0x62, ##   00   0
            0x3E, ##    00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x3B, ##    000 00
            0x67, ##   00  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x67, ##   00  000
            0x3B, ##    000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x63, ##   00   00
            0x3E, ##    00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1E, ##     0000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3B, ##    000 00
            0x67, ##   00  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x67, ##   00  000
            0x3B, ##    000 00
            0x03, ##        00
            0x03, ##        00
            0x46, ##   0   00 
            0x7C, ##   00000  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xDC, ##  00 000 
            0xE6, ##  000  00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x18, ##     00   
            0x18, ##     00   
            0x00, ##          
            0x00, ##          
            0x78, ##   0000   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x18, ##     00
            0x18, ##     00
            0x00, ##       
            0x00, ##       
            0xF8, ##  00000
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x38, ##    000
            0xF0, ##  0000 
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC2, ##  00    0 
            0xC4, ##  00   0  
            0xC8, ##  00  0   
            0xD0, ##  00 0    
            0xF8, ##  00000   
            0xC8, ##  00  0   
            0xCC, ##  00  00  
            0xC6, ##  00   00 
            0xC2, ##  00    0 
            0xC3, ##  00    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x1E, ##     0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF6, ##  0000 00 
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0xDB, ##  00 00 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xDC, ##  00 000 
            0xE6, ##  000  00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xDC, ##  00 000  
            0xE6, ##  000  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE6, ##  000  00 
            0xDC, ##  00 000  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3B, ##    000 00
            0x67, ##   00  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x67, ##   00  000
            0x3B, ##    000 00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
            0x03, ##        00
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xDE, ##  00 0000
            0xE2, ##  000   0
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000 
            0xC0, ##  00     
            0xC0, ##  00     
            0xE0, ##  000    
            0xFC, ##  000000 
            0x3E, ##    00000
            0x06, ##       00
            0x06, ##       00
            0x86, ##  0    00
            0xF8, ##  00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x1E, ##     0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xCE, ##  00  000
            0x76, ##   000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC1, ##  00     0
            0xC3, ##  00    00
            0x43, ##   0    00
            0x62, ##   00   0 
            0x66, ##   00  00 
            0x26, ##    0  00 
            0x24, ##    0  0  
            0x3C, ##    0000  
            0x1C, ##     000  
            0x18, ##     00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x40, ##  00       0
            0xC0, 0xC0, ##  00      00
            0x40, 0xC0, ##   0      00
            0x4C, 0x80, ##   0  00  0 
            0x4C, 0x80, ##   0  00  0 
            0x6C, 0x80, ##   00 00  0 
            0x6B, 0x80, ##   00 0 000 
            0x33, 0x80, ##    00  000 
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC3, 0x00, ##  00    00 
            0x62, 0x00, ##   00   0  
            0x26, 0x00, ##    0  00  
            0x3C, 0x00, ##    0000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x3C, 0x00, ##    0000   
            0x66, 0x00, ##   00  00  
            0x43, 0x00, ##   0    00 
            0xC3, 0x00, ##  00    00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00
            0x41, 0x80, ##   0     00
            0x61, 0x00, ##   00    0 
            0x23, 0x00, ##    0   00 
            0x22, 0x00, ##    0   0  
            0x32, 0x00, ##    00  0  
            0x16, 0x00, ##     0 00  
            0x14, 0x00, ##     0 0   
            0x1C, 0x00, ##     000   
            0x0C, 0x00, ##      00   
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x70, 0x00, ##   000     
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0x06, ##       00
            0x0C, ##      00 
            0x08, ##      0  
            0x18, ##     00  
            0x30, ##    00   
            0x20, ##    0    
            0x60, ##   00    
            0xC0, ##  00     
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1C, ##     000
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0xC0, ##  00    
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x1C, ##     000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000   
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x0C, ##      00
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0xE0, ##  000   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x78, 0x80, ##   0000   0
            0x87, 0x00, ##  0    000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x08, ##      0  
            0x08, ##      0  
            0x08, ##      0  
            0x3E, ##    00000
            0x68, ##   00 0  
            0xC8, ##  00  0  
            0xC8, ##  00  0  
            0xC8, ##  00  0  
            0xC8, ##  00  0  
            0xC8, ##  00  0  
            0xE8, ##  000 0  
            0x7A, ##   0000 0
            0x3E, ##    00000
            0x08, ##      0  
            0x08, ##      0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x0F, ##      0000
            0x18, ##     00   
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x7E, ##   000000 
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x81, ##  0      0
            0x7E, ##   000000 
            0x66, ##   00  00 
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x7E, ##   000000 
            0x81, ##  0      0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x7F, 0x80, ##   00000000 
            0x0C, 0x00, ##      00    
            0x7F, 0x80, ##   00000000 
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000 
            0xC0, ##  00     
            0xC0, ##  00     
            0xE0, ##  000    
            0x30, ##    00   
            0xFC, ##  000000 
            0xCE, ##  00  000
            0xC6, ##  00   00
            0xE6, ##  000  00
            0x34, ##    00 0 
            0x18, ##     00  
            0x0E, ##      000
            0x06, ##       00
            0x86, ##  0    00
            0xFC, ##  000000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 5, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00
            0xD8, ##  00 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x21, 0x00, ##    0    0  
            0x5E, 0x80, ##   0 0000 0 
            0xB0, 0x40, ##  0 00     0
            0xA0, 0x40, ##  0 0      0
            0xA0, 0x40, ##  0 0      0
            0xA0, 0x40, ##  0 0      0
            0xB0, 0x40, ##  0 00     0
            0x5E, 0x80, ##   0 0000 0 
            0x21, 0x00, ##    0    0  
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000 
            0x88, ##  0   0
            0x08, ##      0
            0x78, ##   0000
            0x88, ##  0   0
            0x88, ##  0   0
            0xF8, ##  00000
            0x00, ##       
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x11, ##     0   0
            0x32, ##    00  0 
            0x64, ##   00  0  
            0xC8, ##  00  0   
            0xCC, ##  00  00  
            0x26, ##    0  00 
            0x13, ##     0  00
            0x01, ##         0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 4, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x21, 0x00, ##    0    0  
            0x5C, 0x80, ##   0 000  0 
            0x92, 0x40, ##  0  0  0  0
            0x92, 0x40, ##  0  0  0  0
            0x9C, 0x40, ##  0  000   0
            0x94, 0x40, ##  0  0 0   0
            0x92, 0x40, ##  0  0  0  0
            0x40, 0x80, ##   0      0 
            0x21, 0x00, ##    0    0  
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 5, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0xFF, 0x80, ##  000000000
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000 
            0x08, ##      0
            0x08, ##      0
            0x10, ##     0 
            0x20, ##    0  
            0x40, ##   0   
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000 
            0x08, ##      0
            0x08, ##      0
            0x30, ##    00 
            0x08, ##      0
            0x08, ##      0
            0xF0, ##  0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x30, ##    00
            0x20, ##    0 
            0x40, ##   0  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xCE, ##  00  000 
            0xFB, ##  00000 00
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7E, ##   000000
            0xF2, ##  0000  0
            0xF2, ##  0000  0
            0xF2, ##  0000  0
            0xF2, ##  0000  0
            0xF2, ##  0000  0
            0x72, ##   000  0
            0x12, ##     0  0
            0x12, ##     0  0
            0x12, ##     0  0
            0x12, ##     0  0
            0x12, ##     0  0
            0x12, ##     0  0
            0x12, ##     0  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 3, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0x20, ##    0
            0x20, ##    0
            0xE0, ##  000
            0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 5, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x78, ##   0000 
            0xCC, ##  00  00
            0x84, ##  0    0
            0x84, ##  0    0
            0x84, ##  0    0
            0xCC, ##  00  00
            0x78, ##   0000 
            0x00, ##        
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x88, ##  0   0   
            0xCC, ##  00  00  
            0x66, ##   00  00 
            0x33, ##    00  00
            0x32, ##    00  0 
            0x64, ##   00  0  
            0x88, ##  0   0   
            0x00, ##          
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000     
            0x20, ##    0     
            0x20, ##    0     
            0x20, ##    0     
            0x20, ##    0     
            0x20, ##    0     
            0xF8, ##  00000   
            0x07, ##       000
            0x78, ##   0000   
            0x82, ##  0     0 
            0x06, ##       00 
            0x0A, ##      0 0 
            0x0A, ##      0 0 
            0x12, ##     0  0 
            0x1F, ##     00000
            0x02, ##        0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000      
            0x20, 0x00, ##    0      
            0x20, 0x00, ##    0      
            0x20, 0x00, ##    0      
            0x20, 0x00, ##    0      
            0x20, 0x00, ##    0      
            0xF8, 0x00, ##  00000    
            0x03, 0x80, ##        000
            0x1E, 0x00, ##     0000  
            0xE0, 0x00, ##  000      
            0x0F, 0x00, ##      0000 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x0F, 0x80, ##      00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x78, 0x00, ##   0000     
            0x04, 0x00, ##       0    
            0x04, 0x00, ##       0    
            0x38, 0x00, ##    000     
            0x04, 0x00, ##       0    
            0x04, 0x00, ##       0    
            0x78, 0x00, ##   0000     
            0x03, 0xC0, ##        0000
            0x3C, 0x00, ##    0000    
            0x41, 0x80, ##   0     00 
            0x01, 0x80, ##         00 
            0x02, 0x80, ##        0 0 
            0x04, 0x80, ##       0  0 
            0x0C, 0x80, ##      00  0 
            0x0F, 0xC0, ##      000000
            0x00, 0x80, ##          0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x18, ##     00  
            0x18, ##     00  
            0x00, ##         
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x30, ##    00   
            0x70, ##   000   
            0xE0, ##  000    
            0xC0, ##  00     
            0xC0, ##  00     
            0xE6, ##  000  00
            0x7C, ##   00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x18, 0x00, ##     00     
            0x08, 0x00, ##      0     
            0x04, 0x00, ##       0    
            0x00, 0x00, ##            
            0x0C, 0x00, ##      00    
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1A, 0x00, ##     00 0   
            0x12, 0x00, ##     0  0   
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x21, 0x00, ##    0    0  
            0x3F, 0x80, ##    0000000 
            0x61, 0x80, ##   00    00 
            0x60, 0x80, ##   00     0 
            0x40, 0x80, ##   0      0 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x02, 0x00, ##        0   
            0x04, 0x00, ##       0    
            0x08, 0x00, ##      0     
            0x00, 0x00, ##            
            0x0C, 0x00, ##      00    
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1A, 0x00, ##     00 0   
            0x12, 0x00, ##     0  0   
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x21, 0x00, ##    0    0  
            0x3F, 0x80, ##    0000000 
            0x61, 0x80, ##   00    00 
            0x60, 0x80, ##   00     0 
            0x40, 0x80, ##   0      0 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x13, 0x00, ##     0  00  
            0x00, 0x00, ##            
            0x0C, 0x00, ##      00    
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1A, 0x00, ##     00 0   
            0x12, 0x00, ##     0  0   
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x21, 0x00, ##    0    0  
            0x3F, 0x80, ##    0000000 
            0x61, 0x80, ##   00    00 
            0x60, 0x80, ##   00     0 
            0x40, 0x80, ##   0      0 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x0C, 0x00, ##      00    
            0x1C, 0x00, ##     000    
            0x16, 0x00, ##     0 00   
            0x16, 0x00, ##     0 00   
            0x32, 0x00, ##    00  0   
            0x32, 0x00, ##    00  0   
            0x23, 0x00, ##    0   00  
            0x23, 0x00, ##    0   00  
            0x7F, 0x00, ##   0000000  
            0x41, 0x80, ##   0     00 
            0x41, 0x80, ##   0     00 
            0xC0, 0x80, ##  00      0 
            0xC0, 0x80, ##  00      0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x36, 0x00, ##    00 00  
            0x36, 0x00, ##    00 00  
            0x00, 0x00, ##           
            0x08, 0x00, ##      0    
            0x14, 0x00, ##     0 0   
            0x14, 0x00, ##     0 0   
            0x14, 0x00, ##     0 0   
            0x36, 0x00, ##    00 00  
            0x22, 0x00, ##    0   0  
            0x22, 0x00, ##    0   0  
            0x63, 0x00, ##   00   00 
            0x7F, 0x00, ##   0000000 
            0x41, 0x00, ##   0     0 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x0E, 0x00, ##      000    
            0x11, 0x00, ##     0   0   
            0x11, 0x00, ##     0   0   
            0x11, 0x00, ##     0   0   
            0x0E, 0x00, ##      000    
            0x0A, 0x00, ##      0 0    
            0x1B, 0x00, ##     00 00   
            0x1B, 0x00, ##     00 00   
            0x1B, 0x00, ##     00 00   
            0x11, 0x00, ##     0   0   
            0x31, 0x80, ##    00   00  
            0x31, 0x80, ##    00   00  
            0x3F, 0x80, ##    0000000  
            0x60, 0xC0, ##   00     00 
            0x60, 0xC0, ##   00     00 
            0x60, 0xC0, ##   00     00 
            0x40, 0x40, ##   0       0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000
            0x16, 0x00, ##     0 00   
            0x36, 0x00, ##    00 00   
            0x36, 0x00, ##    00 00   
            0x26, 0x00, ##    0  00   
            0x26, 0x00, ##    0  00   
            0x67, 0x80, ##   00  0000 
            0x66, 0x00, ##   00  00   
            0x7E, 0x00, ##   000000   
            0x46, 0x00, ##   0   00   
            0xC6, 0x00, ##  00   00   
            0xC6, 0x00, ##  00   00   
            0x87, 0xC0, ##  0    00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1F, ##     00000
            0x31, ##    00   0
            0x60, ##   00     
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x60, ##   00     
            0x31, ##    00   0
            0x1F, ##     00000
            0x08, ##      0   
            0x04, ##       0  
            0x04, ##       0  
            0x1C, ##     000  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x30, ##    00    
            0x10, ##     0    
            0x08, ##      0   
            0x00, ##          
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x0C, ##      00  
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x18, ##     00   
            0x3C, ##    0000  
            0x64, ##   00  0  
            0x00, ##          
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x6C, ##   00 00 
            0x6C, ##   00 00 
            0x00, ##         
            0xFE, ##  0000000
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xFE, ##  0000000
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x40, ##   0     
            0x20, ##    0    
            0x10, ##     0   
            0x00, ##         
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x08, ##      0  
            0x10, ##     0   
            0x20, ##    0    
            0x00, ##         
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x30, ##    00   
            0x78, ##   0000  
            0x44, ##   0   0 
            0x00, ##         
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x6C, ##   00 00 
            0x6C, ##   00 00 
            0x00, ##         
            0xFE, ##  0000000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7C, 0x00, ##   00000   
            0x63, 0x00, ##   00   00 
            0x63, 0x00, ##   00   00 
            0x61, 0x80, ##   00    00
            0x61, 0x80, ##   00    00
            0x61, 0x80, ##   00    00
            0xF9, 0x80, ##  00000  00
            0x61, 0x80, ##   00    00
            0x61, 0x80, ##   00    00
            0x61, 0x80, ##   00    00
            0x63, 0x00, ##   00   00 
            0x63, 0x00, ##   00   00 
            0x7C, 0x00, ##   00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x3C, ##    0000  
            0x00, ##          
            0x00, ##          
            0xE3, ##  000   00
            0xE3, ##  000   00
            0xE3, ##  000   00
            0xF3, ##  0000  00
            0xD3, ##  00 0  00
            0xD3, ##  00 0  00
            0xDB, ##  00 00 00
            0xCB, ##  00  0 00
            0xCB, ##  00  0 00
            0xCF, ##  00  0000
            0xC7, ##  00   000
            0xC7, ##  00   000
            0xC7, ##  00   000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x10, ##     0    
            0x10, ##     0    
            0x08, ##      0   
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x08, ##      0   
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x18, ##     00   
            0x3C, ##    0000  
            0x24, ##    0  0  
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x34, ##    00 0  
            0x2C, ##    0 00  
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x36, ##    00 00 
            0x36, ##    00 00 
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0x42, ##   0    0 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x42, ##   0    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##          
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x18, ##     00   
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0xC0, ##     0000 00
            0x33, 0x80, ##    00  000 
            0x21, 0x00, ##    0    0  
            0x63, 0x80, ##   00   000 
            0x65, 0x80, ##   00  0 00 
            0x65, 0x80, ##   00  0 00 
            0x69, 0x80, ##   00 0  00 
            0x69, 0x80, ##   00 0  00 
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0x61, 0x00, ##   00    0  
            0x63, 0x00, ##   00   00  
            0xDE, 0x00, ##  00 0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x10, ##     0    
            0x10, ##     0    
            0x08, ##      0   
            0x00, ##          
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x08, ##      0   
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x18, ##     00   
            0x3C, ##    0000  
            0x24, ##    0  0  
            0x00, ##          
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x66, ##   00  00 
            0x66, ##   00  00 
            0x00, ##          
            0x00, ##          
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x02, 0x00, ##        0   
            0x04, 0x00, ##       0    
            0x08, 0x00, ##      0     
            0x00, 0x00, ##            
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x12, 0x00, ##     0  0   
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xFC, ##  000000  
            0xC7, ##  00   000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0xFE, ##  0000000 
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000  
            0xC6, ##  00   00 
            0xC6, ##  00   00 
            0xCE, ##  00  000 
            0xD8, ##  00 00   
            0xD8, ##  00 00   
            0xD8, ##  00 00   
            0xDC, ##  00 000  
            0xCE, ##  00  000 
            0xC7, ##  00   000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xDE, ##  00 0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0     
            0x30, ##    00    
            0x18, ##     00   
            0x08, ##      0   
            0x00, ##          
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x06, ##       00 
            0x0C, ##      00  
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x08, ##      0   
            0x18, ##     00   
            0x34, ##    00 0  
            0x26, ##    0  00 
            0x00, ##          
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x72, ##   000  0 
            0x4E, ##   0  000 
            0x00, ##          
            0x00, ##          
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x26, ##    0  00 
            0x26, ##    0  00 
            0x00, ##          
            0x00, ##          
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x18, ##     00   
            0x24, ##    0  0  
            0x24, ##    0  0  
            0x24, ##    0  0  
            0x18, ##     00   
            0x00, ##          
            0x7C, ##   00000  
            0x46, ##   0   00 
            0x03, ##        00
            0x03, ##        00
            0x3F, ##    000000
            0xE3, ##  000   00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC7, ##  00   000
            0x7B, ##   0000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0x00, ##   0000000 
            0x0C, 0x80, ##      00  0
            0x0C, 0x80, ##      00  0
            0x0C, 0x80, ##      00  0
            0x7F, 0x80, ##   00000000
            0xCC, 0x00, ##  00  00   
            0xCC, 0x00, ##  00  00   
            0xCC, 0x00, ##  00  00   
            0xCC, 0x00, ##  00  00   
            0x77, 0x80, ##   000 0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000
            0x62, ##   00   0
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0x62, ##   00   0
            0x3E, ##    00000
            0x08, ##      0  
            0x04, ##       0 
            0x04, ##       0 
            0x1C, ##     000 
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0     
            0x10, ##     0    
            0x10, ##     0    
            0x08, ##      0   
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x63, ##   00   00
            0x3E, ##    00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x04, ##       0  
            0x0C, ##      00  
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x63, ##   00   00
            0x3E, ##    00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x08, ##      0   
            0x18, ##     00   
            0x24, ##    0  0  
            0x24, ##    0  0  
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x63, ##   00   00
            0x3E, ##    00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x36, ##    00 00 
            0x36, ##    00 00 
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xFF, ##  00000000
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x61, ##   00    0
            0x3F, ##    000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0      
            0x20, ##    0     
            0x30, ##    00    
            0x18, ##     00   
            0x00, ##          
            0x78, ##   0000   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x06, ##       00 
            0x0C, ##      00  
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0x78, ##   0000   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x18, ##     00   
            0x38, ##    000   
            0x2C, ##    0 00  
            0x64, ##   00  0  
            0x00, ##          
            0x78, ##   0000   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x6C, ##   00 00  
            0x6C, ##   00 00  
            0x00, ##          
            0x00, ##          
            0x78, ##   0000   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00    
            0x1C, ##     000  
            0x78, ##   0000   
            0x0C, ##      00  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x24, ##    0  0 
            0x54, ##   0 0 0 
            0x48, ##   0  0  
            0x00, ##         
            0xDC, ##  00 000 
            0xE6, ##  000  00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00     
            0x30, ##    00    
            0x10, ##     0    
            0x08, ##      0   
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x06, ##       00 
            0x0C, ##      00  
            0x08, ##      0   
            0x10, ##     0    
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0    
            0x18, ##     00   
            0x24, ##    0  0  
            0x24, ##    0  0  
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x72, ##   000  0 
            0x4E, ##   0  000 
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x66, ##   00  00 
            0x66, ##   00  00 
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##           
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##            
            0x1E, 0x80, ##     0000 0 
            0x31, 0x00, ##    00   0  
            0x61, 0x80, ##   00    00 
            0x63, 0x80, ##   00   000 
            0x65, 0x80, ##   00  0 00 
            0x69, 0x80, ##   00 0  00 
            0x69, 0x80, ##   00 0  00 
            0x71, 0x80, ##   000   00 
            0x73, 0x00, ##   000  00  
            0x5E, 0x00, ##   0 0000   
            0x00, 0x00, ##            
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00    
            0x20, ##    0    
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##         
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xCE, ##  00  000
            0x76, ##   000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x0C, ##      00 
            0x08, ##      0  
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##         
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xCE, ##  00  000
            0x76, ##   000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0   
            0x38, ##    000  
            0x28, ##    0 0  
            0x44, ##   0   0 
            0x00, ##         
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xCE, ##  00  000
            0x76, ##   000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x6C, ##   00 00 
            0x6C, ##   00 00 
            0x00, ##         
            0x00, ##         
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xCE, ##  00  000
            0x76, ##   000 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00  
            0x04, 0x00, ##       0   
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0xC1, 0x80, ##  00     00
            0x41, 0x80, ##   0     00
            0x61, 0x00, ##   00    0 
            0x23, 0x00, ##    0   00 
            0x22, 0x00, ##    0   0  
            0x32, 0x00, ##    00  0  
            0x16, 0x00, ##     0 00  
            0x14, 0x00, ##     0 0   
            0x1C, 0x00, ##     000   
            0x0C, 0x00, ##      00   
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x70, 0x00, ##   000     
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xDC, ##  00 000  
            0xE6, ##  000  00 
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE6, ##  000  00 
            0xDC, ##  00 000  
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x36, 0x00, ##    00 00  
            0x36, 0x00, ##    00 00  
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x41, 0x80, ##   0     00
            0x41, 0x00, ##   0     0 
            0x61, 0x00, ##   00    0 
            0x23, 0x00, ##    0   00 
            0x22, 0x00, ##    0   0  
            0x36, 0x00, ##    00 00  
            0x16, 0x00, ##     0 00  
            0x14, 0x00, ##     0 0   
            0x1C, 0x00, ##     000   
            0x0C, 0x00, ##      00   
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0x70, 0x00, ##   000     
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { },  # K
    '76' => { },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { },  # P
    '81' => { },  # Q
    '82' => { },  # R
    '83' => { },  # S
    '84' => { },  # T
    '85' => { },  # U
    '86' => { },  # V
    '87' => { },  # W
    '88' => { },  # X
    '89' => { },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { },  # v
    '119' => { },  # w
    '120' => { },  # x
    '121' => { },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { },  # À
    '193' => { },  # Á
    '194' => { },  # Â
    '195' => { },  # Ã
    '196' => { },  # Ä
    '197' => { },  # Å
    '198' => { },  # Æ
    '199' => { },  # Ç
    '200' => { },  # È
    '201' => { },  # É
    '202' => { },  # Ê
    '203' => { },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { },  # Ð
    '209' => { },  # Ñ
    '210' => { },  # Ò
    '211' => { },  # Ó
    '212' => { },  # Ô
    '213' => { },  # Õ
    '214' => { },  # Ö
    '215' => { },  # ×
    '216' => { },  # Ø
    '217' => { },  # Ù
    '218' => { },  # Ú
    '219' => { },  # Û
    '220' => { },  # Ü
    '221' => { },  # Ý
    '222' => { },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { },  # ò
    '243' => { },  # ó
    '244' => { },  # ô
    '245' => { },  # õ
    '246' => { },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { },  # ý
    '254' => { },  # þ
    '255' => { },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
