# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250913135854;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              485|
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463
          )\\d{3,10}|
          648[34]\\d{3,9}|
          (?:
            51|
            66|
            73
          )2\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-7]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463
          )\\d{3,10}|
          648[34]\\d{3,9}|
          (?:
            51|
            66|
            73
          )2\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-7]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            485|
            (?:
              5[0-3579]|
              6[013-9]|
              [7-9]\\d
            )\\d
          )\\d{3,9}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"4315", "Vienna",
"436274", "Lamprechtshausen",
"435244", "Jenbach",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"437238", "Mauthausen",
"433339", "Friedberg",
"437564", "Hinterstoder",
"432533", "Neusiedl\ an\ der\ Zaya",
"435355", "Jochberg",
"437248", "Grieskirchen",
"435234", "Axams",
"432147", "Zurndorf",
"435236", "Gries\ im\ Sellrain",
"432628", "Felixdorf",
"433467", "Schwanberg",
"433145", "Edelschrott",
"432862", "Heidenreichstein",
"435279", "St\.\ Jodok\ am\ Brenner",
"437566", "Rosenau\ am\ Hengstpass",
"437947", "Kefermarkt",
"436217", "Mattsee",
"436276", "Nussdorf\ am\ Haunsberg",
"437265", "Pabneukirchen",
"435246", "Achenkirch",
"432572", "Mistelbach",
"432982", "Horn",
"432527", "Wulzeshofen",
"437211", "Reichenau\ im\ Mühlkreis",
"436462", "Bischofshofen",
"434269", "Flattnitz",
"433135", "Kalsdorf\ bei\ Graz",
"434824", "Heiligenblut",
"432948", "Weitersfeld",
"433124", "Gratkorn",
"435524", "Satteins",
"437672", "Vöcklabruck",
"433534", "Stadl\ an\ der\ Mur",
"433356", "Markt\ Allhau",
"435375", "Kössen",
"432755", "Mank",
"432666", "Reichenau",
"436418", "Kleinarl",
"432713", "Spitz",
"432237", "Gaaden",
"437282", "Neufelden",
"435512", "Egg",
"435225", "Fulpmes",
"433112", "Gleisdorf",
"432664", "Semmering",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"433354", "Bernstein",
"432841", "Vitis",
"432247", "Deutsch\-Wagram",
"432552", "Poysdorf",
"433536", "St\.\ Peter\ am\ Kammersberg",
"434826", "Mörtschach",
"433126", "Frohnleiten",
"435526", "Laterns",
"433579", "Pöls",
"435357", "Kirchberg\ in\ Tirol",
"433533", "Turrach",
"434823", "Tresdorf\,\ Rangersdorf",
"432722", "Kirchberg\ an\ der\ Pielach",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"435523", "Götzis",
"432716", "Gföhl",
"432168", "Mannersdorf\ am\ Leithagebirge",
"433680", "Donnersbachwald",
"433353", "Oberschützen",
"433137", "Söding",
"432212", "Orth\ an\ der\ Donau",
"432525", "Gnadendorf",
"437758", "Obernberg\ am\ Inn",
"433572", "Judenburg",
"432714", "Rossatz",
"437267", "Mönchdorf",
"435550", "Thüringen",
"433150", "Paldau",
"432663", "Schottwien",
"433119", "St\.\ Marein\ bei\ Graz",
"435519", "Schröcken",
"433147", "Salla",
"436215", "Strasswalchen",
"437289", "Rohrbach\ in\ Oberösterreich",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"434847", "Obertilliach",
"435252", "Oetz",
"436132", "Bad\ Ischl",
"433465", "Pölfing\-Brunn",
"434285", "Tröpolach",
"434231", "Mittertrixen",
"437412", "Ybbs\ an\ der\ Donau",
"432145", "Prellenkirchen",
"433862", "Bruck\ an\ der\ Mur",
"433332", "Hartberg",
"432757", "Pöchlarn",
"432268", "Grossmugl",
"435243", "Maurach",
"437563", "Spital\ am\ Pyhrn",
"432534", "Niedersulz",
"434766", "Millstatt",
"437435", "St\.\ Valentin",
"433170", "Fischbach",
"432536", "Drösing",
"434262", "Treibach",
"436232", "Mondsee",
"432989", "Brunn\ an\ der\ Wild",
"432245", "Wolkersdorf\ im\ Weinviertel",
"433885", "Greith",
"437445", "Hollenstein\ an\ der\ Ybbs",
"436242", "Russbach\ am\ Pass\ Gschütt",
"435272", "Steinach\ am\ Brenner",
"432235", "Maria\-Lanzendorf",
"432814", "Langschlag",
"432645", "Wiesmath",
"434213", "Launsdorf",
"433619", "Oppenberg",
"432944", "Haugsdorf",
"43316", "Graz",
"435672", "Reutte",
"432163", "Petronell\-Carnuntum",
"432635", "Neunkirchen",
"436414", "Grossarl",
"433637", "Gams\ bei\ Hieflau",
"433358", "Litzelsdorf",
"432822", "Zwettl\,\ Lower\ Austria",
"437471", "Neustadtl\ an\ der\ Donau",
"432877", "Grainbrunn",
"433383", "Burgau",
"437753", "Eberschwang",
"433472", "Mureck",
"436416", "Lend",
"434255", "Arnoldstein",
"432946", "Pulkau",
"436477", "St\.\ Michael\ im\ Lungau",
"434229", "Krumpendorf\ am\ Wörther\ See",
"433623", "Bad\ Mitterndorf",
"435447", "Flirsch",
"437259", "Sierning",
"432271", "Ried\ am\ Riederberg",
"437225", "Hargelsberg",
"435633", "Hägerau",
"432816", "Karlstift",
"435282", "Zell\ am\ Ziller",
"437355", "Weyer",
"437667", "St\.\ Georgen\ im\ Attergau",
"436278", "Ostermiething",
"435248", "Steinberg\ am\ Rofan",
"432263", "Grossrussbach",
"437234", "Ottensheim",
"434359", "Reichenfels",
"437732", "Haag\ am\ Hausruck",
"432612", "Oberpullendorf",
"432626", "Mattersburg",
"437244", "Sattledt",
"435238", "Zirl",
"432769", "Türnitz",
"437742", "Mattighofen",
"433452", "Leibnitz",
"432959", "Sitzendorf\ an\ der\ Schmida",
"433855", "Krieglach",
"432857", "Bad\ Grosspertholz",
"433582", "Scheifling",
"435265", "Nassereith",
"432624", "Ebenfurth",
"437246", "Gunskirchen",
"437279", "Haibach\ ob\ der\ Donau",
"436457", "Flachau",
"437236", "Pregarten",
"434275", "Ebene\ Reichenau",
"432762", "Lilienfeld",
"4314", "Vienna",
"433635", "Radmer",
"432637", "Grünbach\ am\ Schneeberg",
"437682", "Vöcklamarkt",
"437717", "St\.\ Aegidi",
"432264", "Rückersdorf\,\ Harmannsdorf",
"437233", "Feldkirchen\ an\ der\ Donau",
"435331", "Brandenberg",
"432538", "Velm\-Götzendorf",
"434735", "Kremsbrücke",
"432647", "Krumbach\,\ Lower\ Austria",
"432619", "Lackendorf",
"437243", "Marchtrenk",
"434352", "Wolfsberg",
"437272", "Eferding",
"437227", "Neuhofen\ an\ der\ Krems",
"434230", "Globasnitz",
"432623", "Pottendorf",
"436475", "Ramingstein",
"435445", "Kappl",
"434257", "Fürnitz",
"434768", "Kleblach\-Lind",
"432952", "Hollabrunn",
"434240", "Bad\ Kleinkirchheim",
"436221", "Koppl",
"433151", "Gnas",
"432266", "Stockerau",
"436562", "Mittersill",
"432875", "Grafenschlag",
"432741", "Flinsbach",
"4319", "Vienna",
"434214", "Brückl",
"432943", "Obritz",
"432813", "Arbesbach",
"434712", "Greifenburg",
"432731", "Idolsberg",
"433386", "Grosssteinbach",
"433612", "Liezen",
"437357", "Kleinreifling",
"432164", "Rohrau",
"437665", "Unterach\ am\ Attersee",
"436413", "Wagrain",
"437754", "Waldzell",
"435412", "Imst",
"432718", "Lichtenau\ im\ Waldviertel",
"434277", "Glanegg",
"432166", "Parndorf",
"436455", "Untertauern",
"435289", "Häusling",
"437252", "Steyr",
"432829", "Schweiggers",
"435634", "Elbigenalp",
"432855", "Waldenstein",
"436541", "Saalbach",
"437480", "Langau\,\ Gaming",
"433171", "Gasen",
"433857", "Neuberg\ an\ der\ Mürz",
"433624", "Pichl\-Kainisch",
"432732", "Krems\ an\ der\ Donau",
"437444", "Opponitz",
"432878", "Traunstein",
"433133", "Nestelbach",
"437612", "Gmunden",
"433357", "Pinkafeld",
"432667", "Schwarzau\ im\ Gebirge",
"437263", "Bad\ Zell",
"432234", "Gramatneusiedl",
"433611", "Johnsbach",
"434843", "Ausservillgraten",
"436478", "Zederhaus",
"437434", "Haag",
"432689", "Hornstein",
"432742", "St\.\ Pölten",
"435448", "Pettneu\ am\ Arlberg",
"433143", "Krottendorf",
"433884", "Wegscheid",
"432244", "Langenzersdorf",
"433537", "St\.\ Georgen\ ob\ Murau",
"437479", "Ardagger",
"435353", "Waidring",
"433886", "Weichselboden",
"432246", "Gerasdorf\ bei\ Wien",
"433172", "Weiz",
"435572", "Dornbirn",
"433127", "Peggau",
"436542", "Zell\ am\ See",
"434872", "Huben",
"432535", "Hohenau\ an\ der\ March",
"432773", "Eichgraben",
"434221", "Gallizien",
"436240", "Krispl",
"432236", "Mödling",
"437251", "Schiedlberg",
"433638", "Palfau",
"432279", "Kirchberg\ am\ Wagram",
"436214", "Henndorf\ am\ Wallersee",
"437944", "Sandl",
"435332", "Wörgl",
"434782", "Obervellach",
"433464", "Gross\ St\.\ Florian",
"433322", "Güssing",
"434284", "Kirchbach",
"432858", "Moorbad\ Harbach",
"432144", "Deutsch\ Jahrndorf",
"436588", "Lofer",
"436483", "Göriach",
"432524", "Kautendorf",
"433682", "Stainach",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"436458", "Hüttau",
"435223", "Hall\ in\ Tirol",
"432753", "Gansbach",
"436277", "St\.\ Pantaleon",
"434852", "Lienz",
"432951", "Guntersdorf",
"433152", "Feldbach",
"435552", "Bludenz",
"435373", "Ebbs",
"432526", "Stronsdorf",
"432259", "Münchendorf",
"433466", "Eibiswald",
"434286", "Weissbriach",
"432146", "Nickelsdorf",
"437946", "Gutau",
"436216", "Neumarkt\ am\ Wallersee",
"433463", "Stainz",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"434283", "St\.\ Stefan\ im\ Gailtal",
"437228", "Kematen\ an\ der\ Krems",
"432143", "Kittsee",
"434258", "Gummern",
"436213", "Oberhofen\ am\ Irrsee",
"437943", "Windhaag\ bei\ Freistadt",
"434767", "Rothenthurn",
"432756", "St\.\ Leonhard\ am\ Forst",
"435339", "Wildschönau",
"435224", "Wattens",
"432665", "Prein\ an\ der\ Rax",
"43512", "Innsbruck",
"433355", "Stadtschlaining",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"436484", "Lessach",
"435376", "Thiersee",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"433329", "Jennersdorf",
"435374", "Walchsee",
"432252", "Baden",
"432754", "Loosdorf",
"437718", "Waldkirchen\ am\ Wesen",
"435510", "Damüls",
"432638", "Winzendorf\-Muthmannsdorf",
"435226", "Neustift\ im\ Stubaital",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"433159", "Bad\ Gleichenberg",
"435559", "Brand",
"434825", "Grosskirchheim",
"435525", "Nenzing",
"435212", "Seefeld\ in\ Tirol",
"433125", "Übelbach",
"436229", "Hof\ bei\ Salzburg",
"437582", "Kirchdorf\ an\ der\ Krems",
"432172", "Frauenkirchen",
"432648", "Hochneukirchen",
"433535", "Krakaudorf",
"433581", "Oberwölz",
"432682", "Eisenstadt",
"432717", "Unter\-Meisling",
"432749", "Prinzersdorf",
"437264", "Windhaag\ bei\ Perg",
"434278", "Gnesau",
"432233", "Pressbaum",
"437762", "Raab",
"437443", "Ybbsitz",
"433134", "Heiligenkreuz\ am\ Waasen",
"437619", "Kirchham",
"435356", "Kitzbühel",
"432243", "Klosterneuburg",
"433883", "Terz",
"4312", "Vienna",
"432739", "Tiefenfucha",
"437433", "Wallsee",
"433144", "Köflach",
"433858", "Mitterdorf\ im\ Mürztal",
"434846", "Abfaltersbach",
"437565", "St\.\ Pankraz",
"433146", "Modriach",
"433512", "Knittelfeld",
"432774", "Innermanzing",
"432272", "Tulln\ an\ der\ Donau",
"435354", "Fieberbrunn",
"437472", "Amstetten",
"433136", "Dobl",
"437952", "Weitersfelden",
"434879", "St\.\ Veit\ in\ Defereggen",
"436549", "Piesendorf",
"435579", "Alberschwende",
"435245", "Hinterriss",
"433179", "Passail",
"437266", "Bad\ Kreuzen",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"432627", "Pitten",
"432672", "Berndorf",
"437223", "Enns",
"435635", "Elmen",
"434710", "Oberdrauburg",
"432854", "Kirchberg\ am\ Walde",
"434253", "St\.\ Jakob\ im\ Rosental",
"437948", "Hirschbach\ im\ Mühlkreis",
"433385", "Ilz",
"437755", "Mettmach",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"437729", "Neukirchen\ an\ der\ Enknach",
"436454", "Mandling",
"437666", "Attersee",
"432786", "Oberwölbling",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432784", "Perschling",
"437250", "Maria\ Neustift",
"437713", "Schardenberg",
"434220", "Köttmannsdorf",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"436241", "St\.\ Koloman",
"433842", "Leoben",
"432282", "Gänserndorf",
"432165", "Hainburg\ a\.d\.\ Donau",
"432633", "Markt\ Piesting",
"436456", "Obertauern",
"437664", "Weyregg\ am\ Attersee",
"437482", "Scheibbs",
"434215", "Liebenfels",
"437219", "Vorderweissenbach",
"437247", "Kematen\ am\ Innbach",
"432856", "Weitra",
"432643", "Lichtenegg",
"433832", "Kraubath\ an\ der\ Mur",
"4316", "Vienna",
"433362", "Grosspetersdorf",
"432238", "Kaltenleutgeben",
"434273", "Reifnitz",
"437448", "Kematen\ an\ der\ Ybbs",
"432874", "Martinsberg",
"433636", "Wildalpen",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432248", "Markgrafneusiedl",
"435263", "Silz",
"436474", "Tamsweg",
"435444", "Ischgl",
"433853", "Spital\ am\ Semmering",
"434736", "Innerkrems",
"436476", "St\.\ Margarethen\ im\ Lungau",
"435446", "St\.\ Anton\ am\ Arlberg",
"432947", "Theras",
"434734", "Rennweg",
"432849", "Schwarzenau",
"434232", "Völkermarkt",
"436131", "Obertraun",
"433861", "Aflenz",
"432876", "Els",
"433634", "Hieflau",
"437353", "Gaflenz",
"433571", "Möderbrugg",
"436417", "Hüttschlag",
"434242", "Villach",
"432265", "Hausleiten",
"432873", "Kottes",
"432610", "Horitschon",
"437757", "Gurten",
"433387", "Söchau",
"437268", "Grein",
"434274", "Velden\ am\ Wörther\ See",
"434848", "Kartitsch",
"436473", "Mariapfarr",
"435443", "Galtür",
"433148", "Kainach\ bei\ Voitsberg",
"433854", "Langenwang",
"435264", "Mieming",
"432625", "Bad\ Sauerbrunn",
"435358", "Ellmau",
"437245", "Lambach",
"435266", "Ötztal\-Bahnhof",
"435472", "Prutz",
"433856", "Veitsch",
"434733", "Malta",
"432167", "Neusiedl\ am\ See",
"432912", "Geras",
"434276", "Feldkirchen\ in\ Kärnten",
"437281", "Aigen\ im\ Mühlkreis",
"437235", "Gallneukirchen",
"433633", "Landl",
"436432", "Bad\ Hofgastein",
"432842", "Waidhofen\ an\ der\ Thaya",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"434254", "Faak\ am\ See",
"437722", "Braunau\ am\ Inn",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"437224", "St\.\ Florian",
"432853", "Schrems",
"436583", "Leogang",
"437716", "Münzkirchen",
"436453", "Filzmoos",
"432636", "Puchberg\ am\ Schneeberg",
"432758", "Pöggstall",
"437714", "Esternberg",
"432267", "Sierndorf",
"437489", "Purgstall\ an\ der\ Erlauf",
"432634", "Gutenstein",
"437663", "Steinbach\ am\ Attersee",
"436415", "Schwarzach\ im\ Pongau",
"432783", "Traismauer",
"436461", "Dienten\ am\ Hochkönig",
"433182", "Wildon",
"435582", "Klösterle",
"437212", "Zwettl\ an\ der\ Rodl",
"432815", "Grossschönau",
"432644", "Grimmenstein",
"437226", "Wilhering",
"435280", "Hochfügen",
"434256", "Nötsch\ im\ Gailtal",
"432945", "Zellerndorf",
"432289", "Matzen",
"433849", "Vordernberg",
"436548", "Niedernsill",
"435578", "Höchst",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"435473", "Nauders",
"434732", "Gmünd\ in\ Kärnten",
"434234", "Ruden",
"434355", "Gemmersdorf",
"432765", "Kaumberg",
"436433", "Dorfgastein",
"432843", "Dobersberg",
"433632", "St\.\ Gallen",
"4318", "Vienna",
"434244", "Bad\ Bleiberg",
"432711", "Dürnstein",
"433366", "Kohfidisch",
"432913", "Hötzelsdorf",
"435677", "Vils",
"433477", "St\.\ Peter\ am\ Ottersbach",
"433364", "Hannersdorf",
"434246", "Radenthein",
"432955", "Grossweikersdorf",
"433859", "Mürzsteg",
"432827", "Schönbach",
"432872", "Ottenschlag",
"432738", "Fels\ am\ Wagram",
"436565", "Neukirchen\ am\ Grossvenediger",
"437618", "Neukirchen\,\ Altmünster",
"435287", "Tux",
"434236", "Eberndorf",
"435442", "Landeck",
"432748", "Kilb",
"436472", "Mauterndorf",
"434279", "Sirnitz",
"432649", "Mönichkirchen",
"432782", "Herzogenburg",
"432617", "Drassmarkt",
"437213", "Bad\ Leonfelden",
"435583", "Lech",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"434858", "Nikolsdorf",
"437750", "Andrichsfurt",
"436228", "Faistenau",
"433158", "St\.\ Anna\ am\ Aigen",
"437662", "Seewalchen\ am\ Attersee",
"435558", "Gaschurn",
"433844", "Kammern\ im\ Liesingtal",
"432284", "Oberweiden",
"433615", "Trieben",
"432639", "Bad\ Fischau",
"437484", "Göstling\ an\ der\ Ybbs",
"437719", "Taufkirchen\ an\ der\ Pram",
"437747", "Kirchberg\ bei\ Mattighofen",
"434761", "Stockenboi",
"433834", "Wald\ am\ Schoberpass",
"434715", "Kötschach\-Mauthen",
"433587", "Schönberg\-Lachtal",
"433328", "Kukmirn",
"432674", "Weissenbach\ an\ der\ Triesting",
"432852", "Gmünd",
"435338", "Kundl",
"437723", "Altheim",
"437486", "Lunz\ am\ See",
"433457", "Gleinstätten",
"434225", "Grafenstein",
"432160", "Jois",
"436452", "Radstadt",
"433846", "Kalwang",
"432286", "Obersiebenbrunn",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"437229", "Traun",
"437255", "Losenstein",
"433688", "Tauplitz",
"435675", "Tannheim",
"437712", "Schärding",
"432632", "Pernitz",
"432283", "Angern\ an\ der\ March",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"432258", "Alland",
"437214", "Reichenthal",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432767", "Hohenberg",
"434357", "St\.\ Paul\ im\ Lavanttal",
"433833", "Traboch",
"432642", "Aspangberg\-St\.\ Peter",
"437483", "Oberndorf\ an\ der\ Melk",
"437588", "Ried\ im\ Traunkreis",
"437724", "Mauerkirchen",
"434252", "Wernberg",
"432673", "Altenmarkt\ an\ der\ Triesting",
"435285", "Mayrhofen",
"436589", "Unken",
"437277", "Waizenkirchen",
"432859", "Brand\-Nagelberg",
"437216", "Helfenberg",
"43662", "Salzburg",
"432825", "Göpfritz\ an\ der\ Wild",
"433475", "Hürth",
"432957", "Hohenwarth",
"434717", "Steinfeld",
"434233", "Griffen",
"432278", "Absdorf",
"432620", "Willendorf",
"437745", "Lochen",
"435474", "Pfunds",
"434243", "Bodensdorf",
"433617", "Gaishorn\ am\ See",
"432914", "Japons",
"437735", "Gaspoltshofen",
"432615", "Lutzmannsburg",
"436434", "Bad\ Gastein",
"432844", "Karlstein\ an\ der\ Thaya",
"437478", "Oed\-Oehling",
"437257", "Grünburg",
"432846", "Raabs\ an\ der\ Thaya",
"433363", "Rechnitz",
"432916", "Riegersburg\,\ Hardegg",
"434272", "Pörtschach\ am\ Wörther\ See",
"436479", "Muhr",
"434227", "Ferlach",
"435449", "Fliess",
"437230", "Altenberg\ bei\ Linz",
"432688", "Steinbrunn",
"435417", "Roppen",
"433455", "Arnfels",
"433852", "Mürzzuschlag",
"435476", "Serfaus",
"437240", "Sipbachzell",
"435262", "Telfs",
"433585", "St\.\ Lambrecht",
"436224", "Hintersee",
"435554", "Sonntag",
"432288", "Auersthal",
"433848", "Eisenerz",
"432253", "Oberwaltersdorf",
"433686", "Haus",
"432173", "Gols",
"433326", "Stegersbach",
"432725", "Frankenfels",
"435336", "Alpbach",
"437488", "Steinakirchen\ am\ Forst",
"437583", "Kremsmünster",
"435213", "Scharnitz",
"435334", "Westendorf",
"437942", "Freistadt",
"436212", "Seekirchen\ am\ Wallersee",
"435255", "Umhausen",
"434784", "Mallnitz",
"437415", "Altenmarkt\,\ Yspertal",
"434282", "Hermagor",
"433324", "Strem",
"436135", "Bad\ Goisern",
"433462", "Deutschlandsberg",
"433865", "Kindberg",
"432142", "Gattendorf",
"436467", "Mühlbach\ am\ Hochkönig",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"433684", "St\.\ Martin\ am\ Grimming",
"432577", "Asparn\ an\ der\ Zaya",
"432522", "Laa\ an\ der\ Thaya",
"432215", "Probstdorf",
"433575", "St\.\ Johann\ am\ Tauern",
"436226", "Fuschl\ am\ See",
"435556", "Schruns",
"434238", "Eisenkappel\-Vellach",
"432273", "Tulbing",
"436544", "Rauris",
"432746", "Wilhelmsburg",
"435574", "Bregenz",
"433174", "Birkfeld",
"433513", "Bischoffeld",
"434874", "Virgen",
"437751", "St\.\ Martin\ im\ Innkreis",
"434248", "Treffen",
"433335", "Pöllau",
"437953", "Liebenau",
"432736", "Paudorf",
"437616", "Grünau\ im\ Almtal",
"437473", "Blindenmarkt",
"435359", "Hochfilzen",
"437763", "Kopfing\ im\ Innkreis",
"437442", "Waidhofen\ an\ der\ Ybbs",
"432734", "Langenlois",
"437614", "Vorchdorf",
"435517", "Riezlern",
"433117", "Eggersdorf\ bei\ Graz",
"435275", "Trins",
"433149", "Geistthal",
"436245", "Hallein",
"437287", "Peilstein\ im\ Mühlviertel",
"432232", "Fischamend",
"432683", "Purbach\ am\ Neusiedler\ See",
"432744", "Kasten\ bei\ Böheimkirchen",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"437432", "Strengberg",
"435576", "Hohenems",
"433176", "Stubenberg",
"437269", "Baumgartenberg",
"434876", "Kals\ am\ Grossglockner",
"436235", "Thalgau",
"434265", "Weitensfeld\ im\ Gurktal",
"432557", "Bernhardsthal",
"432242", "St\.\ Andrä\-Wördern",
"433882", "Mariazell",
"436543", "Taxenbach",
"435573", "Hörbranz",
"433173", "Ratten",
"433514", "Seckau",
"432772", "Neulengbach",
"434873", "St\.\ Jakob\ in\ Defereggen",
"435352", "St\.\ Johann\ in\ Tirol",
"432274", "Sieghartskirchen",
"437766", "Andorf",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"437474", "Euratsfeld",
"437954", "St\.\ Georgen\ am\ Walde",
"432686", "Drassburg",
"437956", "Unterweissenbach",
"437262", "Perg",
"432684", "Schützen\ am\ Gebirge",
"433577", "Zeltweg",
"432985", "Gars\ am\ Kamp",
"432249", "Gross\-Enzersdorf",
"432575", "Ladendorf",
"437764", "Riedau",
"432733", "Schönberg\ am\ Kamp",
"433132", "Kumberg",
"437613", "Laakirchen",
"437476", "Aschbach\-Markt",
"433867", "Pernegg\ an\ der\ Mur",
"432276", "Reidling",
"435230", "Sellrain",
"436137", "Strobl",
"432743", "Böheimkirchen",
"434842", "Sillian",
"4317", "Vienna",
"432239", "Breitenfurt\ bei\ Wien",
"433516", "Kleinlobming",
"432865", "Litschau",
"433142", "Voitsberg",
"432254", "Ebreichsdorf",
"437218", "Grosstraberg",
"435372", "Kufstein",
"434853", "Ainet",
"436223", "Anthering",
"432752", "Melk",
"435553", "Raggal",
"433153", "Riegersburg",
"433337", "Vorau",
"437584", "Molln",
"435214", "Leutasch",
"432174", "Wallern\ im\ Burgenland",
"437675", "Ampflwang\ im\ Hausruckwald",
"432621", "Sieggraben",
"432176", "Tadten",
"433323", "Eberau",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432555", "Herrnbaumgarten",
"434267", "Metnitz",
"435333", "Söll",
"437728", "Schwand\ im\ Innkreis",
"437586", "Pettenbach",
"434783", "Reisseck",
"435515", "Au",
"433115", "Studenzen",
"436247", "Grossgmain",
"437949", "Rainbach\ im\ Mühlkreis",
"437285", "Hofkirchen\ im\ Mühlkreis",
"437231", "Herzogsdorf",
"436219", "Obertrum\ am\ See",
"433683", "Donnersbach",
"432256", "Leobersdorf",
"433469", "St\.\ Oswald\ im\ Freiland",
"437746", "Friedburg",
"433454", "Leutschach",
"437273", "Aschach\ an\ der\ Donau",
"432622", "Wiener\ Neustadt",
"433584", "Neumarkt\ in\ Steiermark",
"432988", "Neupölla",
"437736", "Pram",
"436563", "Uttendorf",
"436468", "Werfen",
"432616", "Lockenhaus",
"432953", "Nappersdorf",
"432915", "Drosendorf\-Zissersdorf",
"433847", "Trofaiach",
"432287", "Strasshof\ an\ der\ Nordbahn",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"437683", "Frankenburg\ am\ Hausruck",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"432614", "Kleinwarasdorf",
"432845", "Weikertschlag\ an\ der\ Thaya",
"434353", "Prebl",
"433586", "Mühlen",
"437242", "Wels",
"437744", "Munderfing",
"433456", "Fresing",
"432269", "Niederfellabrunn",
"435475", "Feichten",
"437487", "Gresten",
"437253", "Wolfern",
"432824", "Allentsteig",
"434223", "Maria\ Saal",
"435676", "Jungholz",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"435518", "Mellau",
"433118", "Sinabelkirchen",
"433474", "Deutsch\ Goritz",
"437288", "Ulrichsberg",
"432630", "Ternitz",
"437759", "Antiesenhofen",
"435284", "Gerlos",
"434713", "Techendorf",
"435286", "Ginzling",
"434237", "Miklauzhof",
"432812", "Gross\ Gerungs",
"432942", "Retz",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"433141", "Hirschegg",
"435674", "Bichlbach",
"433476", "Bad\ Radkersburg",
"436412", "St\.\ Johann\ im\ Pongau",
"434247", "Afritz",
"437261", "Schönau\ im\ Mühlkreis",
"433613", "Admont",
"432826", "Rastenfeld",
"437215", "Hellmonsödt",
"435585", "Dalaas",
"433185", "Preding",
"434224", "Pischeldorf",
"433578", "Obdach",
"435414", "Wenns",
"433382", "Fürstenfeld",
"437752", "Ried\ im\ Innkreis",
"433473", "Straden",
"433616", "Selzthal",
"437254", "Grossraming",
"432823", "Grossglobnitz",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"435283", "Kaltenbach",
"433868", "Tragöss",
"434716", "Lesachtal",
"435632", "Stanzach",
"433622", "Bad\ Aussee",
"432728", "Wienerbruck",
"435477", "Tösens",
"434212", "St\.\ Veit\ an\ der\ Glan",
"437485", "Gaming",
"434714", "Dellach\ im\ Drautal",
"43732", "Linz",
"432847", "Gross\-Siegharts",
"437256", "Ternberg",
"435673", "Ehrwald",
"434226", "St\.\ Margareten\ im\ Rosental",
"433845", "Mautern\ in\ Steiermark",
"432162", "Bruck\ an\ der\ Leitha",
"432285", "Marchegg",
"432949", "Niederfladnitz",
"433614", "Rottenmann",
"432231", "Purkersdorf",
"434268", "Friesach",
"437274", "Alkoven",
"434356", "Lavamünd",
"433583", "Unzmarkt",
"433453", "Ehrenhausen",
"437727", "Ach",
"433365", "Deutsch\ Schützen\-Eisenberg",
"435278", "Navis",
"432954", "Göllersdorf",
"432629", "Warth\,\ Lower\ Austria",
"432766", "Kleinzell",
"436564", "Krimml",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"437249", "Bad\ Schallerbach",
"432764", "Hainfeld",
"436566", "Bramberg\ am\ Wildkogel",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432613", "Deutschkreutz",
"434245", "Feistritz\ an\ der\ Drau",
"433338", "Lafnitz",
"432956", "Ziersdorf",
"432262", "Korneuburg",
"437684", "Frankenmarkt",
"437743", "Maria\ Schmolln",
"436470", "Atzmannsdorf",
"437239", "Lichtenberg",
"437941", "Neumarkt\ im\ Mühlkreis",
"433461", "Trahütten",
"437276", "Peuerbach",
"434235", "Bleiburg",
"434354", "Preitenegg",
"433573", "Fohnsdorf",
"432662", "Gloggnitz",
"435514", "Bezau",
"433114", "Markt\ Hartmannsdorf",
"437284", "Oberkappel",
"433352", "Oberwart",
"437617", "Traunkirchen",
"432828", "Rappottenstein",
"432213", "Lassee",
"437413", "Marbach\ an\ der\ Donau",
"436133", "Ebensee",
"437676", "Ottnang\ am\ Hausruck",
"435288", "Fügen",
"433863", "Turnau",
"432554", "Stützenhofen",
"432719", "Dross",
"432747", "Ober\-Grafendorf",
"435253", "Längenfeld",
"432723", "Rabenstein\ an\ der\ Pielach",
"434822", "Winklern",
"434877", "Prägraten\ am\ Grossvenediger",
"436547", "Kaprun",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"435577", "Lustenau",
"433177", "Puch\ bei\ Weiz",
"435522", "Feldkirch",
"432175", "Apetlon",
"437674", "Attnang\-Puchheim",
"433532", "Murau",
"432556", "Grosskrut",
"432255", "Deutsch\ Brodersdorf",
"435678", "Weissenbach\ am\ Lech",
"433116", "Kirchbach\ in\ Steiermark",
"435516", "Doren",
"437286", "Lembach\ im\ Mühlkreis",
"434271", "Steuerberg",
"436233", "Oberwang",
"434263", "Hüttenberg",
"432641", "Kirchberg\ am\ Wechsel",
"433588", "Katsch\ an\ der\ Mur",
"433327", "St\.\ Michael\ im\ Burgenland",
"435337", "Brixlegg",
"432864", "Kautzen",
"437711", "Suben",
"435273", "Matrei\ am\ Brenner",
"434769", "Möllbrücke",
"436243", "Abtenau",
"432631", "Pöttsching",
"432685", "Rust",
"433687", "Schladming",
"432984", "Eggenburg",
"432574", "Gaweinstal",
"437765", "Lambrechten",
"432986", "Irnfritz",
"432576", "Ernstbrunn",
"432618", "Markt\ St\.\ Martin",
"436466", "Werfenweng",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433333", "Sebersdorf",
"435557", "St\.\ Gallenkirch",
"433157", "Kapfenstein",
"437955", "Königswiesen",
"435242", "Schwaz",
"436227", "St\.\ Gilgen",
"436272", "Oberndorf\ bei\ Salzburg",
"437260", "Waldhausen",
"437748", "Eggelsberg",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"437562", "Windischgarsten",
"432275", "Atzenbrugg",
"437221", "Hörsching",
"435232", "Kematen\ in\ Tirol",
"432745", "Pyhra",
"434762", "Spittal\ an\ der\ Drau",
"432863", "Eggern",
"436234", "Zell\ am\ Moos",
"434264", "Klein\ St\.\ Paul",
"437278", "Neukirchen\ am\ Walde",
"432983", "Sigmundsherberg",
"432573", "Wilfersdorf",
"432735", "Hadersdorf\ am\ Kamp",
"436463", "Annaberg\-Lungötz",
"437615", "Scharnstein",
"433336", "Waldbach",
"435274", "Gries\ am\ Brenner",
"436244", "Golling\ an\ der\ Salzach",
"432958", "Maissau",
"435276", "Gschnitz",
"433334", "Kaindorf",
"436246", "Grödig",
"432230", "Schwadorf",
"435239", "Kühtai",
"432257", "Klausen\-Leopoldsdorf",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"434266", "Strassburg",
"432177", "Podersdorf\ am\ See",
"434358", "St\.\ Andrä",
"437587", "Wartberg\ an\ der\ Krems",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"433175", "Anger",
"435575", "Langen\ bei\ Bregenz",
"434875", "Matrei\ in\ Osttirol",
"432532", "Zistersdorf",
"433685", "Gröbming",
"437258", "Bad\ Hall",
"432214", "Kopfstetten",
"433631", "Unterlaussa",
"437767", "Eggerding",
"434228", "Feistritz\ im\ Rosental",
"435418", "Schönwies",
"433574", "Pusterwald",
"432712", "Aggsbach",
"432687", "Siegendorf",
"435513", "Hittisau",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"437283", "Sarleinsbach",
"435335", "Hopfgarten\ im\ Brixental",
"432726", "Puchenstuben",
"434785", "Ausserfragant",
"435254", "Sölden",
"437414", "Weins\-Isperdorf",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"436134", "Hallstatt",
"433864", "St\.\ Marein\ im\ Mürztal",
"433359", "Loipersdorf\-Kitzladen",
"433460", "Soboth",
"437416", "Wieselburg",
"436136", "Gosau",
"437673", "Schwanenstadt",
"433866", "Breitenau\ am\ Hochlantsch",
"434718", "Dellach",
"432277", "Zwentendorf",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"436471", "Tweng",
"435441", "See",
"4313", "Vienna",
"435256", "Untergurgl",
"434855", "Assling",
"436225", "Eugendorf",
"433576", "Bretstein",
"433155", "Fehring",
"433618", "Hohentauern",
"437477", "St\.\ Peter\ in\ der\ Au",
"4346", "Klagenfurt",
"432216", "Leopoldsdorf\ im\ Marchfelde",};
$areanames{de} = {"437751", "Sankt\ Martin\ im\ Innkreis",
"434876", "Kals\ am\ Großglockner",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"432242", "Sankt\ Andrä\-Wördern",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"433684", "Sankt\ Martin\ am\ Grimming",
"433575", "Sankt\ Johann\ am\ Tauern",
"437218", "Großtraberg",
"434783", "Reißeck",
"436247", "Großgmain",
"433469", "Sankt\ Oswald\ im\ Freiland",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"435352", "Sankt\ Johann\ in\ Tirol",
"432686", "Draßburg",
"437954", "Sankt\ Georgen\ am\ Walde",
"437956", "Unterweißenbach",
"432249", "Groß\-Enzersdorf",
"4317", "Wien",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"432617", "Draßmarkt",
"433158", "Sankt\ Anna\ am\ Aigen",
"433834", "Wald\ am\ Schoberpaß",
"432674", "Weißenbach\ an\ der\ Triesting",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"433632", "Sankt\ Gallen",
"4318", "Wien",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"432955", "Großweikersdorf",
"436565", "Neukirchen\ am\ Großvenediger",
"435449", "Fließ",
"433585", "Sankt\ Lambrecht",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432642", "Aspangberg\-Sankt\ Peter",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432618", "Markt\ Sankt\ Martin",
"436227", "Sankt\ Gilgen",
"435557", "Sankt\ Gallenkirch",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"432719", "Droß",
"434877", "Prägraten\ am\ Großvenediger",
"432556", "Großkrut",
"435678", "Weißenbach\ am\ Lech",
"434785", "Außerfragant",
"433864", "Sankt\ Marein\ im\ Mürztal",
"4313", "Wien",
"437477", "Sankt\ Peter\ in\ der\ Au",
"434264", "Klein\ Sankt\ Paul",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434358", "Sankt\ Andrä",
"434266", "Straßburg",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"432812", "Groß\ Gerungs",
"436412", "Sankt\ Johann\ im\ Pongau",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"432629", "Warth\,\ Niederösterreich",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"437254", "Großraming",
"432823", "Großglobnitz",
"433868", "Tragöß",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"432847", "Groß\-Siegharts",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432263", "Großrußbach",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432857", "Bad\ Großpertholz",
"436414", "Großarl",
"432822", "Zwettl\-Niederösterreich",
"436477", "Sankt\ Michael\ im\ Lungau",
"4319", "Wien",
"433386", "Großsteinbach",
"4314", "Wien",
"437717", "Sankt\ Aegidi",
"432647", "Krumbach\,\ Niederösterreich",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"4315", "Wien",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"435279", "Sankt\ Jodok\ am\ Brenner",
"437566", "Rosenau\ am\ Hengstpaß",
"436276", "Nußdorf\ am\ Haunsberg",
"432268", "Großmugl",
"437435", "Sankt\ Valentin",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"433119", "Sankt\ Marein\ bei\ Graz",
"436215", "Straßwalchen",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"433362", "Großpetersdorf",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"435446", "Sankt\ Anton\ am\ Arlberg",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"434253", "Sankt\ Jakob\ im\ Rosental",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"436241", "Sankt\ Koloman",
"4316", "Wien",
"437219", "Vorderweißenbach",
"437224", "Sankt\ Florian",
"432815", "Großschönau",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"433464", "Groß\ Sankt\ Florian",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"436277", "Sankt\ Pantaleon",
"434286", "Weißbriach",
"434843", "Außervillgraten",
"432742", "Sankt\ Pölten",
"433537", "Sankt\ Georgen\ ob\ Murau",
"432233", "Preßbaum",
"4312", "Wien",
"437565", "Sankt\ Pankraz",
"435245", "Hinterriß",
"434879", "Sankt\ Veit\ in\ Defereggen",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"432756", "Sankt\ Leonhard\ am\ Forst",
"434825", "Großkirchheim",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;