# Generated by default/object.tt
package Paws::ConnectContactLens::Categories;
  use Moose;
  has MatchedCategories => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has MatchedDetails => (is => 'ro', isa => 'Paws::ConnectContactLens::MatchedDetails', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ConnectContactLens::Categories

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ConnectContactLens::Categories object:

  $service_obj->Method(Att1 => { MatchedCategories => $value, ..., MatchedDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ConnectContactLens::Categories object:

  $result = $service_obj->Method(...);
  $result->Att1->MatchedCategories

=head1 DESCRIPTION

Provides the category rules that are used to automatically categorize
contacts based on uttered keywords and phrases.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MatchedCategories => ArrayRef[Str|Undef]

The category rules that have been matched in the analyzed segment.


=head2 B<REQUIRED> MatchedDetails => L<Paws::ConnectContactLens::MatchedDetails>

The category rule that was matched and when it occurred in the
transcript.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ConnectContactLens>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

