BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Exporter base constant strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.010; 1}) {
    print "Perl 5.010 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.73.
use strict;
use warnings;
use 5.010;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Unit tests for code that calls exit, exec, system or qx()",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Test2-Tools-Process",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME"             => "Test2::Tools::Process",
  "PM"               => {
    "lib/Test/Exec.pm"           => "\$(INST_LIB)/Test/Exec.pm",
    "lib/Test2/Tools/Process.pm" => "\$(INST_LIB)/Test2/Tools/Process.pm"
  },
  "PREREQ_PM" => {
    "Capture::Tiny"            => 0,
    "Class::Tiny"              => 0,
    "Ref::Util"                => 0,
    "Return::MultiLevel"       => 0,
    "Test2::API"               => "1.302015",
    "Test2::Compare"           => "0.000121",
    "Test2::Compare::Array"    => "0.000121",
    "Test2::Compare::Custom"   => "0.000121",
    "Test2::Compare::Number"   => "0.000121",
    "Test2::Compare::String"   => "0.000121",
    "Test2::Compare::Wildcard" => "0.000121",
    "Test2::Tools::Compare"    => "0.000121"
  },
  "TEST_REQUIRES" => {
    "Test2::V0"  => "0.000121",
    "Test::More" => "0.98"
  },
  "VERSION" => "0.07",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny"            => 0,
  "Class::Tiny"              => 0,
  "Ref::Util"                => 0,
  "Return::MultiLevel"       => 0,
  "Test2::API"               => "1.302015",
  "Test2::Compare"           => "0.000121",
  "Test2::Compare::Array"    => "0.000121",
  "Test2::Compare::Custom"   => "0.000121",
  "Test2::Compare::Number"   => "0.000121",
  "Test2::Compare::String"   => "0.000121",
  "Test2::Compare::Wildcard" => "0.000121",
  "Test2::Tools::Compare"    => "0.000121",
  "Test2::V0"                => "0.000121",
  "Test::More"               => "0.98"
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);