/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.lexicon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import opennlp.common.util.Pair;
import opennlp.grok.datarep.MorphItem;
import opennlp.grok.lexicon.XtagMorphDataIntf;
import opennlp.grok.util.GroupMap;

class XtagMorphDataFlat
implements XtagMorphDataIntf {
    private HashMap H = new HashMap();
    private Map S = new GroupMap();
    boolean printActivity = false;

    public XtagMorphDataFlat() {
    }

    public XtagMorphDataFlat(Properties g) {
        this();
        this.init(g);
    }

    public boolean init(Properties g) {
        InputStreamReader isr;
        String file = g.getProperty("morphdata");
        if (file == null) {
            return false;
        }
        try {
            isr = file.endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new URL(file).openStream())) : new InputStreamReader(new URL(file).openStream());
        }
        catch (Exception e) {
            System.out.println("Morph file exception (" + file + "):" + e);
            return false;
        }
        BufferedReader br = new BufferedReader(isr);
        try {
            String line = br.readLine();
            int c = 0;
            while (line != null) {
                if (!(line = line.trim()).startsWith(";")) {
                    int split = line.indexOf(32);
                    String word = line.substring(0, split).trim();
                    if (word.indexOf("'") == -1) {
                        String data = line.substring(split).trim();
                        this.H.put(word, data);
                    }
                    if (c++ % 1000 == 0) {
                        this.print(".");
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException IO) {
            IO.printStackTrace();
        }
        return true;
    }

    private void print(String s) {
        if (this.printActivity) {
            System.out.print(s);
        }
    }

    private void println(String s) {
        if (this.printActivity) {
            System.out.println(s);
        }
    }

    private void println() {
        if (this.printActivity) {
            System.out.println();
        }
    }

    private void addMorphItem(ArrayList morphItems, String word, String morphStr) {
        StringTokenizer mt = new StringTokenizer(morphStr);
        String stem = mt.nextToken();
        String pos = mt.nextToken();
        MorphItem mi = new MorphItem();
        mi.setWord(word);
        mi.setStem(stem);
        mi.setPOS(pos);
        while (mt.hasMoreTokens()) {
            String macro = mt.nextToken();
            mi.addMacro("@" + macro);
        }
        morphItems.add(mi);
    }

    private Collection getMorphItems(String word, String morphStr) {
        StringTokenizer st = new StringTokenizer(morphStr, "#");
        ArrayList morphItems = new ArrayList();
        while (st.hasMoreTokens()) {
            this.addMorphItem(morphItems, word, st.nextToken());
        }
        return morphItems;
    }

    public Collection getMorphItems(String word) {
        this.print("Retrieving: `" + word + "'");
        String morphStr = (String)this.H.get(word);
        if (morphStr == null) {
            this.println();
            return null;
        }
        Collection morphItems = this.getMorphItems(word, morphStr);
        this.println("  --> " + morphItems.size() + " results");
        return morphItems;
    }

    public Collection getHeadMorphs(String word) {
        this.print("Retrieving from head: `" + word + "'");
        Collection morphStrs = (Collection)this.S.get(word);
        HashSet morphItems = new HashSet();
        Iterator I = morphStrs.iterator();
        while (I.hasNext()) {
            Pair data = (Pair)I.next();
            morphItems.addAll(this.getMorphItems((String)data.a, (String)data.b));
        }
        this.println("  --> " + morphItems.size() + " results");
        return morphItems;
    }
}

