# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

package Avro;

use strict;
use 5.010_001;
our $VERSION = '++MODULE_VERSION++';

1;
__END__

=encoding utf-8

=head1 NAME

Avro - official Perl API for the Avro serialization and RPC framework

=head1 SYNOPSIS

  use Avro;

=head1 DESCRIPTION

=head1 AUTHOR

Apache Avro <dev@avro.apache.org>

=head1 HISTORY

Before contribution to the Apache Avro project, this module was 
developed by Yann KerhervE<eacute> <yannk@cpank.org> with contributions 
from Andy Grundman <andy@hybridized.org>, David Bushong 
<dbushong@mashlogic.com>, and Ilya Martynov <ilya@iponweb.net>.

=head1 COPYRIGHT

Copyright 2014 Apache Software Foundation.

=head1 LICENSE

The Apache License, Version 2.0
L<https://www.apache.org/licenses/LICENSE-2.0>

=head1 SEE ALSO

=cut
