package BSD::Tcpdrop;
require Exporter;
our @ISA = qw(Exporter);
our %EXPORT_TAGS = ( 'all' => [ qw(tcpdropbyname) ] );
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT = qw(tcpdropbyname);

our $VERSION = '0.00_01';
our $XS_VERSION = $VERSION;
$VERSION = eval $VERSION;

require XSLoader;
XSLoader::load('BSD::Tcpdrop', $XS_VERSION);

1
__END__
=head1 NAME

BSD::Tcpdrop - Perl extension for dropping TCP connections in *BSD

=head1 SYNOPSIS

  use BSD::Tcpdrop;
  tcpdropbyname($local_ip, $local_port, $foreign_ip, $foreign_port);

=head1 DESCRIPTION

Shameslessly steal the tcpdrop source from the BSD base system and
glue it to Perl with XS, so that we can now drop the TCP connection
within perl.

The source is stolen from git repository of DragonflyBSD

Tested on FreeBSD 11.1 and DragonflyBSD 4.9-DEVELOPMENT

=head2 EXPORT

tcpdropbyname($local_ip, $local_port, $foreign_ip, $foreign_port)
return true (1) when success
return false (0) if fail

=head1 SEE ALSO

https://www.freebsd.org/cgi/man.cgi?query=tcpdrop&sektion=8

https://www.freebsd.org/cgi/man.cgi?query=sysctl&apropos=0&sektion=3


=head1 AUTHOR

Baggio Kwok, E<lt>rootkwok@cpan.org<gt>

=cut
