
#ifndef P_EDIT_H
#define P_EDIT_H

#include <interface/TextView.h>

class pEdit : public BTextView
{
	public:
								pEdit(const char *name);
								~pEdit();

		void					FrameResized(float width, float height);
		
		inline bool				IsDirty() const;
		inline float			EmWidth() const;
		inline float			DefaultLineHeight() const;
		inline void				SetDirty(bool dirty);
		
	private:
		void					InsertText(const char *inText, int32 inLength,
											int32 inOffset, const text_run_array *inRuns);
		void					DeleteText(int32 fromOffset, int32 toOffset);

		bool					fDirty;
		float					fEmWidth;
		float					fDefLineHeight;
};

inline bool 	pEdit::IsDirty() const {return fDirty;}
inline float	pEdit::EmWidth() const {return fEmWidth;}
inline float 	pEdit::DefaultLineHeight() const {return fDefLineHeight;}
inline void 	pEdit::SetDirty(bool dirty) {fDirty = dirty;}

#endif
