
#include "pEdit.h"

#include <interface/PrintJob.h>
#include <interface/Window.h>

static const BRect dummyRect(0.0,0.0,0.0,0.0);

pEdit::pEdit(const char *name) :
	BTextView(dummyRect, name, dummyRect, B_FOLLOW_ALL_SIDES),
	fDirty(false),
	fEmWidth(0.0),
	fDefLineHeight(0.0)
{
	// use the font to determine the default line height
	font_height height;
	GetFontHeight(&height);
	fDefLineHeight = height.ascent + height.descent + height.leading;
	// typographically, the em (the width of M) is a standard unit of width
	// for a font with a roman character set
	fEmWidth = StringWidth("M");
	
	// if a printer has been set up, use its printable width
	// as the lineWidth
	float lineWidth = 0.0;
	BPrintJob job("job");
	BRect printRect = job.PrintableRect();
	if (printRect.IsValid())
		lineWidth = printRect.Width();
	else
		// no printer set up - use 45 ems
		lineWidth = 45.0 * fEmWidth;
	
	// build the text rect: lineWidth wide and 40 lines deep
	BRect frame(0.0, 0.0, lineWidth, 40.0 * fDefLineHeight);
	frame.InsetBySelf(-4.0, -4.0).OffsetTo(B_ORIGIN);
	ResizeTo(frame.Width(), frame.Height());
	SetTextRect(frame.InsetBySelf(4.0, 4.0));
}


pEdit::~pEdit()
{
}

void 
pEdit::FrameResized(float width, float height)
{
	SetTextRect(Bounds().InsetBySelf(4.0, 4.0));
}

void 
pEdit::InsertText(const char *inText, int32 inLength, int32 inOffset, const text_run_array *inRuns)
{
	BTextView::InsertText(inText, inLength, inOffset, inRuns);
	fDirty = true;
}

void 
pEdit::DeleteText(int32 fromOffset, int32 toOffset)
{
	BTextView::DeleteText(fromOffset, toOffset);
	fDirty = true;
}

