#ifndef QUEUE_H
#define QUEUE_H

#include "esoteric.h"
#include "sequence.h"

template <class AType> class queue
{
public:
	virtual	void	DeleteAll() = 0;
	virtual AType	Dequeue() = 0;
	virtual void	Enqueue(const AType val) = 0;
	virtual AType	Front() = 0;
	virtual bool	IsEmpty() const = 0;
};



template <class AType> class AQueueSequenceOf
{
public:
		AQueueSequenceOf(const unsigned long size);
		AQueueSequenceOf(const AQueueSequenceOf& other);
		
	virtual unsigned long	Capacity() const;
	virtual unsigned long	Size() const;
	
	// Implementation of queue protocol
	virtual	void	DeleteAll();
	virtual AType	Dequeue();
	virtual void	Enqueue(const AType val);
	virtual AType	Front();
	virtual int		IsEmpty() const;
	

protected:
	ASequenceOf<AType>	fData;		// The sequence that holds the data
	const unsigned long	fMaxSize;	// Max num items in queue
	unsigned long		fSize;		// How many items in queue
	unsigned long		fNextSlot;	// Where next item will be enqueued
	unsigned long		fFront;		// Where Front and Dequeue will get item from
};


//===================================================
// Implementation
//===================================================

//===================================================
// Implementation: AQueueSequenceOf
//===================================================

template <class AType> 
AQueueSequenceOf<AType>::AQueueSequenceOf(const unsigned long size)
	: fMaxSize(size),
	fData(size),
	fSize(0)
{
	// Initialize sequence to being empty
	DeleteAll();
}

template <class AType> 
AQueueSequenceOf<AType>::AQueueSequenceOf(const AQueueSequenceOf& other)
	: fMaxSize(other.fMaxSize),
	fData(other.fData),
	fNextSlot(other.fNextSlot),
	fFront(other.fFront),
	fSize(other.fSize)
{
}

template <class AType> 
void 
AQueueSequenceOf<AType>::DeleteAll()
{
	fNextSlot = 0;
	fFront = 0;
	fSize = 0;
}

template <class AType> 
int
AQueueSequenceOf<AType>::IsEmpty() const
{
	return (fNextSlot == fFront);
}


template <class AType>
unsigned long
AQueueSequenceOf<AType>::Capacity() const
{
	return fMaxSize;	
}

template <class AType> 
void
AQueueSequenceOf<AType>::Enqueue(const AType val)
{
	fData[fNextSlot] = val;
	fNextSlot++;
	if (fNextSlot >= fMaxSize)
		fNextSlot = 0;
		
	if (fSize < fMaxSize)
		fSize++;
}

template <class AType> 
AType
AQueueSequenceOf<AType>::Dequeue()
{
	if (IsEmpty())
		return fData[fFront];
		
	unsigned long dataloc = fFront;
	fFront++;
	if (fFront >= fMaxSize)
		fFront = 0;
	
	if (fSize > 0)
		fSize--;

	return fData[dataloc];
}

template <class AType> 
AType
AQueueSequenceOf<AType>::Front()
{
	return fData[fFront];
}


#endif
