#ifndef BOLTS_SEARCH
#define BOLTS_SEARCH

#include "sort.h"

template <class AType>
AType FindElement(ASequenceOf<AType>& aSequence, unsigned long N,
	unsigned long low, unsigned long high)
{
	unsigned long pivotIndex = (high + low) / 2;

	pivotIndex = Partition(aSequence, low, high, pivotIndex);

	if (pivotIndex == N)
		return aSequence[N];

	if (N < pivotIndex)
		return FindElement(aSequence, N, low, pivotIndex);
	else
   	return FindElement(aSequence, N, pivotIndex, high);
}

#endif
