/*
**	Copyright 2000 Be Incorporated. All Rights Reserved.
**	This file may be used under the terms of the Be Sample Code 
**	License.
*/

#include "InterfaceKit.h"
#include "SegmentItem.h"

#include <stdio.h>

const uint32 BESEG_DATA_MESSAGE = 'sgDA';

SegmentItem::SegmentItem(BPoint newStart, BPoint newEnd) : fStart(newStart), fEnd(newEnd)
{
}

//herein lies the magic of the archive protocol
SegmentItem::SegmentItem(BMessage *archive) : CadItem(archive)
{
	archive->FindPoint("fStart", 0,&fStart);
	archive->FindPoint("fEnd", 0, &fEnd);
}

status_t 
SegmentItem::Archive(BMessage *archive, bool deep = true) const
{
	status_t	result;
	
	result=CadItem::Archive(archive, deep);
	archive->what = BESEG_DATA_MESSAGE;
	
	archive->AddPoint("fStart", fStart);
	archive->AddPoint("fEnd", fEnd);
	
	return (result);
}

BArchivable *
SegmentItem::Instantiate(BMessage *archive)
{
	if ( validate_instantiation(archive, "SegmentItem")) {
		return new SegmentItem(archive);
	} else {
		printf("Failed SegmentItem Instantiation\n");
		return NULL;
	}
}

void
SegmentItem::DrawItem(BView *owner)
{
	owner->SetHighColor(255,255,255);
	owner->StrokeLine(fStart,fEnd);
}



