/*
**	Copyright 2000 Be Incorporated. All Rights Reserved.
**	This file may be used under the terms of the Be Sample Code 
**	License.
*/

#ifndef CadWindow_H
#define CadWindow_H

#include <Application.h>
#include <Window.h>
#include <FilePanel.h>
#include <Directory.h>
#include <Message.h>
#include <Entry.h>
#include <Path.h>


#include "CadPictureView.h"

class CadWindow : public BWindow
{
public:
	CadWindow();
	virtual bool QuitRequested();
	
private:
	virtual void 	MessageReceived (BMessage *message);
	float BuildMenuBar(BRect winRect);

//This is all menu stuff:
	BMenuBar	*fMenuBar;
	BMenu		*fMenuBarOptions;
	BMenuItem	*fMenuBarOptionsGrid;

//The actual View
	CadPictureView	*fCadView;	
//File Panels
	BFilePanel		*fSavePanel;
	BFilePanel		*fOpenPanel;
};

#endif