/*
**	Copyright 2000 Be Incorporated. All Rights Reserved.
**	This file may be used under the terms of the Be Sample Code 
**	License.
*/

#ifndef CadPictureWindow_H
#define CadPictureWindow_H

#include <Control.h>
#include <List.h>
#include <String.h>

const uint32 CADVIEW_INVOKED = 'Cdvi';

class CadPictureView : public BControl {
public:
	CadPictureView(BRect, char*);

//archive/instantiate protocol
	CadPictureView(BMessage *);
	status_t Archive(BMessage *, bool);
	CadPictureView *Instantiate(BMessage *);

	void MessageReceieved(BMessage *message);

	void AttachedToWindow(void);
	
	void KeyDown(const char *bytes, int32 numBytes);
	
	void MouseDown(BPoint pt);
	void MouseUp(BPoint pt);
	void MouseMoved(BPoint pt, uint32 code, const BMessage *msg);

	void Draw(BRect);
	
	void SetGraphState(bool);
	bool GetGraphState(void);
	
	void SetGridSize(float nsize);
	float GetGridSize(void);
	
	void SetFileName(const char *filename);
	const char *GetFileName() const;
	
	void Save(const char *filename);
	
	
private:
	BString		fFileName;
	BPoint		fTrackingStartPoint, fTrackingMovePoint;

	float		fZoomFactor;
	float		fGridSize;
	bool		fGraphState;

	BList		fItemList;
};

#endif