// copyall.cpp
//
// Syntax:  copyall source-file dest-file
//
// copyall does *not* use 'cp's syntax; it can't handle multiple source files,
// or destinations that are directories rather than files.

#include "CopyFile.h"
#include <storage/Entry.h>
#include <stdio.h>

int main(int argc, char** argv)
{
	if (argc != 3)
	{
		fprintf(stderr, "Syntax:  %s source-file destination-file\n", argv[0]);
		return 1;
	}

	// Convert a path to an entry_ref via the get_ref_for_path() function
	entry_ref srcRef;
	get_ref_for_path(argv[1], &srcRef);

	// Convert via a BEntry object
	entry_ref destRef;
	BEntry destEntry(argv[2]);
	destEntry.GetRef(&destRef);

	// copy the file and all its attributes!
	status_t err = CopyFile(srcRef, destRef, NULL, 0L, true, true);
	return (err != B_NO_ERROR);
}
