#include <Bitmap.h>

#include "colorutils.h"
#include "offscreenview.h"

OffscreenView::OffscreenView(BRect r)
	: BView(r, "OffscreenView", B_FOLLOW_NONE, 0), m_pb(0)
{
	MoveTo(0,0);
}

OffscreenView::~OffscreenView()
{
	if (m_pb)
		delete m_pb;
}

status_t OffscreenView::Begin()
{
	if (! m_pb) {
		m_pb = new BBitmap(Bounds(), B_RGBA32_HOST, true);
	}
	
	if (! m_pb->Lock()) {
		return B_ERROR;
	}
	
	m_pb->AddChild(this);
	return B_OK;
}

BBitmap* OffscreenView::End()
{
	Sync();
	m_pb->RemoveChild(this);
	m_pb->Unlock();
	
	BBitmap* pb = m_pb;
	m_pb = 0;
	return pb;
}
