#!/bin/sh

cd `dirname $0`

alert "This will install the InputRecorder." "Cancel" "Ok"
if [ $? -ne 1 ]
then
	exit 0
fi

# InputRecorder add-ons are loaded twice in installed in /boot/home as of R4
INPUTADDONS="/boot/beos/system/add-ons/input_server"

case `uname -m` in
BePC)
	CPU=x86
	;;
BeMac|BeBox)
	CPU=ppc
	;;
esac

function install_to() {
	if [ -e "$CPU/$1" ]
	then
		mkdir -p "$2"
		cp -av "$CPU/$1" "$2"
		if [ -e "$CPU/$1.xMAP" ]
		then
			cp -av "$CPU/$1.xMAP" "$2"
		fi
		if [ "$#" -ge 3 ]
		then
			mkdir -p "$3"
			ln -svf "$2/$1" "$3"
		fi
	fi
}

install_to InputRecorder /boot/home/config/bin /boot/home/Desktop
install_to inputRecorderDevice $INPUTADDONS/devices
install_to inputRecorderFilter $INPUTADDONS/filters

alert "Will now restart input server." "Cancel" "Ok"
if [ $? -eq 1 ]
then
	/system/servers/input_server -q
	sleep 1
	waitfor _input_server_event_loop_
else
	alert "Input device/filter will load in next reboot"
fi

alert "Install Complete" "Ok"

