#include <InterfaceKit.h>
#include "DragSelector.h"
#include "ThesaurusWindow.h"

extern const unsigned char kDraggerBits[];

DragSelector::DragSelector(BRect rect)
	:	BView(rect, "dragger", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW),
		fEnabled(false)
{
	SetViewColor(215, 215, 215);
	fBitmap = new BBitmap(BRect(0,0,31,31), B_COLOR_8_BIT);
	fBitmap->SetBits(kDraggerBits, 32 * 32, 0, B_COLOR_8_BIT);
}

DragSelector::~DragSelector()
{
	delete fBitmap;
}

void DragSelector::Enable()
{
	fEnabled = true;
	Invalidate();
}

void DragSelector::Disable()
{
	fEnabled = false;
	Invalidate();
}

void DragSelector::Draw(BRect)
{
	if (fEnabled)
		SetDrawingMode(B_OP_OVER);
	else
		SetDrawingMode(B_OP_BLEND);

	DrawBitmap(fBitmap);
}

void DragSelector::MouseDown(BPoint)
{
	if (!fEnabled)
		return ;

	// This is a bogus message.  When the targeted view receives it,
	// it will reply with B_MESSAGE_NOT_UNDERSTOOD, but the message will also
	// contain a messenger that we can use to communicate with the text view.
	BMessage garbage('junk');
	BBitmap *dragBitmap = new BBitmap(BRect(0,0,31,31), B_COLOR_8_BIT);
	dragBitmap->SetBits(kDraggerBits, 32 * 32, 0, B_COLOR_8_BIT);
	DragMessage(&garbage, dragBitmap, B_OP_BLEND, BPoint(16, 16), this);	
}

void DragSelector::MessageReceived(BMessage *msg)
{
	switch (msg->what) {
		case B_MESSAGE_NOT_UNDERSTOOD:
			// Make sure that the user didn't drop the message
			// on this window!
			if (!msg->IsSourceRemote())
				break;

			((ThesaurusWindow*)Window())->SetMessenger(
				msg->ReturnAddress());
			break;
						
		default:
			BView::MessageReceived(msg);
	}
}



const unsigned char kDraggerBits[] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
	0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x52,0x52,0x52,0x52,
	0x52,0x52,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x52,0x52,0x00,0x00,0x00,0x00,0x00,
	0x00,0x52,0x52,0x52,0x52,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x52,0x00,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x52,0x00,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x52,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x00,0x00,0xff,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x00,0x52,0x52,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
	0xff,0x00,0xff,0xff,0x00,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x00,0x00,0x00,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0x00,0xff,0xff,0x00,0xff,0xff,
	0xff,0x00,0xff,0xff,0x00,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x00,0x52,0x52,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,
	0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x52,0x00,0x52,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,
	0xff,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x52,0x00,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,
	0xff,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x52,0x52,0x52,0x52,0x00,0x52,0x52,0x52,
	0x52,0x00,0x52,0x52,0x52,0x52,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0x00,0xff,0xff,
	0xff,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0x52,0x52,0x00,0x00,0x00,0x00,0x00,
	0x00,0x52,0x52,0x52,0x52,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x52,0x52,0x52,0x52,
	0x52,0x52,0x00,0x00,0x00,0xaa,0xaa,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xaa,0xaa,0xaa,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
	0x00,0x00,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0xaa,0xaa,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xaa,0x00,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
};