//--------------------------------------------------------------------
//	
//	BitmapMenuItem.h
//
//	Written by: Owen Smith
//	
//	Copyright 1998 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#ifndef _BitmapMenuItem_h
#define _BitmapMenuItem_h

#include <Bitmap.h>
#include <MenuItem.h>

//====================================================================
//	CLASS: BitmapMenuItem

class BitmapMenuItem : public BMenuItem
{
	//----------------------------------------------------------------
	//	Constructors, destructors, operators

public:
					BitmapMenuItem(const char* name, const BBitmap& bitmap,
						BMessage* message, char shortcut = NULL,
						uint32 modifiers = NULL);
				
				
	//----------------------------------------------------------------
	//	Virtual member function overrides

protected:	
	void				Draw(void);
	void				GetContentSize(float* width, float* height);

	//----------------------------------------------------------------
	//	Accessors

public:
	void				GetBitmapSize(float* width, float* height);
	
	//----------------------------------------------------------------
	//	Member variables
	
private:
	BBitmap m_bitmap;	
};

#endif /* _BitmapMenuItem_h */