#ifndef _VIDEO_DEFS_H
#define _VIDEO_DEFS_H

#define B_NTSC_FRAME_RATE	29.97
#define B_PAL_FRAME_RATE	25.00

#define B_NTSC_H_MAX_SQ		640
#define B_NTSC_V_MAX_SQ		480
#define B_NTSC_H_MAX_RECT	720
#define B_NTSC_V_MAX_RECT	480

#define B_PAL_H_MAX_SQ		768
#define B_PAL_V_MAX_SQ		576
#define B_PAL_H_MAX_RECT	720
#define B_PAL_V_MAX_RECT	576

#define B_VIDEO_MAX_H		B_PAL_H_MAX_RECT
#define B_VIDEO_MAX_V		B_PAL_V_MAX_RECT
		
enum BVideoFieldSpecifier
{
	B_ODD_FIELD	,
	B_EVEN_FIELD,
	B_BOTH_FIELDS
};

enum BVideoFormat
{
	B_UNDEFINED_VIDEO_FORMAT,
	B_NTSC_M,
	B_NTSC_J,	
	B_PAL_B,
	B_PAL_D,
	B_PAL_G,
	B_PAL_H,
	B_PAL_I,
	B_PAL_M	,
	B_PAL_N	,
	B_SECAM
};

enum BTunerLocale
{
	B_UNDEFINED_LOCALE,
	B_US_NTSC_CABLE_IRC,
	B_US_NTSC_CABLE_HRC,	
	B_US_NTSC_AIR,
	B_JAPAN_NTSC_CABLE,
	B_JAPAN_NTSC_AIR,
	B_EUROPE_PAL_CABLE,
	B_EUROPE_PAL_AIR,
	B_GREAT_BRITAIN_PAL_CABLE,
	B_GREAT_BRITAIN_PAL_AIR,
	B_FM_RADIO
};

enum BVideoColorFormat
{
	B_UNDEFINED_VIDEO_COLOR_FORMAT,
	
						/* Little Endian Pixel Format */
	B_VIDEO_RGB32,		/* DW0: 0  R  G  B  */
	B_VIDEO_RGB24,		/* DW0: B1 R0 G0 B0 */
						/* DW1: G2 B2 R1 G1 */
						/* DW2: R3 G3 B3 R2 */
	B_VIDEO_RGB16,		/* DW0: R1[7:3],G1[7:2],B1[7:3],R0[7:3],G0[7:2],B0[7:3]     */
	B_VIDEO_RGB15,		/* DW0: 0,R1[7:3],G1[7:3],B1[7:3],0,R0[7:3],G0[7:3],B0[7:3] */
	B_VIDEO_YUV422,		/* DW0: Cr0 Y1  Cb0 Y0  */
						/* DW1: Cr2 Y3  Bb2 Y2  */
	B_VIDEO_YUV420,
	B_VIDEO_YUV411,		/* DW0: Y1  Cr0 Y0  Cb0 */
						/* DW1: Y3  Cr4 Y2  Cb4 */
						/* DW2: Y7  Y6  Y5  Y4  */
	B_VIDEO_Y8,			/* DW0: Y3  Y2  Y1  Y0  */
	B_VIDEO_RGB8		/* DW0: D3  D2  D1  D0  */
};

enum BVideoInputSource
{
	B_UNDEFINED_VIDEO_INPUT,
	B_COMPOSITE_0,
	B_COMPOSITE_1,
	B_COMPOSITE_2,
	B_COMPOSITE_3,
	B_COMPOSITE_4,
	B_COMPOSITE_5,
	B_COMPOSITE_6,
	B_COMPOSITE_7,
	B_SVIDEO_0,
	B_SVIDEO_1,
	B_SVIDEO_2,
	B_SVIDEO_3,
	B_SVIDEO_4,
	B_SVIDEO_5,
	B_SVIDEO_6,
	B_SVIDEO_7,
	B_TUNER_0,
	B_TUNER_1,
	B_TUNER_2,
	B_TUNER_3,
	B_TUNER_4,
	B_TUNER_5,
	B_TUNER_6,
	B_TUNER_7
};

enum BVideoAudioSource
{
	B_UNDEFINED_AUDIO_INPUT,
	B_COMPOSITE_AUDIO_0,
	B_COMPOSITE_AUDIO_1,
	B_COMPOSITE_AUDIO_2,
	B_COMPOSITE_AUDIO_3,
	B_COMPOSITE_AUDIO_4,
	B_COMPOSITE_AUDIO_5,
	B_COMPOSITE_AUDIO_6,
	B_COMPOSITE_AUDIO_7,
	B_SVIDEO_AUDIO_0,
	B_SVIDEO_AUDIO_1,
	B_SVIDEO_AUDIO_2,
	B_SVIDEO_AUDIO_3,
	B_SVIDEO_AUDIO_4,
	B_SVIDEO_AUDIO_5,
	B_SVIDEO_AUDIO_6,
	B_SVIDEO_AUDIO_7,
	B_TUNER_AUDIO_0,
	B_TUNER_AUDIO_1,
	B_TUNER_AUDIO_2,
	B_TUNER_AUDIO_3,
	B_TUNER_AUDIO_4,
	B_TUNER_AUDIO_5,
	B_TUNER_AUDIO_6,
	B_TUNER_AUDIO_7,
	B_FM_TUNER_AUDIO_0,
	B_FM_TUNER_AUDIO_1,
	B_FM_TUNER_AUDIO_2,
	B_FM_TUNER_AUDIO_3,
	B_FM_TUNER_AUDIO_4,
	B_FM_TUNER_AUDIO_5,
	B_FM_TUNER_AUDIO_6,
	B_FM_TUNER_AUDIO_7,
	B_MUTE_AUDIO
};

#endif
