
#ifndef Toolbox_h
#define Toolbox_h

#include "Tool.h"

class BToolbox : public BView
{
	protected:

		BLooper	*		m_toolLooper;
		BTool **		m_tools;
		int32			m_slots,m_slotsX,m_slotsY;
		int32			m_selection;
		
	public:
						BToolbox(BRect r, int32 xMatrix, int32 yMatrix);
						~BToolbox();
				
		status_t		AddTool(BTool *tool);
				
				BRect	ItemRect(int item);
				void	Select(int newSelection);
		virtual	void	Draw(BRect updateRect);
		virtual	void	MouseDown(BPoint p);
				void	InvokeTool(BMessage *msg);
};

class BToolboxWindow : public BWindow
{
	public:
						BToolboxWindow(BRect r);

		BToolbox *		Toolbox() { return m_toolbox; };
		BColorControl *	ColorSelector() { return m_colorSelector; };

	private:
	
		BToolbox *		m_toolbox;
		BColorControl *	m_colorSelector;
};

#endif
