
#include "PaintApp.h"
#include "BitmapDocument.h"
#include "BitmapEditor.h"
#include "Toolbox.h"

BBitmapEditor::BBitmapEditor(BRect rect, ulong resizeMode,
	ulong flags, BBitmapDocument *bitmap)
	: BView(rect,"BitmapEditor",resizeMode,flags|B_SUBPIXEL_PRECISE)
{
	m_bitmap = bitmap;
	m_bitmap->AddEditor(this);
	SetScale(1);
};

void BBitmapEditor::GetMaxSize(float *width, float *height)
{
	BRect r = m_bitmap->Bounds();
	*width = floor((r.right+1)*m_scale - 0.5);
	*height = floor((r.bottom+1)*m_scale - 0.5);
};

void BBitmapEditor::MessageReceived(BMessage *msg)
{
	switch (msg->what) {
		case bmsgBitmapDirty:
		{
			BRect r;
			BRegion reg;
			int iter=0;
			BMessage *m = msg;
			while (m) {
				iter = 0;
				while (m->FindRect("rect",iter++,&r) == B_OK) {
					float w = r.Width()+1;
					float h = r.Height()+1;
					r.left = floor(r.left * m_scale)-1;
					r.top = floor(r.top * m_scale)-1;
					r.right = floor(r.left + w*m_scale)+2;
					r.bottom = floor(r.top + h*m_scale)+2;
					reg.Include(r);
				};
				
				if (m!=msg) Window()->MessageQueue()->RemoveMessage(m);
				m = Window()->MessageQueue()->FindMessage(bmsgBitmapDirty);
			};
			ConstrainClippingRegion(&reg);	
			Draw(reg.Frame());
			ConstrainClippingRegion(NULL);
			break;
		};
		default:
			BView::MessageReceived(msg);
	};
};

BBitmapEditor::~BBitmapEditor()
{
	m_bitmap->RemoveEditor(this);
};

void BBitmapEditor::SetScale(float scale)
{
	m_scale = scale;
	FixupScrollbars();
	Invalidate();
};

float BBitmapEditor::Scale()
{
	return m_scale;
};

void BBitmapEditor::FrameResized(float width, float height)
{
	FixupScrollbars();	
};

void BBitmapEditor::AttachedToWindow()
{
	FixupScrollbars();
	SetViewColor(B_TRANSPARENT_32_BIT);
};

extern BLooper *currentTool;

void BBitmapEditor::MouseDown(BPoint point)
{
	BMessage msg(bmsgToolInvocation);
	rgb_color white = {255,255,255,255};
	rgb_color rgb = gColorSelector->ValueAsColor();

	BRect r(0,0,0,0);
	GetMaxSize(&r.right,&r.bottom);
	msg.AddRect("region",r);
	msg.AddPoint("point",point);
	msg.AddPointer("client",this);
	msg.AddData("fore",B_RGB_COLOR_TYPE,&rgb,sizeof(rgb_color));
	msg.AddData("back",B_RGB_COLOR_TYPE,&white,sizeof(rgb_color));
	msg.AddPoint("ulhc",B_ORIGIN);
	msg.AddFloat("scale",m_scale);
	msg.AddPointer("bitmap",m_bitmap);
	msg.AddInt32("button",Window()->CurrentMessage()->FindInt32("buttons"));
	gToolbox->InvokeTool(&msg);
};

void BBitmapEditor::Draw(BRect updateRect)
{
	BBitmap *b = m_bitmap->RealBitmap();
	BRect bnd = b->Bounds();
	BRect bnds(0,0,(bnd.right+1)*m_scale-1,(bnd.bottom+1)*m_scale-1);
	m_bitmap->ReadLock();
	DrawBitmap(b,bnd,bnds);
	Sync();
	m_bitmap->ReadUnlock();
};

void BBitmapEditor::FixupScrollbars()
{
	BRect bounds = Bounds();
	BScrollBar *sb;
	
	float myPixelWidth = bounds.Width();
	float myPixelHeight = bounds.Height();
	float maxWidth,maxHeight;
	GetMaxSize(&maxWidth,&maxHeight);
		
	float propW = myPixelWidth/maxWidth;
	float propH = myPixelHeight/maxHeight;
	
	float rangeW = maxWidth - myPixelWidth;
	float rangeH = maxHeight - myPixelHeight;
	
	if (sb=ScrollBar(B_HORIZONTAL)) {
		sb->SetProportion(propW);
		sb->SetRange(0,max(0,rangeW));
	};
	if (sb=ScrollBar(B_VERTICAL)) {
		sb->SetProportion(propH);
		sb->SetRange(0,max(0,rangeH));
	};
};
