
#ifndef Bitmap_h
#define Bitmap_h

#define	bmsgBitmapDirty		'bmpd'

class bgr_color {
public:
	uint8 b,g,r,a;

	bgr_color &operator=(const rgb_color &rgb)
	{
		b = rgb.blue;
		g = rgb.green;
		r = rgb.red;
		a = rgb.alpha;
		return *this;
	};
};

class BBitmapDocument {

	protected:

		BView *		m_view;
		BList 		m_editors;
		BBitmap *	m_bitmap;
		sem_id		m_readerLock;

	public:

					BBitmapDocument(float width, float height);
					BBitmapDocument(BFile *f);
					~BBitmapDocument();

		BBitmap *	RealBitmap() { return m_bitmap; };

		void		Lock();
		void		Unlock();
		void		ReadLock();
		void		ReadUnlock();

		BRect 		Bounds() { return m_bitmap->Bounds(); };
		void *		Bits() { return m_bitmap->Bits(); };
		color_space	ColorSpace() { return m_bitmap->ColorSpace(); };
		int32		BitsLength() { return m_bitmap->BitsLength(); };
		int32		BytesPerRow() { return m_bitmap->BytesPerRow(); };
				
		BView *		View() { return m_view; };
		void		SetDirty(BRegion *r);
		void		AddEditor(BView *v);
		void		RemoveEditor(BView *v);

		void		Load(BFile *f);
		void		Store(BFile *f);

		void		ResizeTo(float width, float height);

		bgr_color 	PixelAt(int x, int y) {
			return *((bgr_color*)(((char*)Bits()) + x*4 + y*BytesPerRow()));
		};
		rgb_color 	PixelAtRGB(int x, int y) {
			bgr_color c = *((bgr_color*)(((char*)Bits()) + x*4 + y*BytesPerRow()));
			rgb_color r;
			r.red = c.r;
			r.green = c.g;
			r.blue = c.b;
			r.alpha = c.a;
			return r;
		};
};

#endif
