#ifndef _stroke_h
#define _stroke_h

#include <Archivable.h>
#include "minivec.h"

/////////////////////////////////////////////////////////////////////////////
// Class: PenStroke
// ----------------
// Represents a single pen stroke.
class PenStroke : public BArchivable
{
// static methods
public:
	static __declspec(dllexport) BArchivable*
		Instantiate(BMessage* archive);

// construction, destruction, operators
public:
	PenStroke(float fPenSize);
private:
	PenStroke(BMessage* archive);

// overrides
public:
	virtual status_t Archive(BMessage* archive);

// accessors
public:
	BRect Bounds();
	void PushPoint(const BPoint& pt);
	int32 CountPoints();
	BPoint PointAt(int32 index);
	void PopPoint();
	
// operations
public:
	void DrawStroke(BView* target);
	void Fix();

// data members
private:
	float				m_fPenSize;
	MiniVec<BPoint>		m_pointList;
	BRect				m_rectBounds;

};

#endif /* _stroke_h */