#include <Debug.h>
#include <string.h>
#include <OS.h>
#include <Screen.h>
#ifndef _STDLIB_H
#include <stdlib.h>
#endif
#include <stdlib.h>
#include <Application.h>
#include <AppFileInfo.h>
#include <sys/time.h>

#include "proef.h"
#include <time.h>

#ifndef _INTERFACE_DEFS_H
#include <InterfaceDefs.h>
#endif

#ifndef _MESSAGEFILTER_H
#include <MessageFilter.h>
#endif

#define BIT_8	16384
#define BIT_32	16384

#define STROKE_LINE	32768

#define STROKE_ELLIPSE 16384
#define FILL_ELLIPSE 16384

#define	DSTRING 1024

#define FILL_RECT 16384
#define STROKE_RECT	16384

#define FILL_RRECT 16384
#define STROKE_RRECT	16384

#define	STROKE_CIRC 4096
#define FILL_CIRC 16384

#define STROKE_TRI	32768
#define	FILL_TRI 16384

#define STROKE_POLY	16384
#define FILL_POLY	2048

#define STROKE_ARC 4096
#define FILL_ARC 4096

#define	POLYS 32

#define BENCH 5000
#define TLOOP 1000

extern int clip;

// TShowBit	*proefb;




TShowBit::TShowBit(BRect r, long flags) :
	BView(r, "", flags, B_WILL_DRAW)
{
	BRect	bitmap_r, icon_r;
	long	ref;
	long	i;
	uchar	*bMap;
	uchar	*bits;


/* get icon stuff */
	app_info ai;
	BFile file;
	BAppFileInfo afi;

	be_roster->GetAppInfo("application/x-vnd.Be-Grafiek_Proef", &ai);
	file.SetTo(&ai.ref, B_READ_WRITE);
	afi.SetTo(&file);
/* get icon stuff */

	Fertig=0;

	busy = FALSE;
	exit_now = FALSE;
//	proefb = this;


	icon_r.Set(0, 0, 31, 31);
	bitmap_r.Set(0, 0, 31, 31);
	
	icon_bitmap= new BBitmap(icon_r, B_COLOR_8_BIT);
	the_bitmap= new BBitmap(bitmap_r, B_RGBA32_BIG);
	
	bMap = (uchar *)icon_bitmap->Bits();
	bits = (uchar *)the_bitmap->Bits();
	
	afi.GetIcon(icon_bitmap, B_LARGE_ICON);
	
//	clip=a_window->Wclip;

	

	icon_bitmap->SetBits(bMap, 2048, 0, B_COLOR_8_BIT);
//	the_bitmap->SetBits(bMap, 8192, 0, B_RGBA32_BIG);


    for(int crud=0;crud<(the_bitmap->BitsLength());crud++)
	  memset(bits, crud, (the_bitmap->BitsLength())-crud);
//	  memset(bits, 25, (the_bitmap->BitsLength())/2);
//	memset(bits+1000, 0x12, 31*31);
}


TShowBit::~TShowBit()
{
  delete icon_bitmap;
  delete the_bitmap;
}


void	TShowBit::DoDraw(BRect update_rect) {
	  
	
	StrokeAPoly(update_rect);      //updated
	FillAPoly(update_rect);        //updated
	Draw32Bitmap(update_rect);     //updated
	Draw8Bitmap(update_rect);      //updated
	StrokeAnArc(update_rect);      //updated
	FillAnArc(update_rect);        //updated
	StrokeALine(update_rect);      //updated
	DrawAString(update_rect);      //updated
	FillARect(update_rect);        //updated
	StrokeARect(update_rect);      //updated
	FillARoundRect(update_rect);   //updated
	StrokeARoundRect(update_rect); //updated
	StrokeATriangle(update_rect);  //updated
	FillATriangle(update_rect);    //updated
	FillAnEllipse(update_rect);    //updated
	StrokeAnEllipse(update_rect);  //updated
	StrokeACircle(update_rect);    //updated
	FillACircle(update_rect);      //updated


//	Test(update_rect);

	Fertig=1;

	exit(0);

}



void TShowBit::StrokeAPoly(BRect rect) {

	int X1, X2, Y1, Y2, i=0, colour=0;
	int colourR, colourG, colourB;
	long	startTime, stopTime;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokePoly=STROKE_POLY;

	int num_sides, shortX, shortY, min;
	BPoint Polygon[32];


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }

// test speed, set num polys to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
		num_sides=((double(rand())/RAND_MAX)*(POLYS-3))+3;

    	for(int j=0;j<num_sides;j++) {
	      Polygon[j].x=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      Polygon[j].y=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	    }
          
        colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
        colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
        colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		Window()->Lock();
        SetHighColor(colourR, colourG, colourB);
        StrokePolygon(Polygon, num_sides);
		Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  StrokePoly=int(BENCH/timeDiff);

      gettimeofday(&tpStart, NULL);
      for(i=0;i<StrokePoly;i++) {

		num_sides=((double(rand())/RAND_MAX)*(POLYS-3))+3;

    	for(int j=0;j<num_sides;j++) {
	      Polygon[j].x=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      Polygon[j].y=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	    }
	    	    
	    colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	    colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	    colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		Window()->Lock();
	    SetHighColor(colourR, colourG, colourB);
	    StrokePolygon(Polygon, num_sides);
   		Window()->Unlock();
      }
   	  gettimeofday(&tpEnd, NULL);

	  printf("StrokePolygon %ld \n", ((long) StrokePoly)/(tpEnd.tv_sec-tpStart.tv_sec));


}

void TShowBit::FillAPoly(BRect rect) {

	int X1, X2, Y1, Y2, i=0, colour=0;
	int colourR, colourG, colourB;
	long	startTime, stopTime;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillPoly=FILL_POLY;

	int num_sides, shortX, shortY, min;
	BPoint Polygon[32];

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num polys to fill
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
		num_sides=((double(rand())/RAND_MAX)*(POLYS-3))+3;

    	for(int j=0;j<num_sides;j++) {
	      Polygon[j].x=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      Polygon[j].y=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	    }
          
        colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
        colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
        colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		Window()->Lock();
        SetHighColor(colourR, colourG, colourB);
        FillPolygon(Polygon, num_sides);
        Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  FillPoly=int(BENCH/timeDiff);

      gettimeofday(&tpStart, NULL);
      for(i=0;i<FillPoly;i++) {

		num_sides=((double(rand())/RAND_MAX)*(POLYS-3))+3;
		
    	for(int j=0;j<num_sides;j++) {
	      Polygon[j].x=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      Polygon[j].y=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	    }


	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
	      SetHighColor(colourR, colourG, colourB);
	      FillPolygon(Polygon, num_sides);
	      Window()->Unlock();
      }
   	  gettimeofday(&tpEnd, NULL);

	  printf("FillPolygon %ld \n", ((long) FillPoly)/(tpEnd.tv_sec-tpStart.tv_sec));


}


void TShowBit::Draw32Bitmap(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int	DrawBitmaps=BIT_32, X1, X2, Y1, Y2, x1, x2, y1, y2;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// time test
    gettimeofday(&tpStart, NULL);
	for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          Window()->Lock();
	      DrawBitmap(the_bitmap, BPoint(x1, y1));
		  Window()->Unlock();
	}
	gettimeofday(&tpEnd, NULL);

    
    if(tpStart.tv_usec <= tpEnd.tv_usec)
      timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
    if(tpStart.tv_usec > tpEnd.tv_usec)
      timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);

    DrawBitmaps=int(BENCH/timeDiff);
// time test



    gettimeofday(&tpStart, NULL);
	for(i=0;i<DrawBitmaps;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
		  Window()->Lock();
	      DrawBitmap(the_bitmap, BPoint(x1, y1));
		  Window()->Unlock();
	}
	gettimeofday(&tpEnd, NULL);
	printf("32DrawBitmap %ld\n", ((long) DrawBitmaps)/(tpEnd.tv_sec-tpStart.tv_sec));

}



void TShowBit::Draw8Bitmap(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int	DrawBitmaps=BIT_8, X1, X2, Y1, Y2, x1, x2, y1, y2;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }

// time test
    gettimeofday(&tpStart, NULL);
	for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
		  Window()->Lock();
	      DrawBitmap(icon_bitmap, BPoint(x1, y1));
		  Window()->Unlock();
	}
	gettimeofday(&tpEnd, NULL);

    
    if(tpStart.tv_usec <= tpEnd.tv_usec)
      timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
    if(tpStart.tv_usec > tpEnd.tv_usec)
      timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);

    DrawBitmaps=int(BENCH/timeDiff);
// time test


//	time(&startTime);
    gettimeofday(&tpStart, NULL);
	for(i=0;i<DrawBitmaps;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          Window()->Lock();
	      DrawBitmap(icon_bitmap, BPoint(x1, y1));
		  Window()->Unlock();
	}
	gettimeofday(&tpEnd, NULL);
//	time(&stopTime);
//	printf("8DrawBitmap %ld \n", ((long) BIT_8)/(stopTime-startTime));
	printf("8DrawBitmap %ld\n", ((long) DrawBitmaps)/(tpEnd.tv_sec-tpStart.tv_sec));
}



void TShowBit::StrokeALine(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int	StrokeLines=STROKE_LINE, X1, X2, Y1, Y2, x1, x2, y1, y2;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  


// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
	      SetHighColor(colourR, colourG, colourB);
	      StrokeLine(BPoint(x1, y1), BPoint(x2, y2));
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  StrokeLines=int(BENCH/timeDiff);

//	  time(&startTime);
      gettimeofday(&tpStart, NULL);
      for(i=0;i<StrokeLines;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
	      SetHighColor(colourR, colourG, colourB);
	      StrokeLine(BPoint(x1, y1), BPoint(x2, y2));
		  Window()->Unlock();
      }
	  time(&stopTime);
	  gettimeofday(&tpEnd, NULL);
	  printf("StrokeLine %ld \n", ((long) StrokeLines)/(tpEnd.tv_sec-tpStart.tv_sec));
}

void TShowBit::DrawAString(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, y1;
	int myFontSize=12;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int DrawStrings=DSTRING;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }

// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
	      SetHighColor(colourR, colourG, colourB);
          SetFontSize((double(rand())/RAND_MAX)*128);
          DrawString("doh!!", BPoint(x1, y1));
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  DrawStrings=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<DrawStrings;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          SetFontSize((double(rand())/RAND_MAX)*128);
          DrawString("doh!!", BPoint(x1, y1));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("DrawString %ld \n", ((long) DrawStrings)/(tpEnd.tv_sec-tpStart.tv_sec));
 
 }
 
 
 void	TShowBit::FillARect(BRect rect) {
 
	int i=0;
	int colourR, colourG, colourB;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillRects=FILL_RECT;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillRect(BRect(x1, y1, x2, y2));
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  FillRects=int(BENCH/timeDiff);
	  
 
	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<FillRects;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillRect(BRect(x1, y1, x2, y2));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("FillRect %ld \n", ((long) FillRects)/(tpEnd.tv_sec-tpStart.tv_sec));
}

void	TShowBit::StrokeARect(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokeRects=STROKE_RECT;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }

// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeRect(BRect(x1, y1, x2, y2));
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  StrokeRects=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<StrokeRects;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeRect(BRect(x1, y1, x2, y2));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("StrokeRect %ld \n", ((long) StrokeRects)/(tpEnd.tv_sec-tpStart.tv_sec));
}


 void	TShowBit::FillARoundRect(BRect rect) {
 
	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float xRad, yRad;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillRRects=FILL_RRECT;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  xRad=(float(rand())/RAND_MAX)*MAXCOLOUR;
		  yRad=(float(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillRoundRect(BRect(x1, y1, x2, y2), xRad, yRad);
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke

	  FillRRects=int(BENCH/timeDiff);

 
	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<FillRRects;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  xRad=(float(rand())/RAND_MAX)*MAXCOLOUR;
		  yRad=(float(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillRoundRect(BRect(x1, y1, x2, y2), xRad, yRad);
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("FillRoundRect %ld \n", ((long) FillRRects)/(tpEnd.tv_sec-tpStart.tv_sec));
}

void	TShowBit::StrokeARoundRect(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float xRad, yRad;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokeRRects=STROKE_RRECT;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  xRad=(float(rand())/RAND_MAX)*MAXCOLOUR;
		  yRad=(float(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeRoundRect(BRect(x1, y1, x2, y2), xRad, yRad);
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke


	  StrokeRRects=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<StrokeRRects;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
	      x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
	      y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

          xRad=(float(rand())/RAND_MAX)*MAXCOLOUR;
          yRad=(float(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeRoundRect(BRect(x1, y1, x2, y2), xRad, yRad);
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("StrokeRoundRect %ld \n", ((long) StrokeRRects)/(tpEnd.tv_sec-tpStart.tv_sec));
}



void	TShowBit::StrokeATriangle(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, x3, y1, y2, y3;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokeTris=STROKE_TRI;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x3=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y3=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
      

          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeTriangle(BPoint(x1, y1), BPoint(x2, y2), BPoint(x3, y3));
		  Window()->Unlock();
     }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke


	  StrokeTris=int(BENCH/timeDiff);

  	  gettimeofday(&tpEnd, NULL);
	  for(i=0;i<StrokeTris;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x3=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y3=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
      

          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeTriangle(BPoint(x1, y1), BPoint(x2, y2), BPoint(x3, y3));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("StrokeTriangle %ld \n", ((long) StrokeTris)/(tpEnd.tv_sec-tpStart.tv_sec));
}


void	TShowBit::StrokeACircle(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	int shortX, shortY, min;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokeCircles=STROKE_CIRC;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }

// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

    
      if(clip == 0) {      
		  shortX=size_x-x1;
		  shortY=size_y-y1;
		  
		  min=shortX;
		  if(shortY<min) min=shortY;
		  if(x1<min) min=x1;
		  if(y1<min) min=y1;
		  
		  x2=(double(rand())/RAND_MAX)*(min/2);
	  }

	  else x2=(double(rand())/RAND_MAX)*MY_MAX_X;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeEllipse(BPoint(x1, y1), x2, x2);
		  Window()->Unlock();
     }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);

// test speed, set num lines to stroke

	  StrokeCircles=int(BENCH/timeDiff);

	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<StrokeCircles;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

    
      if(clip == 0) {      
		  shortX=size_x-x1;
		  shortY=size_y-y1;
		  
		  min=shortX;
		  if(shortY<min) min=shortY;
		  if(x1<min) min=x1;
		  if(y1<min) min=y1;
		  
		  x2=(double(rand())/RAND_MAX)*(min/2);
	  }

	  else x2=(double(rand())/RAND_MAX)*MY_MAX_X;


//	  x2=(double(rand())/RAND_MAX)*MY_MAX_X;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeEllipse(BPoint(x1, y1), x2, x2);
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("StrokeCircle %ld \n", ((long) StrokeCircles)/(tpEnd.tv_sec-tpStart.tv_sec));

}


void	TShowBit::FillATriangle(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, x3, y1, y2, y3;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillTris=FILL_TRI;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x3=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y3=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
      

          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillTriangle(BPoint(x1, y1), BPoint(x2, y2), BPoint(x3, y3));
		  Window()->Unlock();
     }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke


	  FillTris=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<FillTris;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x3=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y3=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
      

          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillTriangle(BPoint(x1, y1), BPoint(x2, y2), BPoint(x3, y3));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("FillTriangle %ld \n", ((long) FillTris)/(tpEnd.tv_sec-tpStart.tv_sec));
}



void	TShowBit::FillAnEllipse(BRect rect) {


	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillEllipses=FILL_ELLIPSE;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillEllipse(BRect(BPoint(x1, y1), BPoint(x2, y2)));
		  Window()->Unlock();
     }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke


	  FillEllipses=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<FillEllipses;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillEllipse(BRect(BPoint(x1, y1), BPoint(x2, y2)));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("FillEllipse %ld \n", ((long) FillEllipses)/(tpEnd.tv_sec-tpStart.tv_sec));
}


void	TShowBit::StrokeAnEllipse(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokeEllipses=STROKE_ELLIPSE;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

	 	  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeEllipse(BRect(BPoint(x1, y1), BPoint(x2, y2)));
		  Window()->Unlock();
     }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num lines to stroke


	  StrokeEllipses=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<StrokeEllipses;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeEllipse(BRect(BPoint(x1, y1), BPoint(x2, y2)));
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("StrokeEllipse %ld \n", ((long) StrokeEllipses)/(tpEnd.tv_sec-tpStart.tv_sec));


}

void	TShowBit::FillACircle(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	int shortX, shortY, min;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillCircles=FILL_CIRC;

	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }

// test speed, set num lines to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

    
      if(clip == 0) {      
		  shortX=size_x-x1;
		  shortY=size_y-y1;
		  
		  min=shortX;
		  if(shortY<min) min=shortY;
		  if(x1<min) min=x1;
		  if(y1<min) min=y1;
		  
		  x2=(double(rand())/RAND_MAX)*(min/2);
	  }

	  else x2=(double(rand())/RAND_MAX)*MY_MAX_X;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillEllipse(BPoint(x1, y1), x2, x2);
		  Window()->Unlock();
     }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);

// test speed, set num lines to stroke

	  FillCircles=int(BENCH/timeDiff);

	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<FillCircles;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;

    
      if(clip == 0) {      
		  shortX=size_x-x1;
		  shortY=size_y-y1;
		  
		  min=shortX;
		  if(shortY<min) min=shortY;
		  if(x1<min) min=x1;
		  if(y1<min) min=y1;
		  
		  x2=(double(rand())/RAND_MAX)*(min/2);
	  }

	  else x2=(double(rand())/RAND_MAX)*MY_MAX_X;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillEllipse(BPoint(x1, y1), x2, x2);
		  Window()->Unlock();
	  }
  	  gettimeofday(&tpEnd, NULL);
	  printf("FillCircle %ld \n", ((long) FillCircles)/(tpEnd.tv_sec-tpStart.tv_sec));
}



void	TShowBit::StrokeAnArc(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float Arc, Span;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int StrokeArcs=STROKE_ARC;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
	  
// test speed, set num arcs to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      
          Arc=(float(rand())/RAND_MAX)*360;
          Span=(float(rand())/RAND_MAX)*360;	 

		  Window()->Lock();
	      SetHighColor(colourR, colourG, colourB);
	      StrokeArc(BRect(BPoint(x1, y1), BPoint(x2, y2)), Arc, Span);
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num arcs to stroke

	  StrokeArcs=int(BENCH/timeDiff);


//	  time(&startTime);
	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<StrokeArcs;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;
          
          Arc=(float(rand())/RAND_MAX)*360;
          Span=(float(rand())/RAND_MAX)*360;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          StrokeArc(BRect(BPoint(x1, y1), BPoint(x2, y2)), Arc, Span);
		  Window()->Unlock();
	  }
//	  time(&stopTime);
   	  gettimeofday(&tpEnd, NULL);

	  printf("StrokeArc %ld \n", ((long)StrokeArcs)/(tpEnd.tv_sec-tpStart.tv_sec));


}



void	TShowBit::FillAnArc(BRect rect) {

	int i=0;
	int colourR, colourG, colourB;
	long startTime, stopTime;
	int	X1, X2, Y1, Y2, x1, x2, y1, y2;
	float Arc, Span;
	float timeDiff=666;
	timeval tpStart, tpEnd;
	int FillArcs=FILL_ARC;


	  if (clip==0) {
	  	X1=0;
	  	Y1=0;
	  	X2=MY_MAX_X;
	  	Y2=MY_MAX_Y;
	  }
	  
	  if (clip==1) {
	  	X1=MIN_X;
	  	Y1=MIN_Y;
	  	X2=FULL_X;
	  	Y2=FULL_Y;
	  }
	  
// test speed, set num arcs to stroke
	  gettimeofday(&tpStart, NULL);
      for(i=0;i<TLOOP;i++) {
	      x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          

	      colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;
	      
          Arc=(float(rand())/RAND_MAX)*360;
          Span=(float(rand())/RAND_MAX)*360;	 

		  Window()->Lock();
	      SetHighColor(colourR, colourG, colourB);
	      FillArc(BRect(BPoint(x1, y1), BPoint(x2, y2)), Arc, Span);
		  Window()->Unlock();
      }
  	  gettimeofday(&tpEnd, NULL);

	  if(tpStart.tv_usec <= tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec)+((tpEnd.tv_usec-tpStart.tv_usec)/1000000.0);
	    
	  if(tpStart.tv_usec > tpEnd.tv_usec)
	    timeDiff=(tpEnd.tv_sec-tpStart.tv_sec-1)+(((tpEnd.tv_usec+1000000)-tpStart.tv_usec)/1000000.0);
// test speed, set num arcs to stroke

	  FillArcs=int(BENCH/timeDiff);


	  gettimeofday(&tpStart, NULL);
	  for(i=0;i<FillArcs;i++) {
          x1=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y1=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;
          x2=((double(rand())/RAND_MAX)*(X2-X1))+X1;
          y2=((double(rand())/RAND_MAX)*(Y2-Y1))+Y1;


          colourR=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourG=(double(rand())/RAND_MAX)*MAXCOLOUR;
          colourB=(double(rand())/RAND_MAX)*MAXCOLOUR;
          
          Arc=(float(rand())/RAND_MAX)*360;
          Span=(float(rand())/RAND_MAX)*360;

		  Window()->Lock();
          SetHighColor(colourR, colourG, colourB);
          FillArc(BRect(BPoint(x1, y1), BPoint(x2, y2)), Arc, Span);
		  Window()->Unlock();
	  }
   	  gettimeofday(&tpEnd, NULL);
	  printf("FillArc %ld \n", ((long)FillArcs)/(tpEnd.tv_sec-tpStart.tv_sec));


}


void	TShowBit::Test(BRect rect) {

  BPicture *old_picture = new BPicture();
  BeginPicture(old_picture); 
  StrokeLine(BPoint(0,0), BPoint(200,200)); 
  EndPicture(); 

  BPicture *new_picture = new BPicture();
  BeginPicture(new_picture); 
  DrawPicture(old_picture);
  StrokeLine(BPoint(50,50), BPoint(6,100)); 
  EndPicture(); 

//  DrawPicture(old_picture);
  DrawPicture(new_picture);
}
