#include <Debug.h>

#ifndef _OS_H
#include <OS.h>
#endif
#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _ROSTER_H
#include <Roster.h>
#endif
#ifndef	_BITMAP_H
#include <Bitmap.h>
#endif
#ifndef	_ALERT_H
#include <Alert.h>
#endif
#ifndef _STDLIB_H
#include <stdlib.h>
#endif
#ifndef _STRING_H
#include <string.h>
#endif

#include <stdio.h>

#ifndef _MESSAGEFILTER_H
#include <MessageFilter.h>
#endif

#include "proef.h"

#include <math.h>


class	TMainWindow : public BWindow {
public:
		TMainWindow(BRect bound, char *name, window_type type, long flags);
	void DispatchMessage(BMessage* m,BHandler* h) {
		switch(m->what) {
			case B_ZOOM: {
				break;
			}
			case B_MINIMIZE: {
				break;
			}
			case B_WINDOW_RESIZED: {
				break;
			}
			case B_WINDOW_MOVED: {
				break;
			}
			case B_WINDOW_ACTIVATED: {
				break;
			}
			case B_QUIT_REQUESTED: {
				break;
			}
			case B_SCREEN_CHANGED: {
				break;
			}
			case B_WORKSPACE_ACTIVATED: {
				break;
			}
			case B_WORKSPACES_CHANGED: {
				break;
			}
			case B_KEY_DOWN: {
				break;
			}
			case B_KEY_UP: {
				break;
			}
			case B_MOUSE_DOWN: {
				break;
			}
			case B_MOUSE_UP: {
				break;
			}
			case B_MOUSE_MOVED: {
				break;
			}
			case B_VIEW_RESIZED: {
				break;
			}
			case B_VIEW_MOVED: {
				break;
			}
			case B_VALUE_CHANGED: {
				break;
			}
			case B_PULSE: {
				break;
			}
			default: {
				break;
			}
		}
		if (m->what=='_QIT') return;
		BWindow::DispatchMessage(m,h);
	}

virtual		bool	QuitRequested();
private:
		TShowBit	*the_view;
};

 int clip=0;


TMainWindow::TMainWindow(BRect bound, char *name, window_type type, long flags)
	: BWindow(bound, name, type, flags)
{
	BRect		a_rect;

	a_rect.Set(0, 0, size_x, size_y);

	the_view = new TShowBit(a_rect, B_FOLLOW_TOP | B_FOLLOW_LEFT | B_WILL_DRAW);
	AddChild(the_view);
	SetPulseRate(150000);
	Show();
	the_view->DoDraw(a_rect);
}



bool	TMainWindow::QuitRequested() {
	
	if (the_view->busy) {
		the_view->exit_now = TRUE;
		PostMessage(B_QUIT_REQUESTED);
		return(FALSE);
	}
	exit(0);
	be_app->PostMessage(B_QUIT_REQUESTED, be_app);
	return true;
}


int main(int argc, char *argv[]) {

	BApplication	*my_app;
	TMainWindow	*a_window;
	BRect		a_rect;
	long	newtime;
	unsigned int seed=1;
	int WinClip=0;

	switch (argc) {
	  case 1:
		printf("rand_seed %d\n", seed);
	  	break;

	  case 2:
    	if(strncmp(argv[1], "-noclip\0", 8) == 0)
    		clip=1;
        else {
              printf("Usage %s [-seed int] [-noclip]\n", argv[0]);
	 	      exit(1);
	 	     }
	    break;
	  

	  case 3:
    	if (strncmp(argv[1], "-seed\0", 6) == 0) {
    	  seed = atoi(argv[2]);
          printf("seed %d\n", seed);
          srand(seed);
        }
          
        else {
            printf("Usage %s [-seed int] [-noclip]\n", argv[0]);
			exit(1);
        }
	    break;
	  

	  case 4:
    	if(strncmp(argv[1], "-noclip\0", 8) == 0) {
    		clip=1;
    		if(strncmp(argv[2], "-seed\0", 6) == 0) {
	  	      seed = atoi(argv[3]);
              printf("rand_seed %d\n", seed);
              srand(seed);
            }
            else {
              printf("Usage %s [-seed int] [-noclip]\n", argv[0]);
	 	      exit(1);
	 	    }
        }
        
    	else if (strncmp(argv[1], "-seed\0", 6) == 0) {
    	  seed = atoi(argv[2]);
          printf("seed %d\n", seed);
          srand(seed);
          
          if(strncmp(argv[3], "-noclip\0", 8) == 0)
            clip=1;
          else {
            printf("Usage %s [-seed int] [-noclip]\n", argv[0]);
			exit(1);
          }
        }
    		        
        break;

	  default:
	 	printf("Usage %s [-seed int] [-noclip]\n", argv[0]);
	 	exit(1);
	}	      	
        


	set_thread_priority(find_thread(NULL), B_NORMAL_PRIORITY);
	
	my_app = new BApplication("application/x-vnd.Be-Grafiek_Proef");

	a_rect.Set(0, 0, size_x, size_y);
	a_window = new TMainWindow(a_rect, "Grafiek_Proef", B_TITLED_WINDOW,
		 B_NOT_ZOOMABLE);
//	a_window->Wclip=WinClip;
//	the_view->clip=666;
	my_app->Run();

	delete my_app;
	return(0);
}
