/* DDWindow.cpp */
#include <Application.h>
#include <Menu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include "DDWindow.h"
#include "MsgVals.h"

const BRect rect(50,50,600,600);

/*-------------------------------------------------------------------------*/

DDWindow::DDWindow()
	: BWindow(rect, "DynaDraw!", B_TITLED_WINDOW, 0)
{
	/* Create a menubar, and the two submenus... */
	BMenuBar* mb = new BMenuBar(BRect(0,0,rect.right,15), "menubar");

	/* Menu one */
	BMenu* menu = new BMenu("File");
	menu->AddItem(new BMenuItem("About", new BMessage(B_ABOUT_REQUESTED)));
	menu->AddItem(new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED)));

	/* Both the About and Quit messages should be directed to be_app */
	menu->SetTargetForItems(be_app);
	mb->AddItem(menu);
	
	/* Menu two */
	menu = new BMenu("Controls");
	BMenuItem* tmpItem = new BMenuItem("Tweakables", new BMessage(TWEAK_REQ));
	tmpItem->SetTarget(be_app);
	menu->AddItem(tmpItem);
	
	tmpItem = new BMenuItem("Color", new BMessage(COLOR_REQ));
	tmpItem->SetTarget(be_app);
	menu->AddItem(tmpItem);
	
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("Clear Screen", new BMessage(CLEAR_SCREEN)));
	/* Target not specified for Clear, so the target will be DDWindow */
	mb->AddItem(menu);
	AddChild(mb);
	
	/* create the filter view and attach it to the window */
	float mb_height = mb->Bounds().Height();
	fv = new FilterView(BRect(0,mb_height,rect.right, 
							rect.bottom - mb_height));
	AddChild(fv);
	
	/* show the window */
	Show();
	
}
/*-------------------------------------------------------------------------*/

void
DDWindow::MessageReceived(BMessage* msg)
{
	switch(msg->what)
	{
	 case COLOR_CHG:
	 case MASS_CHG:
	 case DRAG_CHG:
	 case WIDTH_CHG:
	 case FILL_CHG:
	 case ANGLE_CHG:
	 case SLEEPAGE_CHG:
	 case CLEAR_SCREEN:
	 	PostMessage(msg, fv);
		break;	

	 default:
	 	/* always pass on messages we don't understand */
	 	BWindow::MessageReceived(msg);
	 	break;
	}
}

/*-------------------------------------------------------------------------*/

bool 
DDWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}
/*-------------------------------------------------------------------------*/

