#include "netconfig.h"
#include <NetDevice.h>
#include <stdio.h>
#include <stdlib.h>
#include <socket.h>
#include <netdb.h>
#include "ether_driver.h"
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <Handler.h>
#include <TextControl.h>
#include <Window.h>
#include <Button.h>
#include <PopUpMenu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <TextView.h>
#include <MessageFilter.h>
#include "EtherDevice.h"

class GenericDevice : public EtherDevice {
public:
	int Start(const char *device);
};

class GenericConfig : public BNetConfig {
	const char *title;
	const char *config;
	const char *link;
public:
	GenericConfig(const char *title, const char *config, const char *link) {
		this->title = title;
		this->config = config;
		this->link = link;
	}
	int GetPrettyName(char *pretty_name, int len) {
		int totlen = strlen(title) + 1;
		if (len < totlen) {
			return (-totlen);
		}
		strcpy(pretty_name, title);
		return (totlen);
	}
	bool IsIpDevice(void) { return (0); }
	status_t Config(const char *device, net_settings *ncw,
					BCallbackHandler *dallback, bool autoconf);
};

