
#ifndef ToolLib_h
#define ToolLib_h

#include "Tool.h"

class BPenTool : public BTool
{
				float				m_fudge;

	public:
		virtual	void				StartUsing();
		virtual	void				PointerMoved(BPoint newPoint);
		virtual	void				DrawIcon(BView *drawInto, BRect location);
};

class BRectBasedTool : public BTool
{
	private:

				BRect				m_theRect;

	protected:
	
				bool				m_fill;
			
	public:
									BRectBasedTool(bool fill);
		virtual	void				StartUsing();
		virtual	void				PointerMoved(BPoint newPoint);
		virtual	void				StopUsing();
		virtual	void				DrawIcon(BView *drawInto, BRect location);

		virtual	void				DrawPrimitive(BView *drawInto, BRect r)=0;
		virtual	void				InvalPrimitive(BRegion *inval, BRect r)=0;
		virtual	void				GetDeltaInval(BRegion *inval, BRect oldRect, BRect newRect)=0;
};

class BRectTool : public BRectBasedTool
{
	public:
									BRectTool(bool fill=false)
										: BRectBasedTool(fill) {};

		virtual	void				DrawPrimitive(BView *drawInto, BRect r);
		virtual	void				InvalPrimitive(BRegion *inval, BRect r);
		virtual	void				GetDeltaInval(BRegion *inval, BRect oldRect, BRect newRect);
};

class BEllipseTool : public BRectBasedTool
{
	public:
									BEllipseTool(bool fill=false)
										: BRectBasedTool(fill) {};

		virtual	void				DrawPrimitive(BView *drawInto, BRect r);
		virtual	void				InvalPrimitive(BRegion *inval, BRect r);
		virtual	void				GetDeltaInval(BRegion *inval, BRect oldRect, BRect newRect);
};

#endif
