
#include "PaintApp.h"
#include "BitmapDocument.h"
#include "BitmapEditor.h"
#include "BitmapEditorWindow.h"
#include "Toolbox.h"
#include "ToolLib.h"

BToolbox *		gToolbox;
BColorControl *	gColorSelector;

PaintApp::PaintApp() : BApplication("application/x-vnd.Be-QuickPaint")
{
	BBitmapDocument *bm = new BBitmapDocument(320,240);

	BRect r(80,25,263,263);
	BWindow *w = new BBitmapEditorWindow(r,bm);
	w->Show();

	r.Set(200,40,400,540);
	BToolboxWindow *tb = new BToolboxWindow(r);
	gToolbox = tb->Toolbox();
	gColorSelector = tb->ColorSelector();
	tb->Show();

	gToolbox->AddTool(new BPenTool());
	gToolbox->AddTool(new BRectTool(true));
	gToolbox->AddTool(new BRectTool(false));
	gToolbox->AddTool(new BEllipseTool(true));
	gToolbox->AddTool(new BEllipseTool(false));
};

PaintApp::~PaintApp()
{
};

int main()
{
	PaintApp *p = new PaintApp();
	p->Run();
	delete p;
};
