//******************************************************************************
//
//	File:			SendPanel.h
//
//	Written by:		Douglas Wright (with code stolen from Tracker;)
//
//	Copyright 1998, Be Incorporated, All Rights Reserved.
//
//******************************************************************************

#ifndef	_SEND_PANEL_H
#define _SEND_PANEL_H

#include <TypedList.h>
#include <Window.h>
#include <View.h>

class SendView;

const int32	_VOLUME_ITEM_ = 'Fvol';
const int32	_ATTR_MAIN_ = 'Fatr';

const int32	_BY_NAME_ = 'Fbyn';
const int32	_BY_ATTR_ = 'Fbya';
const int32	_BY_FORMULA_ = 'Fbyq';

const int32	_ALL_ITEMS_ = 'Fall';
const int32	_ALL_VOLUMES_ = 'Favl';

const int32	_ADD_ = 'Fadd';
const int32	_REMOVE_ = 'Frem';

class SendPanel : public BWindow {

public:
	SendPanel();
	virtual ~SendPanel();
	
	virtual	void MessageReceived(BMessage*);
	void SetMessenger(BMessenger *msgr);

private:
	BMessenger *fMessenger;	
};


class SpecifierView;
class BBox;
class BTextControl;
class BCheckBox;
class BMenuField;

class SendView : public BView {

public:
	SendView(BRect);
	virtual ~SendView();

	virtual	void AttachedToWindow();
	virtual	void MessageReceived(BMessage*);

	void AddMessageTypesToMenu();
	void AddMessageTypesToMenu(BPopUpMenu *);
	
	void BuildMessage(BMessage *) const;

	static BRect InitialViewSize();

private:
	
	void AddSpecifierView();
	void RemoveSpecifierView();
	void AddFirstSpecifier();
	
	void AddItems();
	void RemoveItems();
	void AddOneSpecifierItem(BBox *box, const BRect);

	void SetUpAddRemoveButtons(BBox *box);

	TypedList<SpecifierView *> SpecifierViewList;
	BPopUpMenu *fMessageTypeMenu;
	BPopUpMenu *fSpecifierTypeMenu;

};

class SpecifierView : public BView {
public:
	SpecifierView(BRect);
	~SpecifierView();
	
	virtual void AttachedToWindow();
	
	virtual	void Draw(BRect);
	virtual	void MessageReceived(BMessage *);
	
private:
	BMenuField *menuField;
	BTextControl *textControl;
	
};


#endif
