//******************************************************************************
//
//	File:			SendPanel.cpp
//
//	Written by:		Douglas Wright
//
//	Copyright 1998, Be Incorporated, All Rights Reserved.
//
//******************************************************************************

#include "SendPanel.h"

const BRect kPanelRect(120, 100, 550, 320);

const int32 SEND_MSG = 'send';
const int32 ADD_MSG	= 'addm';
const int32 REMOVE_MSG = 'remm';
const int32 POP_UP = 'popu';

const bigtime_t HUGE_TIMEOUT = 1000000;

/* Send Panel */
SendPanel::SendPanel(BMessenger *msgr)
	:BWindow(kPanelRect, "Send", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	SendView *view = new SendView(Bounds());
	view->SetMessenger(msgr);
	AddChild(view);
}

SendPanel::~SendPanel()
{
}

void 
SendPanel::MessageReceived(BMessage *msg)
{
	BWindow::MessageReceived(msg);
}

/* Send View */
SendView::SendView(BRect rect)
	:BView(rect, "SendView", B_FOLLOW_ALL, B_WILL_DRAW)
{
}


SendView::~SendView()
{
}

void 
SendView::AttachedToWindow()
{
	SetViewColor(200,200,200,255);
	SetLowColor(200,200,200,255);
	
	BRect bounds(Bounds());
	bounds.InsetBy(15, 30);
	bounds.bottom -= 100;
	AddChild(new BBox(bounds, "Box"));

	AddSpecView();
	
	// add popup for message types
	fMessageTypeMenu = new BMenu("MessageTypeMenu");
	fMessageTypeMenu->AddItem(new BMenuItem("B_GET_PROPERTY", new BMessage(B_GET_PROPERTY)));
	fMessageTypeMenu->AddItem(new BMenuItem("B_SET_PROPERTY", new BMessage(B_SET_PROPERTY)));
	fMessageTypeMenu->AddItem(new BMenuItem("B_CREATE_PROPERTY", new BMessage(B_CREATE_PROPERTY)));
	fMessageTypeMenu->AddItem(new BMenuItem("B_DELETE_PROPERTY", new BMessage(B_DELETE_PROPERTY)));
	fMessageTypeMenu->AddItem(new BMenuItem("B_GET_SUPPORTED_SUITES", new BMessage(B_GET_SUPPORTED_SUITES)));
	fMessageTypeMenu->ItemAt(0)->SetMarked(true);
	fMessageTypeMenu->SetLabelFromMarked(true);
	
	BRect rect(bounds);
	rect.top -= 25;
	rect.right = rect.left + 200;
	rect.bottom = rect.top + 15;
	BMenuField* menuField = new BMenuField(rect, "MenuField", "Message Type:", fMessageTypeMenu);
	menuField->SetDivider(75.0);
	AddChild(menuField);

	// add Search button
	rect = Bounds();
	rect.left = rect.right - 85;
	rect.top = rect.top + 97;
	rect.right = rect.left + 60;
	rect.bottom = rect.top + 20;
	BButton* button = new BButton(rect, "send", "Send",
		new BMessage(SEND_MSG), B_FOLLOW_RIGHT + B_FOLLOW_BOTTOM);
	AddChild(button);
	button->SetTarget(this);

	// add Text Interface
	BRect r(Bounds());
	r.InsetBy(15, 10);
	r.right -= 15;
	r.top += 120;
	BRect f(r);
	f.OffsetTo(B_ORIGIN);
	f.left += 2;
	f.top += 2;
	fText = new BTextView(r, "textview", f, 
										B_FOLLOW_ALL, 
         								B_WILL_DRAW);
	BScrollView *scview = new BScrollView("scroller", fText, 
         								B_FOLLOW_BOTTOM | B_FOLLOW_LEFT, 
         								0, false, true, B_FANCY_BORDER);
    AddChild(scview);

}

void 
SendView::MessageReceived(BMessage *msg)
{
	switch(msg->what){
		case ADD_MSG:
			AddSpecView();
			break;
		case REMOVE_MSG:
			RemoveSpecView();
			break;
		case SEND_MSG:{
			printf("send\n");
			char *string;
			BMessage reply;			
			BMessage script_msg;
			BuildMessage(&script_msg);
			status_t result = fMessenger->SendMessage(&script_msg, &reply, HUGE_TIMEOUT, HUGE_TIMEOUT);
			if(result == B_OK){
				printf("sent\n");
				reply.PrintToStream();
				if(reply.FindString("result", 0, &string) == B_OK){
					fText->Insert(string);
					fText->Insert("\n");
				}
			}
			break;
		}
		default:
			BView::MessageReceived(msg);
	}
}

void 
SendView::BuildMessage(BMessage *msg) const
{
	BMenuItem *item = fMessageTypeMenu->FindMarked();
	msg->what = item->Command();
	int32 count = specViewList.CountItems();
	for(int i=0; i<count; i++){
		SpecView *spec = (SpecView *)specViewList.ItemAt(i);
		switch(spec->fMenu->Menu()->FindMarked()->Command()){
			case B_DIRECT_SPECIFIER:
				msg->AddSpecifier(spec->fText1->Text());
				msg->PrintToStream();
				break;
			default:
				break;
		}
	}	
}

void 
SendView::SetMessenger(BMessenger *msgr)
{
	fMessenger = msgr;
}

void 
SendView::AddSpecView()
{
	BBox *box = dynamic_cast<BBox *>(FindView("Box"));
	BRect bounds(Bounds());

	SpecView *previous = (SpecView *)specViewList.LastItem();
	
	if (previous) 
		Window()->ResizeBy(0, 30);

	bounds = Bounds();
	bounds.InsetBy(15, 30);
	bounds.bottom -= 100;

	if (previous) {
		box->ResizeTo(bounds.Width(), bounds.Height());
		bounds = previous->Frame();
		bounds.OffsetBy(0, 30);
	} else {
		bounds = box->Bounds();
		bounds.InsetBy(5, 5);
		bounds.bottom = bounds.top + 20;
	}

	SpecView *specView = new SpecView(bounds);
	specViewList.AddItem(specView);
	
	box->AddChild(specView);

	SetUpButtons(box);
}

void 
SendView::RemoveSpecView()
{
	if (specViewList.CountItems() < 2)
		return;

	BBox *box = (BBox*)FindView("Box");
	SpecView *specView = (SpecView *)specViewList.LastItem();
	if (!box || !specView)
		return;
	
	Window()->ResizeBy(0, -30);
	BRect bounds(Bounds());
	bounds.InsetBy(15, 30);
	bounds.bottom -= 100;
	box->ResizeTo(bounds.Width(), bounds.Height());

	specViewList.RemoveItem(specView);
	specView->RemoveSelf();
	delete specView;

	specView = (SpecView *)specViewList.ItemAt(specViewList.CountItems() - 1);

	if (specViewList.CountItems() != 1)
		return;
		
	BButton *button = (BButton*)Window()->FindView("remove");
	if (button)
		button->SetEnabled(false);

}

void 
SendView::SetUpButtons(BBox *box)
{
	BButton *button = (BButton*)Window()->FindView("remove");
	if (!button) {	
		BRect rect = box->Bounds();
		rect.InsetBy(5, 10);
		rect.top = rect.bottom - 20;
		rect.right = rect.left + 40;
		
		button = new BButton(rect, "add", "Add", new BMessage(ADD_MSG),
			B_FOLLOW_RIGHT + B_FOLLOW_BOTTOM);
		button->SetTarget(this);
		box->AddChild(button);
	
		rect.OffsetBy(50, 0);
		rect.right = rect.left + 55;
		button = new BButton(rect, "remove", "Remove", new BMessage(REMOVE_MSG),
			B_FOLLOW_RIGHT + B_FOLLOW_BOTTOM);
		
		button->SetEnabled(false);
		button->SetTarget(this);
		box->AddChild(button);
	}
	// enable remove button as needed
	button->SetEnabled(specViewList.CountItems() > 1);
}


/* Spec View */
SpecView::SpecView(BRect rect)
	:BView(rect, "SpecView", B_FOLLOW_NONE, B_WILL_DRAW)
{
	BRect			bounds;

	SetViewColor(200,200,200,255);
	SetLowColor(200,200,200,255);

	BPopUpMenu *menu = new BPopUpMenu("PopUp");

	menu->SetRadioMode(true);
	menu->SetFont(be_plain_font);

	menu->AddItem(new BMenuItem("B_DIRECT_SPECIFIER", new BMessage(B_DIRECT_SPECIFIER)));
	menu->AddItem(new BMenuItem("B_INDEX_SPECIFIER", new BMessage(B_INDEX_SPECIFIER)));
	menu->AddItem(new BMenuItem("B_NAME_SPECIFIER", new BMessage(B_NAME_SPECIFIER)));
	menu->AddItem(new BMenuItem("B_REVERSE_INDEX_SPECIFIER", new BMessage(B_REVERSE_INDEX_SPECIFIER)));
	menu->AddItem(new BMenuItem("B_RANGE_SPECIFIER", new BMessage(B_RANGE_SPECIFIER)));
	menu->AddItem(new BMenuItem("B_REVERSE_RANGE_SPECIFIER", new BMessage(B_REVERSE_RANGE_SPECIFIER)));
	menu->AddItem(new BMenuItem("B_ID_SPECIFIER", new BMessage(B_ID_SPECIFIER)));

	// mark first item
	menu->ItemAt(0)->SetMarked(true);
	
	bounds = Bounds();
	bounds.right = bounds.left + 120;
	bounds.bottom = bounds.top + 15;
	fMenu = new BMenuField(bounds, "MenuField", "", menu);
	fMenu->SetDivider(0.0);

	// add text entry box
	bounds = Bounds();
	bounds.left += bounds.right - 180;
	bounds.top += 2;
	bounds.right -= 42;
	fText1 = new BTextControl(bounds, "Text1", "", "", NULL);
	fText1->SetDivider(0.0);
}


SpecView::~SpecView()
{
}

void 
SpecView::AttachedToWindow()
{
	AddChild(fText1);
	fText1->MakeFocus();

	AddChild(fMenu);
	BMenu *menu = fMenu->Menu();

	// target everything
	menu->SetTargetForItems(this);
}

void 
SpecView::MessageReceived(BMessage *msg)
{
	BView::MessageReceived(msg);
}

