#ifndef OSKERNEL_H
#define OSKERNEL_H

#include <OS.h>

//=================================================
//
//=================================================
class ACondition
{
public:
				ACondition(const char *aName);
				ACondition(const ACondition&);
				~ACondition();
				
	ACondition& operator =(const ACondition&);
	
	long	InformOne();
	long	InformAll();
	
	long	Wait();
	
protected:
	sem_id	fSemaphore;
	
private:
	ACondition();
	
};

class AThread
{
public:

/*
	static thread_id	FindThread(const char *name); 
	static long			GetNthThreadInfo(team_id tmid, long n, thread_info *info);
*/

			AThread(const char *aName, long aPriority = B_NORMAL_PRIORITY);
	virtual	~AThread();
			
	status_t	GetInfo(thread_info *info);
	status_t	Kill();
	status_t	Resume();
	status_t	Suspend();
	status_t	Rename(const char *newName);
	status_t	SetPriority(long newPriority);
	status_t	Snooze(bigtime_t microseconds);
	status_t	WaitForExit (long *thread_return_value);
	
	thread_id	ThreadID() {return fThreadID;};
	
	// This is the main routine that you should implement
	// It is called by the Start() method when it's time to
	// actually start running the thread.
	virtual	status_t	ThreadMain();
	
protected:
	thread_id	fThreadID;
	
private:

};


#endif
