#ifndef NUMBERS_H
#define NUMBERS_H

//=======================================================
// Common international prefix for decimal multiples
//=======================================================
const double kyotta = 1.0E24;
const double kzetta = 1.0E21;
const double kexa = 1.0E18;
const double kpeta = 1.0E15;
const double ktera = 1.0E12;
const double kgiga = 1.0E9;
const double kmega = 1.0E6;
const double kkilo = 1.0E3;
const double khecto = 1.0E2;
const double kdeca = 10.0;
//const double kone = 1.0;
const double kdeci = .1;
const double kcenti = 1.0E-2;
const double kmilli = 1.0E-3;
const double kmicro = 1.0E-6;
const double knano = 1.0E-9;
const double kpico = 1.0E-12;
const double kfemto = 1.0E-15;
const double katto = 1.0E-18;
const double kzepto = 1.0E-21;
const double kyocto = 1.0E-24;

//=======================================================
// Common US names for decimal multiples
//=======================================================
const double kheptillion = 1.0E24;
const double khexillion = 1.0E21;
const double kquintillion = 1.0E18;
const double kquadrillion = 1.0E15;
const double ktrillion = 1.0E12;
const double kbillion = 1.0E9;
const double kmillion = 1.0E6;
const double kthousand = 1.0E3;
const double khundred = 1.0E2;
const double kten = 10.0;
const double kone = 1.0;
const double kzero = 0.0;
const double ktenth = .1;
const double khundreth = 1.0E-2;
const double kthousandth = 1.0E-3;
const double kmillionth = 1.0E-6;
const double kbillionth = 1.0E-9;
const double ktrillionth = 1.0E-12;
const double kquadrillionth = 1.0E-15;
const double kquintillionth = 1.0E-18;
const double khexillionth = 1.0E-21;
const double kheptillionth = 1.0E-24;


//
const double kPi	= 3.1415926535897932384626434;
const double kPiO2	= 1.5707963267948966192313217;
const double kPie	= 22.4591577183610454734271522;

//
const double ke		= 2.7182818284590452353602875;
const double kePi	= 23.1406926327792690057290864;


#endif
