#ifndef LOCK_H
#define LOCK_H


extern long test_and_set(volatile long *addr);

/*
	Protocol: PBinaryLock
	
	Your basic locking protocol
*/

class PBinaryLock
{
public:
	virtual	int Lock() = 0;
	virtual	int Unlock() = 0;
};

/*
	Class: ASpinLock
	
	A spinlock is the simplest of the exclusive locking
	mechanisms.  The calling process simply spins in a 
	loop until the lock is released.  This is a good
	quick and dirty lock to be used on critical areas
	that are not going to be locked for very long.
	These areas are typically the instance variables
	that are used by other forms of locks.
*/

class ASpinLock : public PBinaryLock
{
public:
		ASpinLock();
		
		int Lock();
		int Unlock();

protected:

private:		
	volatile long	fLockStatus;
};


/*
	Class: ASemaphore
	
	A semaphore is a synchronization mechanism with
	many uses including syncronization and exclusivity 
	enforcement.
*/

class ASemaphore
{
public:
			ASemaphore();
			ASemaphore(const long initCount);
			
		void	Wait();
		void	Signal();
		
protected:

private:
	ASpinLock	fLock;		// A spinlock to protect fields
	long		fCount;		// Current semaphore value
	
};


#endif
