#ifndef ASTRING_H
#define ASTRING_H

#include "esoteric.h"


//---- string -----------------------------------------------------------

class string
{
public:
			string();
			string(const string& other);
			~string();

			// Specialized constructors
			string(const char);
			string(const unsigned long size);
			string(const char *initial);


		// Assignment operators
		string&	operator=(const string& other);
		string&	operator=(const char aChar);
		string&	operator=(const char *aCString);

		char &	operator[](unsigned long) const;
				operator const char * () const;

		string&	operator+=(const string& other);

		unsigned long	length() const;
		int		compare(const string&) const;

   static	string&	GetEmptyString();
	static	unsigned long CStringLength(const char *);
	static	int	IsBlank(const char*);

protected:
	char *fBuffer;
	int	fBufferLength;

private:
};



//====================================
//  Comparison operators
//  For any class, there should be six
//  <, >, <=, >=, ==, !=
//====================================

inline int operator < (const string& left, const string& right)
{
	return left.compare(right) < 0;
}

inline int operator <= (const string& left, const string& right)
{
	return left.compare(right) <= 0;
}

inline int operator > (const string& left, const string& right)
{
	return left.compare(right) > 0;
}

inline int operator >= (const string& left, const string& right)
{
	return left.compare(right) >= 0;
}

inline int operator == (const string& left, const string& right)
{
	return left.compare(right) == 0;
}

inline int operator != (const string& left, const string& right)
{
	return left.compare(right) != 0;
}


//====================================
//  Simple math - Concatenation
//  +
//====================================
string operator+ (const string& left, const string& right);

#endif


