
#include <InterfaceKit.h>

#include "ObjectView.h"

class QuitWindow : public BWindow
{
public:
				QuitWindow(BRect r, char *name, window_type wt, ulong something)
					: BWindow(r,name,wt,something) {};
virtual bool	QuitRequested();
};

bool QuitWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
};

int main(int argc, char **argv)
{
    GLenum type = BGL_RGB | BGL_DEPTH | BGL_DOUBLE;
	BRect r(0,0,300,315);
	
	BApplication *app = new BApplication("application/x-vnd.Be-tpot");
	
	r.OffsetTo(BPoint(100,100));
	BWindow *win = new QuitWindow(r,"GL Teapot",B_TITLED_WINDOW,0);

	win->Lock();
	r = win->Bounds();
	r.bottom = r.top + 14;
	BMenuBar *mb = new BMenuBar(r,"main menu");

	BMenu *m;
	BMenuItem *i;
	BMessage msg (bmsgAddModel);

	mb->AddItem(m = new BMenu("Models"));
	win->AddChild(mb);
	mb->ResizeToPreferred();

	r = win->Bounds();
	r.top = mb->Bounds().bottom+1;
	BView *sv = new BView(r,"subview",B_FOLLOW_ALL,0);
	win->AddChild(sv);
	r = sv->Bounds();
	ObjectView *bgl = new ObjectView(r,"objectView",B_FOLLOW_NONE,type);
	sv->AddChild(bgl);
	
	msg.AddInt32("num",256);
	m->AddItem(i = new BMenuItem("Add a teapot",new BMessage(&msg)));
	i->SetTarget(bgl);	
	msg.RemoveName("num");
	mb->AddItem(m = new BMenu("Options"));
	m->AddItem(i = new BMenuItem("Perspective",new BMessage(bmsgPerspective)));
	i->SetTarget(bgl);
	i->SetMarked(false);
	m->AddItem(i = new BMenuItem("FPS Display",new BMessage(bmsgFPS)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	m->AddItem(i = new BMenuItem("Filled polygons",new BMessage(bmsgFilled)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	m->AddItem(i = new BMenuItem("Lighting",new BMessage(bmsgLighting)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	m->AddItem(i = new BMenuItem("Backface culling",new BMessage(bmsgCulling)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	m->AddItem(i = new BMenuItem("Z-buffered",new BMessage(bmsgZBuffer)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	m->AddItem(i = new BMenuItem("Gouraud shading",new BMessage(bmsgGouraud)));
	i->SetTarget(bgl);
	i->SetMarked(true);
//	m->AddItem(i = new BMenuItem("Texture mapped",new BMessage(bmsgTextured)));
//	i->SetTarget(bgl);
	m->AddItem(i = new BMenuItem("Fog",new BMessage(bmsgFog)));
	i->SetTarget(bgl);

	BMenu *sm;
	mb->AddItem(m = new BMenu("Lights"));
	msg.what = bmsgLights;

	msg.AddInt32("num",1);
	m->AddItem(i = new BMenuItem(sm = new BMenu("Upper center"),NULL));
	i->SetTarget(bgl);
	msg.AddInt32("color",lightNone);
	sm->AddItem(i = new BMenuItem("OFF",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightWhite);
	sm->AddItem(i = new BMenuItem("White",new BMessage(&msg)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	msg.ReplaceInt32("color",lightYellow);
	sm->AddItem(i = new BMenuItem("Yellow",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightBlue);
	sm->AddItem(i = new BMenuItem("Blue",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightRed);
	sm->AddItem(i = new BMenuItem("Red",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightGreen);
	sm->AddItem(i = new BMenuItem("Green",new BMessage(&msg)));
	i->SetTarget(bgl);

	msg.RemoveName("color");

	msg.ReplaceInt32("num",2);
	m->AddItem(i = new BMenuItem(sm = new BMenu("Lower left"),NULL));
	i->SetTarget(bgl);
	msg.AddInt32("color",lightNone);
	sm->AddItem(i = new BMenuItem("OFF",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightWhite);
	sm->AddItem(i = new BMenuItem("White",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightYellow);
	sm->AddItem(i = new BMenuItem("Yellow",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightBlue);
	sm->AddItem(i = new BMenuItem("Blue",new BMessage(&msg)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	msg.ReplaceInt32("color",lightRed);
	sm->AddItem(i = new BMenuItem("Red",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightGreen);
	sm->AddItem(i = new BMenuItem("Green",new BMessage(&msg)));
	i->SetTarget(bgl);

	msg.RemoveName("color");

	msg.ReplaceInt32("num",3);
	m->AddItem(i = new BMenuItem(sm = new BMenu("Right"),NULL));
	i->SetTarget(bgl);
	msg.AddInt32("color",lightNone);
	sm->AddItem(i = new BMenuItem("OFF",new BMessage(&msg)));
	i->SetTarget(bgl);
	i->SetMarked(true);
	msg.ReplaceInt32("color",lightWhite);
	sm->AddItem(i = new BMenuItem("White",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightYellow);
	sm->AddItem(i = new BMenuItem("Yellow",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightBlue);
	sm->AddItem(i = new BMenuItem("Blue",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightRed);
	sm->AddItem(i = new BMenuItem("Red",new BMessage(&msg)));
	i->SetTarget(bgl);
	msg.ReplaceInt32("color",lightGreen);
	sm->AddItem(i = new BMenuItem("Green",new BMessage(&msg)));
	i->SetTarget(bgl);

	float f = mb->Bounds().IntegerHeight()+1;
	win->SetSizeLimits(32,1024,32+f,1024+f);
	
	/*
	r = win->Bounds();
	r.top = mb->Bounds().bottom+1;
	sv->MoveTo(r.left,r.top);
	sv->ResizeTo(r.right-r.left+1,r.bottom-r.top+1);
	bgl->ResizeTo(r.right-r.left+1,r.bottom-r.top+1);
	*/
	
	win->Unlock();
	win->Show();
	
	app->Run();
	delete app;
	
	return 0;
}
