//#define DEBUG 1
#include <net/socket.h>
#include <net/netdb.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <support/Debug.h>
#include <app/Application.h>

#include "BTSNetMsgClient.h"
#include "BTSNetMsgUtils.h"

// =============================================================================
//     BTSNetMsgClient
// =============================================================================
BTSNetMsgClient::BTSNetMsgClient(const unsigned short port, 
								const char* serverHostName,
								BLooper* messageReceiver, 
								const int family, 
								const int type, 
								const int protocol,  
								const long priority): 
								BLooper(), 
								fSocket(port, serverHostName, type, protocol, 
										family),
								fAddress(port, serverHostName, family),
								fPriority(priority)
{
	// Make a socket connection and start listening for clients.
	fServerHostName	= ::strdup(serverHostName);
	fExiting = FALSE;
	fConnected = FALSE;
	
	if (messageReceiver == NULL)
	{
		messageReceiver = be_app;
	}
	fMessageReceiver = messageReceiver;
	return;
}


// =============================================================================
//     Run
// =============================================================================
thread_id
BTSNetMsgClient::Run()
{
	thread_id	id = -1;

	if (fSocket.InitCheck())
	{
		fSocketListenerID = spawn_thread(ListenToServer, "Client socket listener",
						fPriority, this);
		if (fSocketListenerID > 0)
		{
			resume_thread(fSocketListenerID);
			id = BLooper::Run();
			fConnected = TRUE;
		}
	}
	return id;
}


// =============================================================================
//     Quit
// =============================================================================
void
BTSNetMsgClient::Quit()
{
	fExiting = TRUE;
	if (fSocket.ID() > -1)
	{
		// Just disconnect.
		fSocket.Close();
	}
	
	BLooper::Quit();
	return;
}

// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSNetMsgClient::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSNetMsgClient::MessageReceived - ENTER\n"));
	if (!fExiting)
	{
		switch (inMessage->what)
		{
			case DEAD_CONNECTION_MSG:
				fConnected = FALSE;
				fSocket.Close();
			break;
			
			default:
				PRINT(("BTSNetMsgClient::MessageReceived - Sending message to server\n"));
				if (fConnected)	SendNetMessage(fSocket, inMessage);
			break;
		}
	}	
	PRINT(("BTSNetMsgClient::MessageReceived - EXIT\n"));
	return;
}

// =============================================================================
//     ListenToServer
// =============================================================================
long 
BTSNetMsgClient::ListenToServer(void* arg)
{
	BTSNetMsgClient* 	thisClient = (BTSNetMsgClient*)arg;
	BLooper*			messageReceiver = thisClient->MessageReceiver();
	struct fd_set		readBits;
	struct timeval 		tv;
	long 				result;
	BTSSocket 			socket = thisClient->Socket();
	int					socketID = socket.ID();
	bool				exit = FALSE;
	
	tv.tv_sec = 1;
	tv.tv_usec = 0;
	while (exit == FALSE)
	{
		FD_ZERO(&readBits);
		FD_SET(socketID, &readBits);
		if (::select(socketID + 1, &readBits, NULL, NULL, &tv) > 0)
		{
			if (FD_ISSET(socketID, &readBits))
			{
				PRINT(("BTSNetMsgClient::ListenToServer - SERVER MSG on %d\n", 
							socketID));
				BMessage newMessage;
				result = ReceiveNetMessage(socket, newMessage);
				if (result == B_NO_ERROR )
				{
					// Post it to the message receiver.
					messageReceiver->PostMessage(&newMessage);
				}
				
				else if (result == ECONNABORTED)
				{
					// Connection has died
					if (!thisClient->IsExiting())
					{
						thisClient->PostMessage(DEAD_CONNECTION_MSG);
					}
					exit = TRUE;
				}
			}

		}
	 	if (thisClient->IsExiting())
		{
			exit = TRUE;
		}
	}
	exit_thread(result);
	return result;
}
