// BTSClientSocket.h
/* A client socket allows for creation of a socket connection
   to a server. The necessary parameters needed to create the
   connection are passed to the constructor. The constructor 
   will block until either a connection has been made or the
   attempt has failed. The InitCheck() function should be used
   after construction to ensure the connection is valid.
   
*/


#pragma once
#ifndef _B_BTSCLIENTSOCKET_
#define _B_BTSCLIENTSOCKET_

#include "BTSSocket.h"

#pragma export on

class BTSClientSocket: public BTSSocket
{
	public:
						BTSClientSocket(const unsigned short port, 
								const char* serverHostName, 
								const int type = SOCK_STREAM, 
								const int protocol = IPPROTO_TCP, 
								const int family = AF_INET);
		virtual	bool	InitCheck();	
	private:
		BTSAddress		mAddress;				
};
#pragma export reset
#endif