#include <stdio.h>
#include <string.h>
#include <Bitmap.h>
#include <View.h>
#include <support/Debug.h>

#include "BTSServerMonitor.h"
#include "BTSNetMsgServer.h"
#include "BTSNetDrawServer.h"
#include "BTSNetDrawMsgDefs.h"

extern int _socket_signals;

const char* kMonitorTitle = "Draw Server";

main()
{	
	BTSNetDrawServer *myApplication;
	// Turn this on and set DEBUG to see debug output.
	//_setDebugFlag(TRUE);

	//_socket_signals = 0;
	myApplication = new BTSNetDrawServer();
	
	// Once everything is setup, start running the application.
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

// =============================================================================
//     BTSNetDrawServer
// =============================================================================
BTSNetDrawServer::BTSNetDrawServer(): BApplication('NTDW')
{
	BRect drawWindowRect(100,200,300,400);
	drawWindowRect.OffsetTo(B_ORIGIN);
	
	fBitmap = new BBitmap(drawWindowRect, B_MONOCHROME_1_BIT, TRUE);
	fView = new BView(drawWindowRect, "OffView", 0, B_NOT_RESIZABLE);	
	fBitmap->AddChild(fView);
	fServer = NULL;
	return;
}



// =============================================================================
//     ReadyToRun
// =============================================================================
void 
BTSNetDrawServer::ReadyToRun()
{
	fMonitor = new BTSServerMonitor(kMonitorTitle);
	fMonitor->Show();
	return;
}

// =============================================================================
//     QuitRequested
// =============================================================================
bool
BTSNetDrawServer::QuitRequested()
{
	if (fServer)
	{
		fServer->PostMessage(B_QUIT_REQUESTED);
	}
	return TRUE;
}

// =============================================================================
//     MessageReceived
// =============================================================================
void 
BTSNetDrawServer::MessageReceived(BMessage* inMessage)
{
	PRINT(("BTSNetDrawServer::MessageReceived - ENTER\n"));
	switch (inMessage->what)
	{		
		case NETDRAWLINE_MSG:
			PRINT(("BTSNetDrawServer - net line message start\n"));
			BPoint 	startPoint;
			BPoint 	endPoint; 
			if (inMessage->FindPoint("LineStart", &startPoint)== B_NO_ERROR && 
				inMessage->FindPoint("LineEnd", &endPoint) == B_NO_ERROR)
			{
				
				fBitmap->Lock();
				// Account for menu bar (bad way to do it)
				endPoint.y += 15;
				fView->MovePenTo(startPoint.x, startPoint.y+15);
				fView->StrokeLine(endPoint);
				fView->Sync();	
				fBitmap->Unlock();
							
				// Send it to all the other clients.
				DetachCurrentMessage();
				fServer->PostMessage(inMessage);	
				PRINT(("BTSNetDrawServer - net line message done\n"));
			}	
		break;
		
		case NEW_CLIENT_MSG:
			BTSSocket* socket;
			PRINT(("Got a new client message\n"));
			if (inMessage->FindPointer(SOURCE_SOCKET, &socket)==B_NO_ERROR)
			{
				PRINT(("Sending bitmap message to client\n"));
				// Send a message to the client's handler that contains
				// the current bitmap.
				BMessage 	message(BITMAP_DATA_MSG);
				long 		bitmapSize = fBitmap->BitsLength();
				void* 		bitmapData = fBitmap->Bits();
				if (message.AddData("Bitmap", B_RAW_TYPE, bitmapData, bitmapSize) == B_NO_ERROR)
				{

					if (message.AddPointer(TARGET_SOCKET, socket) == B_NO_ERROR)
					{
						PRINT(("Posting bitmap message\n"));
						fServer->PostMessage(&message);
					}
				}
				fMonitor->AddClient();
			}
		break;
		
		case CLEAR_MSG:
			void* buf = fBitmap->Bits();
			long numBytes = fBitmap->BitsLength();
			memset(buf, 0, numBytes);
			fBitmap->Lock();
			fBitmap->SetBits(buf, numBytes, 0, B_MONOCHROME_1_BIT);
			//fView->Sync();
			fBitmap->Unlock();

			// Send it to all the other clients.
			fServer->PostMessage(inMessage);			
		break;
		
		case DEAD_CONNECTION_MSG:
			fMonitor->RemoveClient();
		break;
		
		case START_SERVING_MSG:
			{
				bool useLoopback = inMessage->FindBool(USE_LOOPBACK);
				StartServing(useLoopback);
			}
		break;
		
		default:
			BApplication::MessageReceived(inMessage);
		break;
	}
	return;
	PRINT( ("BTSNetDrawServer::MessageReceived - ENTER\n"));
}



// =============================================================================
//     StartServing
// =============================================================================
void 
BTSNetDrawServer::StartServing(bool useLoopback)
{
	if (!useLoopback)
	{
		fServer = new BTSNetMsgServer(kNETDRAWPORT);
	}
	else
	{
		fServer = new BTSNetMsgServer(kNETDRAWPORT, this, B_URGENT_PRIORITY,
										MAX_CONNECTIONS, INADDR_LOOPBACK);
	}
	fServer->Run();
	return;
}