// =============================================================================
//     BTSDrawView.h
// =============================================================================
// A view that implements MouseMoved() and generates draw messages as long as
// the mouse button is down.

#ifndef _B_BTSDRAWVIEW
#define _B_BTSDRAWVIEW

#include <interface/View.h>

class BTSDrawView : public BView
{
	public:
						BTSDrawView(BRect frame, BBitmap* bitmap);
		virtual void 	MouseDown(BPoint where);

		virtual void	MouseMoved(BPoint where, ulong code, 
									const BMessage *a_message);
		virtual void	Draw(BRect updateRect);
		virtual void	SetLineStart(const BPoint& startPoint);
		virtual bool	IsExiting() const;
		virtual void	SetExiting(const bool value);
	private:
		BBitmap*		fBitmap;
		BPoint			fLastPoint;
		bool			fExiting;
};


#endif